"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomEventFilter = void 0;
const typebox_1 = require("@sinclair/typebox");
const StringlyTypedMatrix_1 = require("../MatrixTypes/StringlyTypedMatrix");
exports.RoomEventFilter = typebox_1.Type.Object({
    limit: typebox_1.Type.Optional(typebox_1.Type.Number()),
    senders: typebox_1.Type.Optional(typebox_1.Type.Array(StringlyTypedMatrix_1.StringUserIDSchema)),
    not_senders: typebox_1.Type.Optional(typebox_1.Type.Array(StringlyTypedMatrix_1.StringUserIDSchema)),
    types: typebox_1.Type.Optional(typebox_1.Type.Array(typebox_1.Type.String())),
    not_types: typebox_1.Type.Optional(typebox_1.Type.Array(typebox_1.Type.String())),
    rooms: typebox_1.Type.Optional(typebox_1.Type.Array(StringlyTypedMatrix_1.StringRoomIDSchema)),
    not_rooms: typebox_1.Type.Optional(typebox_1.Type.Array(StringlyTypedMatrix_1.StringRoomIDSchema)),
    contains_url: typebox_1.Type.Optional(typebox_1.Type.Boolean()),
    lazy_load_members: typebox_1.Type.Optional(typebox_1.Type.Boolean()),
    include_redundant_members: typebox_1.Type.Optional(typebox_1.Type.Boolean()),
});
//# sourceMappingURL=RoomEventFilter.js.map