import { StringRoomID } from '@the-draupnir-project/matrix-basic-types';
import { RoomEvent } from '../MatrixTypes/Events';
import { MatrixPaginator } from './Pagination/MatrixPaginator';
import { PaginationOptions } from './Pagination/PaginationOptions';
import { RoomEventFilter } from './RoomEventFilter';
import { PaginationIterator } from './Pagination/PaginationIteration';
export interface RoomMessagesOptions extends PaginationOptions {
    filter?: RoomEventFilter;
}
export interface RoomMessagesPaginator<TEvent extends RoomEvent = RoomEvent> extends MatrixPaginator<TEvent, RoomMessagesOptions> {
}
export interface RoomMessages {
    toRoomMessagesPaginator<TEvent extends RoomEvent = RoomEvent>(roomID: StringRoomID): RoomMessagesPaginator<TEvent>;
    toRoomMessagesIterator<TEvent extends RoomEvent = RoomEvent>(roomID: StringRoomID, options?: RoomMessagesOptions): PaginationIterator<TEvent>;
}
export declare const RoomMessagesResponse: import("@sinclair/typebox").TObject<{
    chunk: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TUnknown>;
    start: import("@sinclair/typebox").TUnsafe<import("./Pagination/PaginationToken").StringPaginationToken>;
    end: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnsafe<import("./Pagination/PaginationToken").StringPaginationToken>>;
}>;
//# sourceMappingURL=RoomMessages.d.ts.map