"use strict";
// Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardRoomPauser = void 0;
const Logger_1 = require("../Logging/Logger");
const log = new Logger_1.Logger('RoomPauser');
class StandardRoomPauser {
    constructor() {
        this.pausedRooms = new Map();
    }
    isRoomPaused(roomID) {
        return this.pausedRooms.has(roomID);
    }
    unpause(roomID, then) {
        const entry = this.pausedRooms.get(roomID);
        if (entry === undefined) {
            throw new TypeError(`Someone is managing to pause a room twice, if this happens then the implementation of RoomPauser is broken`);
        }
        this.pausedRooms.delete(roomID);
        for (const event of entry) {
            then(roomID, event);
        }
    }
    pauseRoom(roomID, task, then) {
        if (this.isRoomPaused(roomID)) {
            throw new TypeError(`Someone is trying to pause a room without checking if the room is paused, or they are awaiting between those calls`);
        }
        this.pausedRooms.set(roomID, []);
        task().then(() => {
            this.unpause(roomID, then);
        }, (reason) => {
            log.error(`RoomPause task was rejected, this should not happen and the task should catch all exceptions.`, reason);
            throw reason;
        });
    }
    handleTimelineEventInPausedRoom(roomID, event) {
        const entry = this.pausedRooms.get(roomID);
        if (entry === undefined) {
            throw new TypeError(`Someone isn't checking that the room is paused before queing paused events.`);
        }
        entry.push(event);
    }
}
exports.StandardRoomPauser = StandardRoomPauser;
//# sourceMappingURL=RoomPauser.js.map