import { ResultError } from '@gnuxie/typescript-result';
import { ConfigRecoveryOption } from './PersistentConfigData';
import { ConfigDescription } from './ConfigDescription';
export declare class ConfigRecoverableError extends ResultError {
    readonly configDescription: ConfigDescription;
    readonly recoveryOptions: ConfigRecoveryOption[];
    constructor(message: string, configDescription: ConfigDescription);
    addRecoveryOptions(options: ConfigRecoveryOption[]): this;
}
export declare enum ConfigErrorDiagnosis {
    ProblematicValue = "ProblematicValue",
    ProblematicArrayItem = "ProblematicArrayItem"
}
export declare class ConfigParseError extends ConfigRecoverableError {
    readonly errors: ConfigPropertyError[];
    readonly config: unknown;
    constructor(message: string, description: ConfigDescription, errors: ConfigPropertyError[], config: unknown);
    static Result(message: string, options: {
        errors: ConfigPropertyError[];
        description: ConfigDescription;
        config: unknown;
    }): import("@gnuxie/typescript-result").Result<never, ConfigParseError>;
}
export declare class ConfigPropertyError extends ConfigRecoverableError {
    readonly path: string;
    readonly value: unknown;
    readonly diagnosis: ConfigErrorDiagnosis;
    constructor(message: string, description: ConfigDescription, path: string, value: unknown);
    static Result(message: string, options: {
        path: string;
        value: unknown;
        description: ConfigDescription;
    }): import("@gnuxie/typescript-result").Result<never, ConfigPropertyError>;
    toReadableString(): string;
    itemIndex(): number;
    topLevelProperty(): string;
}
export declare class ConfigPropertyUseError extends ConfigPropertyError {
    readonly cause: ResultError;
    constructor(message: string, description: ConfigDescription, path: string, value: unknown, cause: ResultError);
    static Result(message: string, options: {
        path: string;
        value: unknown;
        cause: ResultError;
        description: ConfigDescription;
    }): import("@gnuxie/typescript-result").Result<never, ConfigPropertyUseError>;
    toReadableString(): string;
}
//# sourceMappingURL=ConfigParseError.d.ts.map