import { ActionResult } from '../Interface/Action';
import { DecodeException } from '../Interface/Value';
import { RoomEvent, StateEvent } from './Events';
type EventDecoderFn = (event: unknown) => ActionResult<RoomEvent, DecodeException>;
/**
 * A compomenet used by clients to parse events.
 */
export interface EventDecoder {
    /**
     * Set the parser for the given event type.
     * @param type The type that should use the parser.
     * @param decoder The parser for the event type.
     * @returns A new EventDecoder that contains the new decoder.
     */
    setDecoderForEventType(type: string, decoder: EventDecoderFn): EventDecoder;
    getDecoderForEventType(type: string): EventDecoderFn | undefined;
    setDecoderForInvalidEventContent(decoder: EventDecoderFn): EventDecoder;
    decodeEvent(event: unknown): ActionResult<RoomEvent, DecodeException>;
    decodeStateEvent(event: unknown): ActionResult<StateEvent, DecodeException>;
}
export declare class StandardEventDecoder implements EventDecoder {
    private readonly decodersByType;
    private invalidContentDecoder?;
    private constructor();
    static blankEventDecoder(): EventDecoder;
    getDecoderForEventType(type: string): EventDecoderFn | undefined;
    setDecoderForEventType(type: string, decoder: EventDecoderFn): EventDecoder;
    decodeEvent(event: unknown): ActionResult<RoomEvent, DecodeException>;
    decodeStateEvent(event: unknown): ActionResult<StateEvent, DecodeException>;
    setDecoderForInvalidEventContent(decoder: EventDecoderFn): EventDecoder;
    getDecoderForInvalidContent(): EventDecoderFn;
}
export {};
//# sourceMappingURL=EventDecoder.d.ts.map