"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StrippedStateEvent = exports.StateEvent = exports.SyncStateEvent = exports.RoomEvent = exports.SyncRoomEvent = exports.UnsignedData = exports.Event = exports.EmptyContent = void 0;
// Copyright 2023 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2018 New Vector Ltd
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-spec
// https://github.com/matrix-org/matrix-spec
// </text>
const typebox_1 = require("@sinclair/typebox");
const StringlyTypedMatrix_1 = require("./StringlyTypedMatrix");
exports.EmptyContent = typebox_1.Type.Object({}, { additionalProperties: false });
const Event = (Content) => typebox_1.Type.Object({
    content: Content,
    type: typebox_1.Type.String({
        description: "The type of event. This SHOULD be namespaced similar to Java package naming conventions e.g. 'com.example.subdomain.event.type'",
    }),
});
exports.Event = Event;
exports.UnsignedData = typebox_1.Type.Object({
    age: typebox_1.Type.Optional(typebox_1.Type.Number({
        description: 'The time in milliseconds that has elapsed since the event was sent. This field is generated by the local homeserver, and may be incorrect if the local time on at least one of the two servers is out of sync, which can cause the age to either be negative or greater than it actually is.',
        format: 'int64',
        example: 1567437,
    })),
    redacted_because: typebox_1.Type.Optional(typebox_1.Type.Unknown()),
    transaction_id: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'The client-supplied [transaction ID](/client-server-api/#transaction-identifiers), for example, provided via\n`PUT /_matrix/client/v3/rooms/{roomId}/send/{eventType}/{txnId}`,\nif the client being given the event is the same one which sent it.\n',
    })),
    prev_content: typebox_1.Type.Optional(typebox_1.Type.Unknown()),
});
const SyncRoomEvent = (Content) => typebox_1.Type.Intersect([
    (0, exports.Event)(Content),
    typebox_1.Type.Object({
        event_id: StringlyTypedMatrix_1.StringEventIDSchema,
        sender: StringlyTypedMatrix_1.StringUserIDSchema,
        origin_server_ts: typebox_1.Type.Number({
            description: 'Timestamp in milliseconds on originating homeserver when this event was sent.',
            format: 'int64',
        }),
        unsigned: typebox_1.Type.Optional(exports.UnsignedData),
    }),
]);
exports.SyncRoomEvent = SyncRoomEvent;
const RoomEvent = (Content) => typebox_1.Type.Intersect([
    (0, exports.SyncRoomEvent)(Content),
    typebox_1.Type.Object({
        room_id: StringlyTypedMatrix_1.StringRoomIDSchema,
    }),
]);
exports.RoomEvent = RoomEvent;
const StateKey = typebox_1.Type.Object({
    state_key: typebox_1.Type.String({
        description: "A unique key which defines the overwriting semantics for this piece of room state. This value is often a zero-length string. The presence of this key makes this event a State Event.\nState keys starting with an `@` are reserved for referencing user IDs, such as room members. With the exception of a few events, state events set with a given user's ID as the state key MUST only be set by that user.",
    }),
});
const SyncStateEvent = (Content) => typebox_1.Type.Intersect([(0, exports.SyncRoomEvent)(Content), StateKey]);
exports.SyncStateEvent = SyncStateEvent;
const StateEvent = (Content) => typebox_1.Type.Intersect([(0, exports.RoomEvent)(Content), StateKey]);
exports.StateEvent = StateEvent;
exports.StrippedStateEvent = typebox_1.Type.Object({
    content: typebox_1.Type.Unknown(),
    state_key: typebox_1.Type.String({ description: 'The `state_key` for the event.' }),
    type: typebox_1.Type.String({ description: 'The `type` for the event.' }),
    sender: StringlyTypedMatrix_1.StringUserIDSchema,
});
//# sourceMappingURL=Events.js.map