"use strict";
// Copyright 2024 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2018 New Vector Ltd
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-spec
// https://github.com/matrix-org/matrix-spec
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.Redaction = exports.RedactionContent = void 0;
exports.redactionTargetEvent = redactionTargetEvent;
const typebox_1 = require("@sinclair/typebox");
const Events_1 = require("./Events");
const StringlyTypedMatrix_1 = require("./StringlyTypedMatrix");
exports.RedactionContent = typebox_1.Type.Object({
    redacts: typebox_1.Type.Optional(typebox_1.Type.Union([StringlyTypedMatrix_1.StringEventIDSchema], {
        description: 'The event ID that was redacted. Required for, and present starting in, room version 11. This is protected from redaction.',
    })),
    reason: typebox_1.Type.Optional(typebox_1.Type.String({ description: 'The reason for the redaction, if any.' })),
});
exports.Redaction = typebox_1.Type.Intersect([
    typebox_1.Type.Omit((0, Events_1.RoomEvent)(exports.RedactionContent), ['type']),
    typebox_1.Type.Object({
        redacts: typebox_1.Type.Optional(typebox_1.Type.Union([StringlyTypedMatrix_1.StringEventIDSchema], {
            description: 'Required for, and only present in, room versions 1 - 10. The event ID that was redacted. This is not protected from redaction and can be removed in room versions prior to v11.',
        })),
        type: typebox_1.Type.Literal('m.room.redaction'),
    }),
]);
function redactionTargetEvent(event) {
    var _a;
    return (_a = event.redacts) !== null && _a !== void 0 ? _a : event.content.redacts;
}
//# sourceMappingURL=Redaction.js.map