import { MembershipChange } from './MembershipChange';
import { StringRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
import { RoomMembershipRevision } from './MembershipRevision';
import { Map as PersistentMap, Set as PersistentSet } from 'immutable';
export declare enum SetMembershipKind {
    Present = "present",
    Absent = "absent"
}
export declare enum SetMembershipChangeType {
    BecamePresent = "became_present",
    BecameAbsent = "became_absent",
    NoOverallChange = "no_overall_change"
}
export type SetMembershipChange = {
    userID: StringUserID;
    changeType: SetMembershipChangeType;
    roomsJoined: number;
    roomsLeft: number;
};
export type SetMembershipDelta = {
    addedRoom: StringRoomID | undefined;
    removedRoom: StringRoomID | undefined;
    changes: SetMembershipChange[];
};
export interface SetMembershipRevision {
    /**
     * Revise from changes to a roomMembershipRevisionIssuer
     */
    changesFromMembershipChanges(changes: MembershipChange[]): SetMembershipDelta;
    /**
     * Revise from a new room in the room set we are modelling.
     */
    changesFromAddedRoom(roomMembershipRevision: RoomMembershipRevision): SetMembershipDelta;
    /**
     * Revise from a room being removed from the room set we are modelling.
     */
    changesFromRemovedRoom(roomMembershipRevision: RoomMembershipRevision): SetMembershipDelta;
    reviseFromChanges(changes: SetMembershipDelta): SetMembershipRevision;
    presentMembers(): IterableIterator<StringUserID>;
    uniqueMemberCount(): number;
    membershipForUser(userID: StringUserID): SetMembershipKind;
}
export declare class StandardSetMembershipRevision implements SetMembershipRevision {
    private readonly memberships;
    private readonly internedRooms;
    constructor(memberships: PersistentMap<StringUserID, number>, internedRooms: PersistentSet<StringRoomID>);
    private getMembershipCount;
    changesFromMembershipChanges(membershipChanges: MembershipChange[]): SetMembershipDelta;
    changesFromAddedRoom(roomMembershipRevision: RoomMembershipRevision): SetMembershipDelta;
    changesFromRemovedRoom(roomMembershipRevision: RoomMembershipRevision): SetMembershipDelta;
    reviseFromChanges(delta: SetMembershipDelta): SetMembershipRevision;
    membershipForUser(userID: StringUserID): SetMembershipKind;
    presentMembers(): IterableIterator<StringUserID>;
    uniqueMemberCount(): number;
    static blankRevision(): SetMembershipRevision;
}
//# sourceMappingURL=SetMembershipRevision.d.ts.map