"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardMembershipPolicyRevisionIssuer = void 0;
const events_1 = __importDefault(require("events"));
const StandardSetMembershipPolicyRevision_1 = require("./StandardSetMembershipPolicyRevision");
const Logger_1 = require("../Logging/Logger");
const log = new Logger_1.Logger('SetMembershipPolicyRevisionIssuer');
class StandardMembershipPolicyRevisionIssuer extends events_1.default {
    constructor(setMembershipRevisionIssuer, policyRevisionIssuer) {
        super();
        this.setMembershipRevisionIssuer = setMembershipRevisionIssuer;
        this.policyRevisionIssuer = policyRevisionIssuer;
        log.info('Creating a SetMembershipPolicyRevision, this may take some time.');
        this.currentRevision = StandardSetMembershipPolicyRevision_1.StandardSetMembershipPolicyRevision.blankRevision();
        this.currentRevision = this.currentRevision.reviseFromChanges(this.currentRevision.changesFromInitialRevisions(policyRevisionIssuer.currentRevision, setMembershipRevisionIssuer.currentRevision));
        log.info('Finished creating a SetMembershipPolicyRevision.');
        this.setMembershipRevisionListener = this.setMembershipRevision.bind(this);
        this.policyRevisionListener = this.policyRevision.bind(this);
        setMembershipRevisionIssuer.on('revision', this.setMembershipRevisionListener);
        policyRevisionIssuer.on('revision', this.policyRevisionListener);
    }
    setMembershipRevision(nextRevision, setMembershipDelta) {
        const previousRevision = this.currentRevision;
        const changes = this.currentRevision.changesFromMembershipChanges(setMembershipDelta, this.policyRevisionIssuer.currentRevision);
        if (changes.addedMemberMatches.length === 0 &&
            changes.removedMemberMatches.length === 0) {
            return;
        }
        this.currentRevision = this.currentRevision.reviseFromChanges(changes);
        this.emit('revision', this.currentRevision, changes, previousRevision);
    }
    policyRevision(nextRevision, policyChanges) {
        const previousRevision = this.currentRevision;
        const changes = this.currentRevision.changesFromPolicyChanges(policyChanges, this.setMembershipRevisionIssuer.currentRevision);
        this.currentRevision = this.currentRevision.reviseFromChanges(changes);
        this.emit('revision', this.currentRevision, changes, previousRevision);
    }
    unregisterListeners() {
        this.setMembershipRevisionIssuer.off('revision', this.setMembershipRevisionListener);
        this.policyRevisionIssuer.off('revision', this.policyRevisionListener);
    }
}
exports.StandardMembershipPolicyRevisionIssuer = StandardMembershipPolicyRevisionIssuer;
//# sourceMappingURL=SetMembershipPolicyRevisionIssuer.js.map