"use strict";
// Copyright 2022 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019 - 2021 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.Revision = void 0;
const ulidx_1 = require("ulidx");
/**
 * Represents a specific version of the state contained in `PolicyListRevision`.
 * These are unique and can be compared with `supersedes`.
 * We use a ULID to work out whether a revision supersedes another.
 * @see {@link PolicyListRevision}.
 */
class Revision {
    constructor() {
        /**
         * Is only public for the comparison method,
         * I feel like I'm missing something here and it is possible without
         */
        this.ulid = Revision.makeULID();
    }
    /**
     * Check whether this revision supersedes another revision.
     * @param revision The revision we want to check this supersedes.
     * @returns True if this Revision supersedes the other revision.
     */
    supersedes(revision) {
        return this.ulid > revision.ulid;
    }
    /**
     * The time that the revision was created in milliseconds.
     */
    get time() {
        return (0, ulidx_1.decodeTime)(this.ulid);
    }
}
exports.Revision = Revision;
/**
 * Ensures that ULIDs are monotonic.
 */
Revision.makeULID = (0, ulidx_1.monotonicFactory)();
//# sourceMappingURL=Revision.js.map