"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerCapabilityInterface = registerCapabilityInterface;
exports.findCapabilityInterface = findCapabilityInterface;
exports.describeCapabilityInterface = describeCapabilityInterface;
exports.findCapabilityInterfaceSet = findCapabilityInterfaceSet;
const CAPABILITY_INTERFACES = new Map();
function registerCapabilityInterface(description) {
    if (CAPABILITY_INTERFACES.has(description.name)) {
        throw new TypeError(`There is already an interface called ${description.name}`);
    }
    CAPABILITY_INTERFACES.set(description.name, description);
}
function findCapabilityInterface(name) {
    return CAPABILITY_INTERFACES.get(name);
}
function describeCapabilityInterface(description) {
    registerCapabilityInterface(description);
    return description;
}
function findCapabilityInterfaceSet(names) {
    const set = {};
    for (const [key, name] of Object.entries(names)) {
        const capabilityInterface = findCapabilityInterface(name);
        if (capabilityInterface === undefined) {
            throw new TypeError(`Couldn't find a capability interface named ${name}`);
        }
        Object.assign(set, { [key]: capabilityInterface });
    }
    return set;
}
//# sourceMappingURL=CapabilityInterface.js.map