import { DescriptionMeta } from '../DescriptionMeta';
import { Capability, CapabilityProviderDescription } from './CapabilityProvider';
export interface CapabilityRendererDescription<TCapabilityInterface = unknown, Context = unknown> extends Omit<CapabilityProviderDescription<Context>, 'factory'> {
    factory(protectionDescription: DescriptionMeta, context: Context, provider: TCapabilityInterface): Capability;
    isDefaultForInterface?: true;
}
export declare function registerCapabilityRenderer(description: CapabilityRendererDescription): void;
export declare function findCapabilityRenderer<TCapabilityInterface = unknown, Context = unknown>(name: string): CapabilityRendererDescription<TCapabilityInterface, Context> | undefined;
export declare function describeCapabilityRenderer<TCapabilityInterface = unknown, Context = unknown>({ name, description, interface: interfaceName, factory, isDefaultForInterface, }: {
    name: string;
    description: string;
    interface: string;
    factory: CapabilityRendererDescription<TCapabilityInterface, Context>['factory'];
    isDefaultForInterface?: true;
}): void;
export declare function wrapCapabilityProviderInRenderer<Context = unknown>(protectionDescription: DescriptionMeta, context: Context, capabilityProviderDescription: CapabilityProviderDescription<Context>): Capability;
//# sourceMappingURL=CapabilityRenderer.d.ts.map