"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
const Action_1 = require("../../../Interface/Action");
const EventGeneration_1 = require("../../../TestUtilities/EventGeneration");
const RoomSetResult_1 = require("./RoomSetResult");
test(`RoomSetResult detects failed results correctly`, function () {
    const builder = new RoomSetResult_1.ResultForUsersInSetBuilder();
    const userID = (0, EventGeneration_1.randomUserID)();
    expect(builder.getResult().isEveryResultOk).toBeTruthy();
    builder.addResult(userID, (0, EventGeneration_1.randomRoomID)([]).toRoomIDOrAlias(), (0, Action_1.Ok)(undefined));
    expect(builder.getResult().isEveryResultOk).toBeTruthy();
    expect([...builder.getResult().map.entries()].every(([_key, result]) => result.isEveryResultOk)).toBeTruthy();
    builder.addResult(userID, (0, EventGeneration_1.randomRoomID)([]).toRoomIDOrAlias(), Action_1.ActionError.Result(`Failed to ban ${userID}`));
    expect(builder.getResult().isEveryResultOk).toBeFalsy();
    expect([...builder.getResult().map.entries()].some(([_key, result]) => !result.isEveryResultOk)).toBeTruthy();
});
//# sourceMappingURL=RoomSetResult.test.js.map