import { Result } from '@gnuxie/typescript-result';
import { SetRoomMembership } from '../../../Membership/SetRoomMembership';
import { Capability } from '../CapabilityProvider';
import { TargetMember, UserConsequences } from './UserConsequences';
import { StringRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
import { ResultForUsersInRoom, ResultForUsersInSet, RoomSetResult } from './RoomSetResult';
export declare class SimulatedUserConsequences implements UserConsequences, Capability {
    private readonly setMembership;
    readonly requiredPermissions: never[];
    readonly requiredEventPermissions: never[];
    readonly requiredStatePermissions: never[];
    readonly isSimulated = true;
    private readonly simulatedCapability;
    constructor(setMembership: SetRoomMembership);
    consequenceForUserInRoom(roomID: StringRoomID, user: StringUserID, reason: string): Promise<Result<void>>;
    consequenceForUsersInRoom(roomID: StringRoomID, users: TargetMember[]): Promise<Result<ResultForUsersInRoom>>;
    consequenceForUsersInRoomSet(users: TargetMember[]): Promise<Result<ResultForUsersInSet>>;
    unbanUserFromRoomSet(userID: StringUserID, reason: string): Promise<Result<RoomSetResult>>;
}
//# sourceMappingURL=SimulatedUserConsequences.d.ts.map