"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardEventConsequences = void 0;
const PowerLevelsMirror_1 = require("../../../Client/PowerLevelsMirror");
const Action_1 = require("../../../Interface/Action");
const CapabilityProvider_1 = require("../CapabilityProvider");
require("./EventConsequences"); // we need this so the interface is loaded.
class StandardEventConsequences {
    constructor(eventRedacter) {
        this.eventRedacter = eventRedacter;
        this.requiredPermissions = [PowerLevelsMirror_1.PowerLevelPermission.Redact];
        this.requiredEventPermissions = [];
        this.requiredStatePermissions = [];
        // nothing to do.
    }
    async consequenceForEvent(roomID, eventID, reason) {
        const result = await this.eventRedacter.redactEvent(roomID, eventID, reason);
        if ((0, Action_1.isError)(result)) {
            return result;
        }
        else {
            return (0, Action_1.Ok)(undefined);
        }
    }
}
exports.StandardEventConsequences = StandardEventConsequences;
(0, CapabilityProvider_1.describeCapabilityProvider)({
    name: 'StandardEventConsequences',
    description: 'Issues m.room.redaction at the room level against the target event.',
    interface: 'EventConsequences',
    factory(_description, context) {
        return new StandardEventConsequences(context.eventRedacter);
    },
});
//# sourceMappingURL=StandardEventConsequences.js.map