import { StringRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
import { PowerLevelPermission } from '../../../Client/PowerLevelsMirror';
import { RoomBanner } from '../../../Client/RoomBanner';
import { RoomUnbanner } from '../../../Client/RoomUnbanner';
import { ActionResult } from '../../../Interface/Action';
import { SetRoomMembership } from '../../../Membership/SetRoomMembership';
import { Capability } from '../CapabilityProvider';
import { ResultForUsersInSet, RoomSetResult, ResultForUsersInRoom } from './RoomSetResult';
import { TargetMember, UserConsequences } from './UserConsequences';
import './UserConsequences';
export declare class StandardUserConsequences implements UserConsequences, Capability {
    private readonly roomBanner;
    private readonly roomUnbanner;
    private readonly setMembership;
    readonly requiredPermissions: PowerLevelPermission[];
    readonly requiredEventPermissions: never[];
    readonly requiredStatePermissions: never[];
    constructor(roomBanner: RoomBanner, roomUnbanner: RoomUnbanner, setMembership: SetRoomMembership);
    private static applyPolicyMatchesToRoom;
    static applyPolicyMatchesToSetMembership(matches: TargetMember[], setMembership: SetRoomMembership, consequenceProviderCB: UserConsequences['consequenceForUserInRoom']): Promise<ResultForUsersInSet>;
    consequenceForUserInRoom(roomID: StringRoomID, user: StringUserID, reason: string): Promise<ActionResult<void>>;
    consequenceForUsersInRoomSet(targets: TargetMember[]): Promise<ActionResult<ResultForUsersInSet>>;
    consequenceForUsersInRoom(roomID: StringRoomID, targets: TargetMember[]): Promise<ActionResult<ResultForUsersInRoom>>;
    unbanUserFromRoomSet(userID: StringUserID, reason: string): Promise<ActionResult<RoomSetResult>>;
}
export type StandardUserConsequencesContext = {
    roomBanner: RoomBanner;
    roomUnbanner: RoomUnbanner;
    setMembership: SetRoomMembership;
};
//# sourceMappingURL=StandardUserConsequences.d.ts.map