import { Result } from '@gnuxie/typescript-result';
import { SemanticType } from '../../Interface/SemanticType';
import { AllocatableLifetime } from '../../Interface/Lifetime';
import { AnyHandleDescription, PluginWithHandle } from './HandleDescription';
import { HandleRegistryDescription } from './HandleRegistryDescription';
/**
 * HandleRegistry is concerned with establishing plugin handles against a context
 * instance. It uses a HandleRegistryDescription to figure out which handles
 * should be established for a given type of context.
 */
export interface HandleRegistry<TPluginContext = Record<string, unknown>, THandles extends AnyHandleDescription = never> {
    registerPluginHandles(plugin: PluginWithHandle<THandles>, pluginLifetime: AllocatableLifetime<typeof plugin>): Result<HandleRegistry<TPluginContext, THandles>>;
    removePluginHandles(plugin: PluginWithHandle<THandles>): void;
    [Symbol.asyncDispose](): Promise<void>;
}
export declare const HandleRegistrySemantics: SemanticType<HandleRegistryDescription<Record<string, unknown>, never>>;
//# sourceMappingURL=HandleRegistry.d.ts.map