"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
const typescript_result_1 = require("@gnuxie/typescript-result");
const HandleRegistry_1 = require("./HandleRegistry");
const StandardHandleRegistryDescription_1 = require("./StandardHandleRegistryDescription");
const HandleRegistryDescription_1 = require("./HandleRegistryDescription");
it('HandleRegistrySemantics are implemented for the standard instance', async () => {
    await HandleRegistry_1.HandleRegistrySemantics.check(async () => {
        return (0, typescript_result_1.Ok)(new StandardHandleRegistryDescription_1.StandardHandleRegistryDescription());
    });
});
it('HandleRegistryDescription semantics are implemented on the standard instance', async () => {
    await HandleRegistryDescription_1.HandleRegistryDescriptionSemantics.check(async () => {
        return (0, typescript_result_1.Ok)(new StandardHandleRegistryDescription_1.StandardHandleRegistryDescription());
    });
});
//# sourceMappingURL=StandardHandleRegistery.test.js.map