import { AllocatableLifetime, OwnLifetime } from '../../Interface/Lifetime';
import { AnyHandleDescription, PluginWithHandle } from './HandleDescription';
import { HandleRegistry } from './HandleRegistry';
import { Result } from '@gnuxie/typescript-result';
export declare class StandardHandleRegistry<TPluginContext = Record<string, unknown>, THandles extends AnyHandleDescription = never> implements HandleRegistry<TPluginContext, THandles> {
    private readonly context;
    private readonly lifetime;
    private readonly handleDescriptions;
    private readonly plugins;
    constructor(context: TPluginContext, lifetime: OwnLifetime<HandleRegistry<TPluginContext, THandles>>);
    private getHandleDescription;
    private readonly forwardHandleFromContext;
    registerHandleDescription<THandleDescription extends AnyHandleDescription>(description: THandleDescription): Result<HandleRegistry<TPluginContext, THandles | THandleDescription>>;
    registerPluginHandles(plugin: PluginWithHandle<THandles>, pluginLifetime: AllocatableLifetime<typeof plugin>): Result<HandleRegistry<TPluginContext, THandles>>;
    removePluginHandles(plugin: PluginWithHandle<THandles>): void;
    [Symbol.asyncDispose](): Promise<void>;
}
//# sourceMappingURL=StandardHandleRegistry.d.ts.map