import { PolicyListConfig, PolicyRoomWatchProfile, PropagationType } from './PolicyListConfig';
import { RoomJoiner } from '../../Client/RoomJoiner';
import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
import { PersistentConfigBackend } from '../../Config/PersistentConfigData';
import { MjolnirPolicyRoomsEncodedShape } from './MjolnirPolicyRoomsDescription';
import { Result } from '@gnuxie/typescript-result';
export declare class MjolnirPolicyRoomsConfig implements PolicyListConfig {
    private readonly config;
    private readonly roomJoiner;
    private watchedLists;
    private readonly writeLock;
    private constructor();
    static createFromStore(store: PersistentConfigBackend<MjolnirPolicyRoomsEncodedShape>, roomJoiner: RoomJoiner): Promise<Result<MjolnirPolicyRoomsConfig>>;
    get allWatchedLists(): PolicyRoomWatchProfile[];
    watchList<T>(propagation: PropagationType, list: MatrixRoomID, _options: T): Promise<Result<void>>;
    unwatchList(propagation: PropagationType, list: MatrixRoomID): Promise<Result<void>>;
}
//# sourceMappingURL=MjolnirPolicyRoomsConfig.d.ts.map