"use strict";
// Copyright (C) 2023 - 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.FakeProtectedRoomsConfig = exports.AbstractProtectedRoomsConfig = void 0;
const Action_1 = require("../../Interface/Action");
const typescript_result_1 = require("@gnuxie/typescript-result");
// FIXME: Tbh, i don't know why this doesn't just use the fake persistent
// config store and use the real MjolnirPolicyRoomsConfig.
class AbstractProtectedRoomsConfig {
    constructor(rooms) {
        this.protectedRooms = new Map();
        rooms.forEach((room) => this.protectedRooms.set(room.toRoomIDOrAlias(), room));
    }
    getProtectedRooms() {
        return [...this.protectedRooms.values()];
    }
    isProtectedRoom(roomID) {
        return this.protectedRooms.has(roomID);
    }
    getProtectedRoom(roomID) {
        return this.protectedRooms.get(roomID);
    }
    addRoom(room) {
        this.protectedRooms.set(room.toRoomIDOrAlias(), room);
    }
    removeRoom(room) {
        this.protectedRooms.delete(room.toRoomIDOrAlias());
    }
}
exports.AbstractProtectedRoomsConfig = AbstractProtectedRoomsConfig;
class FakeProtectedRoomsConfig extends AbstractProtectedRoomsConfig {
    constructor(rooms) {
        super(rooms);
    }
    async addRoom(room) {
        super.addRoom(room);
        return (0, Action_1.Ok)(undefined);
    }
    async removeRoom(room) {
        super.removeRoom(room);
        return (0, Action_1.Ok)(undefined);
    }
    async reportUseError(_message, _room, error) {
        return (0, typescript_result_1.Err)(error);
    }
}
exports.FakeProtectedRoomsConfig = FakeProtectedRoomsConfig;
//# sourceMappingURL=FakeProtectedRoomsConfig.js.map