import { ActionResult } from '../../Interface/Action';
import { LoggableConfig, LoggableConfigTracker } from '../../Interface/LoggableConfig';
import { RoomResolver } from '../../Client/RoomResolver';
import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
import { PersistentConfigBackend } from '../../Config/PersistentConfigData';
import { MjolnirProtectedRoomsEncodedShape } from './MjolnirProtectedRoomsDescription';
import { ResultError } from '@gnuxie/typescript-result';
export interface ProtectedRoomsConfig {
    addRoom(room: MatrixRoomID): Promise<ActionResult<void>>;
    removeRoom(room: MatrixRoomID): Promise<ActionResult<void>>;
    getProtectedRooms(): MatrixRoomID[];
    reportUseError(message: string, room: MatrixRoomID, error: ResultError): Promise<ActionResult<never>>;
}
export declare class MjolnirProtectedRoomsConfig implements ProtectedRoomsConfig, LoggableConfig {
    private readonly config;
    private readonly protectedRooms;
    /**
     * We use this so that we can keep track of the raw data for logging purposes.
     */
    private rawData;
    private readonly writeLock;
    private constructor();
    static createFromStore(store: PersistentConfigBackend<MjolnirProtectedRoomsEncodedShape>, resolver: RoomResolver, loggableConfigTracker: LoggableConfigTracker): Promise<ActionResult<ProtectedRoomsConfig>>;
    getProtectedRooms(): MatrixRoomID[];
    logCurrentConfig(): void;
    addRoom(room: MatrixRoomID): Promise<ActionResult<void>>;
    removeRoom(room: MatrixRoomID): Promise<ActionResult<void>>;
    reportUseError(message: string, room: MatrixRoomID, error: ResultError): Promise<ActionResult<never>>;
}
//# sourceMappingURL=ProtectedRoomsConfig.d.ts.map