import { EventEmitter } from 'events';
import { ActionResult } from '../../Interface/Action';
import { RoomMembershipManager } from '../../Membership/RoomMembershipManager';
import { SetRoomMembership } from '../../Membership/SetRoomMembership';
import { SetRoomState } from '../../StateTracking/SetRoomState';
import { RoomStateManager } from '../../StateTracking/StateRevisionIssuer';
import { ProtectedRoomsConfig } from '../ProtectedRoomsConfig/ProtectedRoomsConfig';
import { ProtectedRoomsManager } from './ProtectedRoomsManager';
import { RoomJoiner } from '../../Client/RoomJoiner';
import { MatrixRoomID, StringRoomID } from '@the-draupnir-project/matrix-basic-types';
import { SetMembershipRevisionIssuer } from '../../Membership/SetMembershipRevisionIssuer';
export declare class StandardProtectedRoomsManager extends EventEmitter implements ProtectedRoomsManager {
    private readonly protectedRoomsConfig;
    setRoomMembership: SetRoomMembership;
    setRoomState: SetRoomState;
    private readonly roomStateManager;
    private readonly roomMembershipManager;
    private readonly roomJoiner;
    private readonly protectedRooms;
    readonly setMembership: SetMembershipRevisionIssuer;
    private constructor();
    /**
     * Creates a StandaardProtectedRoomsManager from blank setMembership/State
     * objects. Will initialise the setMembership/State to contain the correct
     * state for the entire protected rooms set.
     */
    static create(protectedRoomsConfig: ProtectedRoomsConfig, roomStateManager: RoomStateManager, roomMembershipManager: RoomMembershipManager, roomJoiner: RoomJoiner, blankSetMembership: SetRoomMembership, blankSetRoomState: SetRoomState): Promise<ActionResult<ProtectedRoomsManager>>;
    get allProtectedRooms(): MatrixRoomID[];
    isProtectedRoom(roomID: StringRoomID): boolean;
    getProtectedRoom(roomID: StringRoomID): MatrixRoomID | undefined;
    addRoom(room: MatrixRoomID): Promise<ActionResult<void>>;
    removeRoom(room: MatrixRoomID): Promise<ActionResult<void>>;
    unregisterListeners(): void;
}
//# sourceMappingURL=StandardProtectedRoomsManager.d.ts.map