"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProtectionHandleRegistryDescription = exports.ProtectionIntentProjectionNodeHandle = void 0;
const typescript_result_1 = require("@gnuxie/typescript-result");
const HandleDescription_1 = require("./HandleRegistry/HandleDescription");
const StandardHandleRegistryDescription_1 = require("./HandleRegistry/StandardHandleRegistryDescription");
exports.ProtectionIntentProjectionNodeHandle = {
    handleName: 'handleIntentProjectionNode',
    dataSourceType: HandleDescription_1.HandleDataSourceType.Plugin,
    establish(_context, plugin, lifetime) {
        // FIXME: TPlugin needs a generic constraint that is associated with the general plugin shape for the context provided.
        const protection = plugin;
        if (protection.intentProjection === undefined) {
            return typescript_result_1.ResultError.Result("Protection is expecting an intent projection node handle, but isn't providing an intent projection");
        }
        const listener = (node, delta) => { var _a; return (_a = protection.handleIntentProjectionNode) === null || _a === void 0 ? void 0 : _a.call(protection, node, delta); };
        return lifetime.allocateResource(() => {
            var _a;
            (_a = protection.intentProjection) === null || _a === void 0 ? void 0 : _a.addNodeListener(listener);
            return (0, typescript_result_1.Ok)(listener);
        }, () => () => {
            var _a;
            (_a = protection.intentProjection) === null || _a === void 0 ? void 0 : _a.removeNodeListener(listener);
        });
    },
};
exports.ProtectionHandleRegistryDescription = new StandardHandleRegistryDescription_1.StandardHandleRegistryDescription().registerHandleDescription(exports.ProtectionIntentProjectionNodeHandle);
//# sourceMappingURL=ProtectionHandles.js.map