import { Result } from '@gnuxie/typescript-result';
import { CapabilityProviderSet } from '../../Capability/CapabilitySet';
import { ProtectionDescription } from '../../Protection';
import { ProtectionCapabilityProviderSetConfig } from './ProtectionCapabilityProviderSetConfig';
import { PersistentConfigBackend } from '../../../Config/PersistentConfigData';
import { DRAUPNIR_SCHEMA_VERSION_KEY, SchemedData, SchemedDataManager } from '../../../Interface/SchemedMatrixData';
export declare const CapabilityProviderConfig: import("@sinclair/typebox").TObject<{
    "ge.applied-langua.ge.draupnir.schema_version": import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
}>;
export type CapabilityProviderConfig = SchemedData & {
    [K in Exclude<string, typeof DRAUPNIR_SCHEMA_VERSION_KEY>]: {
        capability_provider_name: string;
    };
};
export type MakePersistentConfigBackendForStandardCapabilityProviderSetConfig = (protectionDescription: ProtectionDescription) => Result<PersistentConfigBackend>;
export declare class StandardProtectionCapabilityProviderSetConfig implements ProtectionCapabilityProviderSetConfig {
    private readonly makePersistentConfigBackend;
    private readonly migrationHandler?;
    constructor(makePersistentConfigBackend: MakePersistentConfigBackendForStandardCapabilityProviderSetConfig, migrationHandler?: SchemedDataManager<CapabilityProviderConfig> | undefined);
    storeActivateCapabilityProviderSet(protectionDescription: ProtectionDescription, capabilityproviderSet: CapabilityProviderSet): Promise<Result<void>>;
    getCapabilityProviderSet<TProtectionDescription extends ProtectionDescription = ProtectionDescription>(protectionDescription: TProtectionDescription): Promise<Result<CapabilityProviderSet>>;
}
//# sourceMappingURL=StandardProtectionCapabilityProviderSetConfig.d.ts.map