import { PersistentConfigBackend, PersistentConfigData } from '../../Config/PersistentConfigData';
import { ActionResult } from '../../Interface/Action';
import { LoggableConfigTracker } from '../../Interface/LoggableConfig';
import { SchemedDataManager } from '../../Interface/SchemedMatrixData';
import { ProtectionDescription } from '../Protection';
import { MjolnirEnabledProtectionsDescription, MjolnirEnabledProtectionsEncodedShape } from './MjolnirEnabledProtectionsDescription';
import { MjolnirEnabledProtectionsEvent } from './MjolnirEnabledProtectionsEvent';
import { ProtectionsConfig, ProtectionsInfo } from './ProtectionsConfig';
export type MissingProtectionCB = (protectionName: string) => void;
export declare class MjolnirProtectionsConfig implements ProtectionsConfig {
    private readonly config;
    private info;
    private migrationHandler?;
    protected constructor(config: PersistentConfigData<typeof MjolnirEnabledProtectionsDescription.schema>, logTracker: LoggableConfigTracker, info: ProtectionsInfo, migrationHandler?: SchemedDataManager<MjolnirEnabledProtectionsEvent> | undefined);
    static create(store: PersistentConfigBackend<MjolnirEnabledProtectionsEncodedShape>, logTracker: LoggableConfigTracker, { migrationHandler, 
    /**
     * It is necessary for some consumers to provide a way to enable/disable protections
     * based the version of software that is being loaded. For example Draupnir
     * needs to enable the `BanPropagationProtection` for users who are upgrading
     * from older versions & for those migrating from Mjolnir.
     * This should not be used to change the structure of the account data itself,
     * because this is supposed to be directly compatible with Mjolnir account data.
     */
    missingProtectionCB, }: {
        migrationHandler?: SchemedDataManager<MjolnirEnabledProtectionsEvent>;
        missingProtectionCB?: MissingProtectionCB;
    }): Promise<ActionResult<MjolnirProtectionsConfig>>;
    logCurrentConfig(): void;
    enableProtection<TProtectionDescription extends ProtectionDescription>(protectionDescription: TProtectionDescription): Promise<ActionResult<void>>;
    disableProtection(protectionName: string): Promise<ActionResult<void>>;
    getKnownEnabledProtections(): ProtectionDescription[];
    getUnknownEnabledProtections(): string[];
}
//# sourceMappingURL=StandardProtectionsConfig.d.ts.map