"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
const PolicyEvents_1 = require("../../../MatrixTypes/PolicyEvents");
const PolicyRule_1 = require("../../../PolicyList/PolicyRule");
const DeclareRoomState_1 = require("../../../StateTracking/DeclareRoomState");
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const ServerACLSynchronisationCapability_1 = require("./ServerACLSynchronisationCapability");
const ServerBanIntentProjectionNode_1 = require("./ServerBanIntentProjectionNode");
const ulidx_1 = require("ulidx");
const PolicyRuleChange_1 = require("../../../PolicyList/PolicyRuleChange");
test('ACL compilation works and does not ban our server', async function () {
    var _a, _b, _c, _d, _e;
    const ourServerName = (0, matrix_basic_types_1.StringServerName)('localhost:9999');
    const badServer = 'badpeople.example.com';
    const emptyNode = ServerBanIntentProjectionNode_1.StandardServerBanIntentProjectionNode.create((0, ulidx_1.monotonicFactory)());
    const emptyACL = (0, ServerACLSynchronisationCapability_1.compileServerACL)(ourServerName, emptyNode).safeAclContent();
    expect(emptyACL.allow).toContain('*');
    expect((_a = emptyACL.allow) === null || _a === void 0 ? void 0 : _a.length).toBe(1);
    expect((_b = emptyACL.deny) === null || _b === void 0 ? void 0 : _b.length).toBe(0);
    const banPolicyEvent = (0, DeclareRoomState_1.describePolicyRule)({
        type: PolicyEvents_1.PolicyRuleType.Server,
        entity: badServer,
        recommendation: PolicyRule_1.Recommendation.Ban,
    });
    const banPolicyRule = (0, PolicyRule_1.parsePolicyRule)(banPolicyEvent).expect('Should be able to parse the policy rule');
    const ourPolicyEvent = (0, DeclareRoomState_1.describePolicyRule)({
        type: PolicyEvents_1.PolicyRuleType.Server,
        entity: ourServerName,
        recommendation: PolicyRule_1.Recommendation.Ban,
    });
    const ourBanPolicyRule = (0, PolicyRule_1.parsePolicyRule)(ourPolicyEvent).expect('Should be able to parse the policy rule');
    const nodeWithBans = emptyNode.reduceDelta(emptyNode.reduceInput([banPolicyRule, ourBanPolicyRule].map((policy) => ({
        rule: policy,
        sender: policy.sourceEvent.sender,
        event: policy.sourceEvent,
        changeType: PolicyRuleChange_1.PolicyRuleChangeType.Added,
    }))));
    const acl = (0, ServerACLSynchronisationCapability_1.compileServerACL)(ourServerName, nodeWithBans).safeAclContent();
    expect((_c = acl.deny) === null || _c === void 0 ? void 0 : _c.at(0)).toBe(badServer);
    expect((_d = acl.deny) === null || _d === void 0 ? void 0 : _d.length).toBe(1);
    expect((_e = acl.allow) === null || _e === void 0 ? void 0 : _e.at(0)).toBe('*');
});
//# sourceMappingURL=ServerACLSynchronisationCapability.test.js.map