import { StringRoomID } from '@the-draupnir-project/matrix-basic-types';
import { Capability } from '../../Capability/CapabilityProvider';
import { ServerBanIntentProjection } from './ServerBanIntentProjection';
import { Result } from '@gnuxie/typescript-result';
import { RoomSetResult } from '../../Capability/StandardCapability/RoomSetResult';
export interface ServerBanSynchronisationCapability extends Capability {
    /**
     * Apply the server ban intent projection to a single room.
     * @returns true if there was any effect
     */
    outcomeFromIntentInRoom(roomID: StringRoomID, intentProjection: ServerBanIntentProjection): Promise<Result<boolean>>;
    outcomeFromIntentInRoomSet(intentProjection: ServerBanIntentProjection): Promise<Result<RoomSetResult>>;
}
export declare const ServerBanSynchronisationCapability: import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    outcomeFromIntentInRoom: import("@sinclair/typebox").TFunction<[], import("@sinclair/typebox").TAny>;
    outcomeFromIntentInRoomSet: import("@sinclair/typebox").TFunction<[], import("@sinclair/typebox").TAny>;
}>, import("@sinclair/typebox").TObject<{
    requiredPermissions: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
    requiredEventPermissions: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
    requiredStatePermissions: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
}>]>;
//# sourceMappingURL=ServerBanSynchronisationCapability.d.ts.map