"use strict";
// SPDX-FileCopyrightText: 2024 - 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerBanSynchronisationCapability = void 0;
const CapabilityProvider_1 = require("../../Capability/CapabilityProvider");
const CapabilityMethodSchema_1 = require("../../Capability/StandardCapability/CapabilityMethodSchema");
const typebox_1 = require("@sinclair/typebox");
const CapabilityInterface_1 = require("../../Capability/CapabilityInterface");
exports.ServerBanSynchronisationCapability = typebox_1.Type.Intersect([
    typebox_1.Type.Object({
        outcomeFromIntentInRoom: CapabilityMethodSchema_1.CapabilityMethodSchema,
        outcomeFromIntentInRoomSet: CapabilityMethodSchema_1.CapabilityMethodSchema,
    }),
    CapabilityProvider_1.Capability,
]);
(0, CapabilityInterface_1.describeCapabilityInterface)({
    name: 'ServerBanSynchronisationCapability',
    description: 'Capability used by the ServerBanSynchronisationProtection',
    schema: exports.ServerBanSynchronisationCapability,
});
//# sourceMappingURL=ServerBanSynchronisationCapability.js.map