"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-protection-suite
// https://github.com/Gnuxie/matrix-protection-suite
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExtensibleTextMixinDescription = void 0;
const typebox_1 = require("@sinclair/typebox");
const StandardMixinExtractor_1 = require("../EventMixinExtraction/StandardMixinExtractor");
const hasOwn_1 = require("../hasOwn");
const Value_1 = require("../../Interface/Value");
const ExtensibleTextMixinSchema = typebox_1.Type.Array(typebox_1.Type.Object({
    body: typebox_1.Type.String(),
    mimetype: typebox_1.Type.Optional(typebox_1.Type.String()),
}));
exports.ExtensibleTextMixinDescription = Object.freeze({
    name: 'm.text',
    description: 'Extracts the m.text mixin from any event',
    properties: ['m.text'],
    parser(content) {
        if (!(0, hasOwn_1.hasOwn)(content, 'm.text')) {
            return undefined;
        }
        if (!Value_1.Value.Check(ExtensibleTextMixinSchema, content['m.text'])) {
            return (0, StandardMixinExtractor_1.ErroneousMixin)(this, "The m.text mixin doesn't match the schema");
        }
        const representations = content['m.text'];
        if (representations.length === 0) {
            // If there are no representations, we don't want people to be under the illusion
            // that this mixin was used, when in reality it's just garbage.
            return undefined;
        }
        return {
            description: this,
            isErroneous: false,
            representations: representations.map((representation) => {
                var _a;
                return ({
                    body: representation.body,
                    mimetype: (_a = representation.mimetype) !== null && _a !== void 0 ? _a : 'text/plain',
                });
            }),
        };
    },
});
//# sourceMappingURL=ExtensibleTextMixin.js.map