"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-protection-suite
// https://github.com/Gnuxie/matrix-protection-suite
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewContentMixinDescription = void 0;
const StandardMixinExtractor_1 = require("../EventMixinExtraction/StandardMixinExtractor");
const hasOwn_1 = require("../hasOwn");
exports.NewContentMixinDescription = Object.freeze({
    name: 'm.new_content',
    description: 'Extracts the m.new_content mixin from any event content',
    properties: ['m.new_content'],
    parser(content, extractor) {
        if (!(0, hasOwn_1.hasOwn)(content, 'm.new_content')) {
            return undefined;
        }
        if (typeof content['m.new_content'] !== 'object' ||
            content['m.new_content'] === null) {
            return (0, StandardMixinExtractor_1.ErroneousMixin)(this, 'The m.new_content mixin does not match the schema');
        }
        return {
            description: this,
            isErroneous: false,
            ...extractor.parseContent(content['m.new_content']),
        };
    },
});
//# sourceMappingURL=NewContentMixin.js.map