import { ErroneousEventMixin, OkEventMixin } from '../EventMixinExtraction/EventMixinDescription';
export type RoomMessageFileMixin = OkEventMixin & {
    url: string;
    filename: string;
    caption: string | undefined;
};
export declare const RoomMessageFileMixinDescription: Readonly<{
    name: string;
    description: string;
    properties: string[];
    parser(content: Record<string, unknown>): ErroneousEventMixin | {
        description: Readonly<{
            name: string;
            description: string;
            properties: string[];
            parser: import("../EventMixinExtraction/EventMixinDescription").EventMixinParser<RoomMessageFileMixin, ErroneousEventMixin>;
        }>;
        isErroneous: false;
        filename: string;
        caption: string | undefined;
        url: string;
    } | undefined;
}>;
//# sourceMappingURL=RoomMessageFileMixin.d.ts.map