"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-protection-suite
// https://github.com/Gnuxie/matrix-protection-suite
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomMessageFileMixinDescription = void 0;
const typebox_1 = require("@sinclair/typebox");
const StandardMixinExtractor_1 = require("../EventMixinExtraction/StandardMixinExtractor");
const hasOwn_1 = require("../hasOwn");
const Value_1 = require("../../Interface/Value");
const FileMediaMixinSchema = typebox_1.Type.Object({
    body: typebox_1.Type.Optional(typebox_1.Type.String()),
    file: typebox_1.Type.Object({
        url: typebox_1.Type.String(),
    }),
    filename: typebox_1.Type.Optional(typebox_1.Type.String()),
});
exports.RoomMessageFileMixinDescription = Object.freeze({
    name: 'm.room.message file mixin',
    description: 'Extracts the file mixin from content that looks like m.room.message',
    properties: ['file', 'filename', 'body'],
    parser(content) {
        var _a;
        if (!(0, hasOwn_1.hasOwn)(content, 'file')) {
            return undefined;
        }
        if (Value_1.Value.Check(FileMediaMixinSchema, content)) {
            const filename = (_a = content.filename) !== null && _a !== void 0 ? _a : content.body;
            const caption = content.filename !== undefined && content.body !== content.filename
                ? content.body
                : undefined;
            if (filename === undefined) {
                return (0, StandardMixinExtractor_1.ErroneousMixin)(this, 'The filename property is missing.');
            }
            return {
                description: this,
                isErroneous: false,
                filename,
                caption,
                url: content.file.url,
            };
        }
        return (0, StandardMixinExtractor_1.ErroneousMixin)(this, "The file mixin doesn't match thes chema");
    },
});
//# sourceMappingURL=RoomMessageFileMixin.js.map