"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-protection-suite
// https://github.com/Gnuxie/matrix-protection-suite
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomMessageFormattedBodyMixinDescription = void 0;
const StandardMixinExtractor_1 = require("../EventMixinExtraction/StandardMixinExtractor");
const hasOwn_1 = require("../hasOwn");
exports.RoomMessageFormattedBodyMixinDescription = Object.freeze({
    name: 'm.room.message formatted_body mixin',
    description: 'Extracts the formatted_body property and the format property from content that looks like a m.room.message',
    properties: ['formatted_body', 'format'],
    parser(content) {
        if (!(0, hasOwn_1.hasOwn)(content, 'formatted_body')) {
            return undefined;
        }
        if (typeof content.formatted_body === 'string' &&
            (0, hasOwn_1.hasOwn)(content, 'format') &&
            typeof content.format === 'string') {
            return {
                description: this,
                isErroneous: false,
                formatted_body: content.formatted_body,
                format: content.format,
            };
        }
        return (0, StandardMixinExtractor_1.ErroneousMixin)(this, 'The body property is not a string.');
    },
});
//# sourceMappingURL=RoomMessageFormatedBodyMixin.js.map