import EventEmitter from 'events';
import { RoomStateRevision, RoomStateRevisionIssuer } from './StateRevisionIssuer';
import { StateEvent } from '../MatrixTypes/Events';
import { Redaction } from '../MatrixTypes/Redaction';
import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
import { RoomStateGetter } from '../Client/RoomStateGetter';
export declare class StandardRoomStateRevisionIssuer extends EventEmitter implements RoomStateRevisionIssuer {
    readonly room: MatrixRoomID;
    private readonly roomStateGetter;
    currentRevision: RoomStateRevision;
    private currentBatch;
    private batchCompleteCallback;
    private readonly stateRefreshLock;
    constructor(room: MatrixRoomID, roomStateGetter: RoomStateGetter, initialState: StateEvent[]);
    private addEventToBatch;
    updateForEvent(event: StateEvent): void;
    updateForRedaction(event: Redaction): void;
    private createRevisionFromChanges;
    private createBatchedRevision;
    refreshRoomState(): Promise<void>;
    unregisterListeners(): void;
}
//# sourceMappingURL=StandardRoomStateRevisionIssuer.d.ts.map