"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderDiscoveredRoom = renderDiscoveredRoom;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
function renderDiscoveredRoom(details) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("h4", null, "Room Discovered"),
        interface_manager_1.DeadDocumentJSX.JSXFactory("details", null,
            interface_manager_1.DeadDocumentJSX.JSXFactory("summary", null,
                interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, details.room_id)),
            interface_manager_1.DeadDocumentJSX.JSXFactory("ul", null,
                interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
                    "name: ",
                    interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, details.name ?? "Unamed room")),
                interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
                    "member count: ",
                    interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, details.joined_members ?? "unknown")),
                interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
                    "room ID: ",
                    interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, details.room_id)),
                interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
                    "creator: ",
                    interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, details.creator ?? "unknown")),
                interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
                    "topic: ",
                    interface_manager_1.DeadDocumentJSX.JSXFactory("pre", null, details.topic ?? "unknown"))))));
}
//# sourceMappingURL=RoomDiscoveryRenderer.js.map