"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = __importDefault(require("lodash"));
class ZOD {
    constructor({ config, state = null, promises = [], }) {
        Object.defineProperty(this, "promises", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(this, "config", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "state", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "extend", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "validator", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "schema", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        this.state = state;
        this.promises = promises;
        this.extend = config === null || config === void 0 ? void 0 : config.extend;
        this.validator = config.package;
        this.schema = config.schema;
        this.extendValidator();
    }
    extendValidator() {
        // extend using "extend" callback
        if (typeof this.extend === 'function') {
            this.extend({
                validator: this.validator,
                form: this.state.form,
            });
        }
    }
    validate(field) {
        var _a;
        const result = this.schema.safeParse(field.state.form.validatedValues);
        if (result.success)
            return;
        const errors = (_a = lodash_1.default.get(result.error.format(), field.path)) === null || _a === void 0 ? void 0 : _a._errors;
        if (errors === null || errors === void 0 ? void 0 : errors.length)
            field.validationErrorStack = errors;
    }
}
exports.default = (config) => ({
    class: ZOD,
    config,
});
//# sourceMappingURL=ZOD.js.map