/* cover-cache.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from cover-cache.vala, do not modify */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define G4_COVER_CACHE_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_NAME
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define G4_TYPE_COVER_CACHE (g4_cover_cache_get_type ())
#define G4_COVER_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_COVER_CACHE, G4CoverCache))
#define G4_COVER_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_COVER_CACHE, G4CoverCacheClass))
#define G4_IS_COVER_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_COVER_CACHE))
#define G4_IS_COVER_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_COVER_CACHE))
#define G4_COVER_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_COVER_CACHE, G4CoverCacheClass))

typedef struct _G4CoverCache G4CoverCache;
typedef struct _G4CoverCacheClass G4CoverCacheClass;
typedef struct _G4CoverCachePrivate G4CoverCachePrivate;
enum  {
	G4_COVER_CACHE_0_PROPERTY,
	G4_COVER_CACHE_NUM_PROPERTIES
};
static GParamSpec* g4_cover_cache_properties[G4_COVER_CACHE_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _G4CoverCache {
	GObject parent_instance;
	G4CoverCachePrivate * priv;
};

struct _G4CoverCacheClass {
	GObjectClass parent_class;
};

struct _G4CoverCachePrivate {
	GHashTable* _cache;
	GRecMutex __lock__cache;
};

static gint G4CoverCache_private_offset;
static gpointer g4_cover_cache_parent_class = NULL;

VALA_EXTERN GType g4_cover_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4CoverCache, g_object_unref)
static void _g_free0_ (gpointer var);
VALA_EXTERN GFile* g4_cover_cache_find (G4CoverCache* self,
                            GFile* parent);
static gchar* g4_cover_cache_find_no_lock (GFile* dir);
VALA_EXTERN void g4_cover_cache_put (G4CoverCache* self,
                         GFile* dir,
                         const gchar* child);
VALA_EXTERN gboolean g4_is_cover_file (const gchar* content_type,
                           const gchar* name);
VALA_EXTERN G4CoverCache* g4_cover_cache_new (void);
VALA_EXTERN G4CoverCache* g4_cover_cache_construct (GType object_type);
static void g4_cover_cache_finalize (GObject * obj);
static GType g4_cover_cache_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
g4_cover_cache_get_instance_private (G4CoverCache* self)
{
	return G_STRUCT_MEMBER_P (self, G4CoverCache_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GFile*
g4_cover_cache_find (G4CoverCache* self,
                     GFile* parent)
{
	GFile* dir = NULL;
	GFile* _tmp0_;
	gchar* uri = NULL;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* child = NULL;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	GFile* _tmp24_;
	const gchar* _tmp25_;
	GFile* _tmp26_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (parent == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (parent, g_file_get_type (), GFile));
	dir = _tmp0_;
	_tmp1_ = dir;
	_tmp2_ = g_file_get_uri (_tmp1_);
	uri = _tmp2_;
	child = NULL;
	{
		GHashTable* _tmp3_;
		_tmp3_ = self->priv->_cache;
		g_rec_mutex_lock (&self->priv->__lock__cache);
		{
			GHashTable* _tmp4_;
			const gchar* _tmp5_;
			gconstpointer _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp4_ = self->priv->_cache;
			_tmp5_ = uri;
			_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
			_tmp7_ = g_strdup ((const gchar*) _tmp6_);
			_g_free0 (child);
			child = _tmp7_;
			_tmp8_ = child;
			if (_tmp8_ == NULL) {
				GFile* _tmp9_;
				gchar* _tmp10_;
				const gchar* _tmp11_ = NULL;
				const gchar* _tmp12_;
				GHashTable* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp9_ = dir;
				_tmp10_ = g4_cover_cache_find_no_lock (_tmp9_);
				_g_free0 (child);
				child = _tmp10_;
				_tmp12_ = child;
				_tmp11_ = _tmp12_;
				if (_tmp11_ == NULL) {
					_tmp11_ = "";
				}
				_tmp13_ = self->priv->_cache;
				_tmp14_ = uri;
				_tmp15_ = g_strdup (_tmp14_);
				_tmp16_ = g_strdup ((const gchar*) _tmp11_);
				g_hash_table_insert (_tmp13_, _tmp15_, _tmp16_);
			}
		}
		__finally0:
		{
			GHashTable* _tmp17_;
			_tmp17_ = self->priv->_cache;
			g_rec_mutex_unlock (&self->priv->__lock__cache);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (child);
			_g_free0 (uri);
			_g_object_unref0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp19_ = child;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp20_ = child;
		_tmp21_ = strlen ((const gchar*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp18_ = _tmp22_ == 0;
	}
	if (_tmp18_) {
		GFile* _tmp23_;
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (NULL, g_file_get_type (), GFile));
		result = _tmp23_;
		_g_free0 (child);
		_g_free0 (uri);
		_g_object_unref0 (dir);
		return result;
	}
	_tmp24_ = dir;
	_tmp25_ = child;
	_tmp26_ = g_file_get_child (_tmp24_, (const gchar*) _tmp25_);
	result = _tmp26_;
	_g_free0 (child);
	_g_free0 (uri);
	_g_object_unref0 (dir);
	return result;
}

void
g4_cover_cache_put (G4CoverCache* self,
                    GFile* dir,
                    const gchar* child)
{
	gchar* uri = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = g_file_get_uri (dir);
	uri = _tmp0_;
	{
		GHashTable* _tmp1_;
		_tmp1_ = self->priv->_cache;
		g_rec_mutex_lock (&self->priv->__lock__cache);
		{
			GHashTable* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp2_ = self->priv->_cache;
			_tmp3_ = g_strdup (uri);
			_tmp4_ = g_strdup (child);
			g_hash_table_insert (_tmp2_, _tmp3_, _tmp4_);
		}
		__finally0:
		{
			GHashTable* _tmp5_;
			_tmp5_ = self->priv->_cache;
			g_rec_mutex_unlock (&self->priv->__lock__cache);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (uri);
}

static gchar*
g4_cover_cache_find_no_lock (GFile* dir)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (dir != NULL, NULL);
	{
		GFileInfo* pi = NULL;
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		pi = NULL;
		_tmp0_ = g_file_enumerate_children (dir, G4_COVER_CACHE_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pi);
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp1_ = NULL;
			GFileEnumerator* _tmp2_;
			GFileInfo* _tmp3_;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
			GFileInfo* info = NULL;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			const gchar* _tmp8_ = NULL;
			GFileInfo* _tmp9_;
			const gchar* _tmp10_;
			const gchar* ctype = NULL;
			const gchar* name = NULL;
			GFileInfo* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp2_ = enumerator;
			_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (enumerator);
				_g_object_unref0 (pi);
				goto __catch0_g_error;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (pi);
			pi = _tmp4_;
			_tmp5_ = pi;
			if (!(_tmp5_ != NULL)) {
				_g_object_unref0 (_tmp1_);
				break;
			}
			_tmp6_ = pi;
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_file_info_get_type (), GFileInfo));
			info = _tmp7_;
			_tmp9_ = info;
			_tmp10_ = g_file_info_get_content_type (_tmp9_);
			_tmp8_ = _tmp10_;
			if (_tmp8_ == NULL) {
				_tmp8_ = "";
			}
			ctype = (const gchar*) _tmp8_;
			_tmp11_ = info;
			_tmp12_ = g_file_info_get_name (_tmp11_);
			name = _tmp12_;
			_tmp13_ = ctype;
			_tmp14_ = name;
			if (g4_is_cover_file (_tmp13_, _tmp14_)) {
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = name;
				_tmp16_ = g_strdup (_tmp15_);
				result = _tmp16_;
				_g_object_unref0 (info);
				_g_object_unref0 (_tmp1_);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (pi);
				return result;
			}
			_g_object_unref0 (info);
			_g_object_unref0 (_tmp1_);
		}
		_g_object_unref0 (enumerator);
		_g_object_unref0 (pi);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

G4CoverCache*
g4_cover_cache_construct (GType object_type)
{
	G4CoverCache * self = NULL;
	self = (G4CoverCache*) g_object_new (object_type, NULL);
	return self;
}

G4CoverCache*
g4_cover_cache_new (void)
{
	return g4_cover_cache_construct (G4_TYPE_COVER_CACHE);
}

static void
g4_cover_cache_class_init (G4CoverCacheClass * klass,
                           gpointer klass_data)
{
	g4_cover_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &G4CoverCache_private_offset);
	G_OBJECT_CLASS (klass)->finalize = g4_cover_cache_finalize;
}

static void
g4_cover_cache_instance_init (G4CoverCache * self,
                              gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	self->priv = g4_cover_cache_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock__cache);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	self->priv->_cache = _tmp2_;
}

static void
g4_cover_cache_finalize (GObject * obj)
{
	G4CoverCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_COVER_CACHE, G4CoverCache);
	g_rec_mutex_clear (&self->priv->__lock__cache);
	_g_hash_table_unref0 (self->priv->_cache);
	G_OBJECT_CLASS (g4_cover_cache_parent_class)->finalize (obj);
}

static GType
g4_cover_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (G4CoverCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_cover_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4CoverCache), 0, (GInstanceInitFunc) g4_cover_cache_instance_init, NULL };
	GType g4_cover_cache_type_id;
	g4_cover_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "G4CoverCache", &g_define_type_info, 0);
	G4CoverCache_private_offset = g_type_add_instance_private (g4_cover_cache_type_id, sizeof (G4CoverCachePrivate));
	return g4_cover_cache_type_id;
}

GType
g4_cover_cache_get_type (void)
{
	static volatile gsize g4_cover_cache_type_id__once = 0;
	if (g_once_init_enter (&g4_cover_cache_type_id__once)) {
		GType g4_cover_cache_type_id;
		g4_cover_cache_type_id = g4_cover_cache_get_type_once ();
		g_once_init_leave (&g4_cover_cache_type_id__once, g4_cover_cache_type_id);
	}
	return g4_cover_cache_type_id__once;
}

gboolean
g4_is_cover_file (const gchar* content_type,
                  const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (content_type != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	if (g_content_type_is_mime_type (content_type, "image/*")) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		if (g_ascii_strncasecmp (name, "Cover", (gsize) 5) == 0) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = g_ascii_strncasecmp (name, "Folder", (gsize) 6) == 0;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = g_ascii_strncasecmp (name, "AlbumArt", (gsize) 8) == 0;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

