/* gst-player.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gst-player.vala, do not modify */

#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define G4_TYPE_GST_PLAYER (g4_gst_player_get_type ())
#define G4_GST_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_GST_PLAYER, G4GstPlayer))
#define G4_GST_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_GST_PLAYER, G4GstPlayerClass))
#define G4_IS_GST_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_GST_PLAYER))
#define G4_IS_GST_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_GST_PLAYER))
#define G4_GST_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_GST_PLAYER, G4GstPlayerClass))

typedef struct _G4GstPlayer G4GstPlayer;
typedef struct _G4GstPlayerClass G4GstPlayerClass;
typedef struct _G4GstPlayerPrivate G4GstPlayerPrivate;

#define G4_TYPE_LEVEL_CALCULATOR (g4_level_calculator_get_type ())
#define G4_LEVEL_CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_LEVEL_CALCULATOR, G4LevelCalculator))
#define G4_LEVEL_CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_LEVEL_CALCULATOR, G4LevelCalculatorClass))
#define G4_IS_LEVEL_CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_LEVEL_CALCULATOR))
#define G4_IS_LEVEL_CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_LEVEL_CALCULATOR))
#define G4_LEVEL_CALCULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_LEVEL_CALCULATOR, G4LevelCalculatorClass))

typedef struct _G4LevelCalculator G4LevelCalculator;
typedef struct _G4LevelCalculatorClass G4LevelCalculatorClass;
enum  {
	G4_GST_PLAYER_0_PROPERTY,
	G4_GST_PLAYER_GAPLESS_PROPERTY,
	G4_GST_PLAYER_PLAYING_PROPERTY,
	G4_GST_PLAYER_STATE_PROPERTY,
	G4_GST_PLAYER_URI_PROPERTY,
	G4_GST_PLAYER_AUDIO_SINK_PROPERTY,
	G4_GST_PLAYER_PEAK_PROPERTY,
	G4_GST_PLAYER_POSITION_PROPERTY,
	G4_GST_PLAYER_REPLAY_GAIN_PROPERTY,
	G4_GST_PLAYER_TAG_LIST_PROPERTY,
	G4_GST_PLAYER_VOLUME_PROPERTY,
	G4_GST_PLAYER_NUM_PROPERTIES
};
static GParamSpec* g4_gst_player_properties[G4_GST_PLAYER_NUM_PROPERTIES];
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g4_level_calculator_unref0(var) ((var == NULL) ? NULL : (var = (g4_level_calculator_unref (var), NULL)))
#define _gst_tag_list_unref0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block15Data Block15Data;
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
typedef void (*G4VoidFunc) (gpointer user_data);
#define _gst_message_unref0(var) ((var == NULL) ? NULL : (var = (gst_message_unref (var), NULL)))
typedef struct _Block16Data Block16Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block17Data Block17Data;
#define _gst_sample_unref0(var) ((var == NULL) ? NULL : (var = (gst_sample_unref (var), NULL)))
enum  {
	G4_GST_PLAYER_DURATION_CHANGED_SIGNAL,
	G4_GST_PLAYER_ERROR_SIGNAL,
	G4_GST_PLAYER_END_OF_STREAM_SIGNAL,
	G4_GST_PLAYER_POSITION_UPDATED_SIGNAL,
	G4_GST_PLAYER_NEXT_URI_REQUEST_SIGNAL,
	G4_GST_PLAYER_NEXT_URI_START_SIGNAL,
	G4_GST_PLAYER_STATE_CHANGED_SIGNAL,
	G4_GST_PLAYER_TAG_PARSED_SIGNAL,
	G4_GST_PLAYER_NUM_SIGNALS
};
static guint g4_gst_player_signals[G4_GST_PLAYER_NUM_SIGNALS] = {0};

struct _G4GstPlayer {
	GObject parent_instance;
	G4GstPlayerPrivate * priv;
};

struct _G4GstPlayerClass {
	GObjectClass parent_class;
};

struct _G4GstPlayerPrivate {
	GstPipeline* _pipeline;
	GstElement* _audio_sink;
	GstElement* _replay_gain;
	gchar* _audio_sink_name;
	gint _audio_sink_requested;
	gchar* _current_uri;
	GstClockTime _duration;
	GstClockTime _position;
	gint _last_error_code;
	gulong _about_to_finish_id;
	gint _next_uri_requested;
	gdouble _last_peak;
	G4LevelCalculator* _peak_calculator;
	GstState _state;
	gboolean _seeking;
	GstTagList* _tag_list;
	guint _tag_handle;
	gboolean _tag_parsed;
	guint _timer_handle;
	GThread* _main_thread;
	gdouble _volume;
};

struct _Block15Data {
	int _ref_count_;
	GPtrArray* sinks;
};

struct _Block16Data {
	int _ref_count_;
	G4GstPlayer* self;
	GstMessage* message;
};

struct _Block17Data {
	int _ref_count_;
	G4GstPlayer* self;
	GstClockTime saved_pos;
	GstState saved_state;
};

static gint G4GstPlayer_private_offset;
static gpointer g4_gst_player_parent_class = NULL;

VALA_EXTERN GType g4_gst_player_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4GstPlayer, g_object_unref)
VALA_EXTERN gpointer g4_level_calculator_ref (gpointer instance);
VALA_EXTERN void g4_level_calculator_unref (gpointer instance);
VALA_EXTERN GParamSpec* g4_param_spec_level_calculator (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void g4_value_set_level_calculator (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void g4_value_take_level_calculator (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer g4_value_get_level_calculator (const GValue* value);
VALA_EXTERN GType g4_level_calculator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4LevelCalculator, g4_level_calculator_unref)
VALA_EXTERN void g4_level_calculator_clear (G4LevelCalculator* self);
static GstStateChangeReturn* _gst_state_change_return_dup (GstStateChangeReturn* self);
VALA_EXTERN G4LevelCalculator* g4_level_calculator_new (void);
VALA_EXTERN G4LevelCalculator* g4_level_calculator_construct (GType object_type);
VALA_EXTERN void g4_gst_player_init (gchar*** args,
                         gint* args_length1);
VALA_EXTERN GstClockTime g4_gst_player_from_second (gdouble time);
VALA_EXTERN gdouble g4_gst_player_to_second (GstClockTime time);
VALA_EXTERN void g4_gst_player_get_audio_sinks (GPtrArray* sinks);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda37_ (Block15Data* _data15_,
                  GstElementFactory* factory);
static void ___lambda37__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN G4GstPlayer* g4_gst_player_new (void);
VALA_EXTERN G4GstPlayer* g4_gst_player_construct (GType object_type);
static gboolean g4_gst_player_bus_callback (G4GstPlayer* self,
                                     GstBus* bus,
                                     GstMessage* message);
static gboolean _g4_gst_player_bus_callback_gst_bus_func (GstBus* bus,
                                                   GstMessage* message,
                                                   gpointer self);
VALA_EXTERN void g4_gst_player_play (G4GstPlayer* self);
VALA_EXTERN void g4_gst_player_pause (G4GstPlayer* self);
VALA_EXTERN void g4_gst_player_seek (G4GstPlayer* self,
                         GstClockTime position);
static void g4_gst_player_emit_tag_parsed (G4GstPlayer* self,
                                    guint delay);
VALA_EXTERN guint g4_run_timeout_once (guint interval,
                           G4VoidFunc func,
                           gpointer func_target,
                           GDestroyNotify func_target_destroy_notify);
static void __lambda39_ (G4GstPlayer* self);
static void ___lambda39__g4_void_func (gpointer self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void g4_gst_player_on_bus_message (G4GstPlayer* self,
                                   GstMessage* message);
static gboolean ___lambda40_ (Block16Data* _data16_);
static gboolean ____lambda40__gsource_func (gpointer self);
static gboolean g4_gst_player_parse_position (G4GstPlayer* self);
static void g4_gst_player_parse_duration (G4GstPlayer* self);
static void g4_gst_player_on_state_changed (G4GstPlayer* self,
                                     GstState old,
                                     GstState state);
static void g4_gst_player_on_stream_start (G4GstPlayer* self);
VALA_EXTERN GstTagList* g4_merge_tags (GstTagList* tags,
                           GstTagList* tags2,
                           GstTagMergeMode mode);
VALA_EXTERN gboolean g4_tags_has_image (GstTagList* tags);
static gboolean _g4_gst_player_parse_position_gsource_func (gpointer self);
static void g4_gst_player_on_stream_to_finish (G4GstPlayer* self);
VALA_EXTERN void g4_gst_player_set_uri (G4GstPlayer* self,
                            const gchar* value);
static GstElement* g4_gst_player_setup_audio_sink (G4GstPlayer* self);
static gboolean* _bool_dup (gboolean* self);
static void g4_gst_player_update_audio_sink (G4GstPlayer* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static gboolean ___lambda41_ (Block17Data* _data17_);
static gboolean ____lambda41__gsource_func (gpointer self);
VALA_EXTERN gboolean g4_gst_player_get_gapless (G4GstPlayer* self);
VALA_EXTERN void g4_gst_player_set_gapless (G4GstPlayer* self,
                                gboolean value);
static void _g4_gst_player_on_stream_to_finish_dynamic_about_to_finish0_ (GstPipeline* _sender,
                                                                   gpointer self);
VALA_EXTERN gboolean g4_gst_player_get_playing (G4GstPlayer* self);
VALA_EXTERN void g4_gst_player_set_playing (G4GstPlayer* self,
                                gboolean value);
VALA_EXTERN void g4_gst_player_set_state (G4GstPlayer* self,
                              GstState value);
VALA_EXTERN GstState g4_gst_player_get_state (G4GstPlayer* self);
VALA_EXTERN const gchar* g4_gst_player_get_uri (G4GstPlayer* self);
VALA_EXTERN const gchar* g4_gst_player_get_audio_sink (G4GstPlayer* self);
VALA_EXTERN void g4_gst_player_set_audio_sink (G4GstPlayer* self,
                                   const gchar* value);
static guint* _uint_dup (guint* self);
VALA_EXTERN gdouble g4_gst_player_get_peak (G4GstPlayer* self);
VALA_EXTERN void g4_level_calculator_calculate_sample (G4LevelCalculator* self,
                                           GstSample* sample,
                                           GstClockTime position,
                                           gdouble* peak_value);
VALA_EXTERN GstClockTime g4_gst_player_get_position (G4GstPlayer* self);
VALA_EXTERN void g4_gst_player_set_position (G4GstPlayer* self,
                                 GstClockTime value);
VALA_EXTERN guint g4_gst_player_get_replay_gain (G4GstPlayer* self);
VALA_EXTERN void g4_gst_player_set_replay_gain (G4GstPlayer* self,
                                    guint value);
VALA_EXTERN GstTagList* g4_gst_player_get_tag_list (G4GstPlayer* self);
VALA_EXTERN gdouble g4_gst_player_get_volume (G4GstPlayer* self);
VALA_EXTERN void g4_gst_player_set_volume (G4GstPlayer* self,
                               gdouble value);
static void g_cclosure_user_marshal_VOID__UINT64 (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data);
static void g_cclosure_user_marshal_STRING__VOID (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data);
static void g4_gst_player_finalize (GObject * obj);
static GType g4_gst_player_get_type_once (void);
static void _vala_g4_gst_player_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_g4_gst_player_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static inline gpointer
g4_gst_player_get_instance_private (G4GstPlayer* self)
{
	return G_STRUCT_MEMBER_P (self, G4GstPlayer_private_offset);
}

static GstStateChangeReturn*
_gst_state_change_return_dup (GstStateChangeReturn* self)
{
	GstStateChangeReturn* dup;
	dup = g_new0 (GstStateChangeReturn, 1);
	memcpy (dup, self, sizeof (GstStateChangeReturn));
	return dup;
}

static gpointer
__gst_state_change_return_dup0 (gpointer self)
{
	return self ? _gst_state_change_return_dup (self) : NULL;
}

void
g4_gst_player_init (gchar*** args,
                    gint* args_length1)
{
	gst_init ((gint*) (args_length1), args);
}

GstClockTime
g4_gst_player_from_second (gdouble time)
{
	GstClockTime result;
	result = (GstClockTime) (time * GST_SECOND);
	return result;
}

gdouble
g4_gst_player_to_second (GstClockTime time)
{
	gdouble result;
	result = ((gdouble) time) / GST_SECOND;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		_g_ptr_array_unref0 (_data15_->sinks);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda37_ (Block15Data* _data15_,
             GstElementFactory* factory)
{
	GstElementFactory* _tmp0_;
	g_return_if_fail (factory != NULL);
	_tmp0_ = _g_object_ref0 (factory);
	g_ptr_array_add (_data15_->sinks, _tmp0_);
}

static void
___lambda37__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda37_ (self, (GstElementFactory*) data);
}

void
g4_gst_player_get_audio_sinks (GPtrArray* sinks)
{
	Block15Data* _data15_;
	GPtrArray* _tmp0_;
	GstCaps* caps = NULL;
	GstCaps* _tmp1_;
	GList* list = NULL;
	GList* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	g_return_if_fail (sinks != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_tmp0_ = _g_ptr_array_ref0 (sinks);
	_g_ptr_array_unref0 (_data15_->sinks);
	_data15_->sinks = _tmp0_;
	_tmp1_ = gst_caps_new_simple ("audio/x-raw", "format", G_TYPE_STRING, "S16LE", NULL, NULL);
	caps = _tmp1_;
	_tmp2_ = gst_element_factory_list_get_elements (GST_ELEMENT_FACTORY_TYPE_AUDIOVIDEO_SINKS, GST_RANK_SECONDARY);
	list = _tmp2_;
	_tmp3_ = list;
	_tmp4_ = gst_element_factory_list_filter (_tmp3_, caps, GST_PAD_SINK, FALSE);
	(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
	list = _tmp4_;
	_tmp5_ = list;
	g_list_foreach (_tmp5_, ___lambda37__gfunc, _data15_);
	(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
	_gst_caps_unref0 (caps);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

static gboolean
_g4_gst_player_bus_callback_gst_bus_func (GstBus* bus,
                                          GstMessage* message,
                                          gpointer self)
{
	gboolean result;
	result = g4_gst_player_bus_callback ((G4GstPlayer*) self, bus, message);
	return result;
}

G4GstPlayer*
g4_gst_player_construct (GType object_type)
{
	G4GstPlayer * self = NULL;
	guint major = 0U;
	guint minor = 0U;
	guint micro = 0U;
	guint nano = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gboolean _tmp4_ = FALSE;
	GstPipeline* _tmp9_;
	GstPipeline* _tmp12_;
	self = (G4GstPlayer*) g_object_new (object_type, NULL);
	major = (guint) 0;
	minor = (guint) 0;
	micro = (guint) 0;
	nano = (guint) 0;
	gst_version (&_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	major = _tmp0_;
	minor = _tmp1_;
	micro = _tmp2_;
	nano = _tmp3_;
	if (major > ((guint) 1)) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (major == ((guint) 1)) {
			_tmp5_ = minor >= ((guint) 24);
		} else {
			_tmp5_ = FALSE;
		}
		_tmp4_ = _tmp5_;
	}
	if (_tmp4_) {
		GstElement* _tmp6_;
		GstPipeline* _tmp7_;
		GstPipeline* _tmp8_;
		_tmp6_ = gst_element_factory_make ("playbin3", "player");
		_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gst_pipeline_get_type ()) ? ((GstPipeline*) _tmp6_) : NULL;
		if (_tmp7_ == NULL) {
			_g_object_unref0 (_tmp6_);
		}
		if (_tmp7_ != NULL) {
			g_object_ref_sink (_tmp7_);
		}
		_g_object_unref0 (self->priv->_pipeline);
		self->priv->_pipeline = _tmp7_;
		_tmp8_ = self->priv->_pipeline;
		if (_tmp8_ != NULL) {
			g_print ("%s", "Use playbin3\n");
		}
	}
	_tmp9_ = self->priv->_pipeline;
	if (_tmp9_ == NULL) {
		GstElement* _tmp10_;
		GstPipeline* _tmp11_;
		_tmp10_ = gst_element_factory_make ("playbin", "player");
		_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gst_pipeline_get_type ()) ? ((GstPipeline*) _tmp10_) : NULL;
		if (_tmp11_ == NULL) {
			_g_object_unref0 (_tmp10_);
		}
		if (_tmp11_ != NULL) {
			g_object_ref_sink (_tmp11_);
		}
		_g_object_unref0 (self->priv->_pipeline);
		self->priv->_pipeline = _tmp11_;
	}
	_tmp12_ = self->priv->_pipeline;
	if (_tmp12_ != NULL) {
		GstPipeline* pipeline = NULL;
		GstPipeline* _tmp13_;
		GstPipeline* _tmp14_;
		GstPipeline* _tmp15_;
		GstPipeline* _tmp16_;
		GstPipeline* _tmp17_;
		GstPipeline* _tmp18_;
		GstBus* _tmp19_;
		GstBus* _tmp20_;
		_tmp13_ = self->priv->_pipeline;
		_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gst_pipeline_get_type (), GstPipeline));
		pipeline = _tmp14_;
		_tmp15_ = pipeline;
		g_object_set ((GstBin*) _tmp15_, "async-handling", TRUE, NULL);
		_tmp16_ = pipeline;
		((GstObject*) _tmp16_)->flags = (guint32) 0x0022;
		_tmp17_ = pipeline;
		g_object_bind_property_with_closures ((GObject*) _tmp17_, "volume", (GObject*) self, "volume", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp18_ = pipeline;
		_tmp19_ = gst_pipeline_get_bus (_tmp18_);
		_tmp20_ = _tmp19_;
		gst_bus_add_watch_full (_tmp20_, G_PRIORITY_DEFAULT, _g4_gst_player_bus_callback_gst_bus_func, g_object_ref (self), g_object_unref);
		_g_object_unref0 (_tmp20_);
		_g_object_unref0 (pipeline);
	} else {
		g_critical ("gst-player.vala:72: Create playbin failed\n");
	}
	return self;
}

G4GstPlayer*
g4_gst_player_new (void)
{
	return g4_gst_player_construct (G4_TYPE_GST_PLAYER);
}

void
g4_gst_player_play (G4GstPlayer* self)
{
	GstPipeline* _tmp0_ = NULL;
	GstPipeline* _tmp1_;
	GstStateChangeReturn* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_pipeline;
	_tmp0_ = _tmp1_;
	_tmp2_ = NULL;
	if (_tmp0_ != NULL) {
		GstStateChangeReturn _tmp3_;
		GstStateChangeReturn* _tmp4_;
		_tmp3_ = gst_element_set_state ((GstElement*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gst_pipeline_get_type (), GstPipeline), GST_STATE_PLAYING);
		_tmp4_ = __gst_state_change_return_dup0 (&_tmp3_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp4_;
	}
	_g_free0 (_tmp2_);
}

void
g4_gst_player_pause (G4GstPlayer* self)
{
	GstPipeline* _tmp0_ = NULL;
	GstPipeline* _tmp1_;
	GstStateChangeReturn* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_pipeline;
	_tmp0_ = _tmp1_;
	_tmp2_ = NULL;
	if (_tmp0_ != NULL) {
		GstStateChangeReturn _tmp3_;
		GstStateChangeReturn* _tmp4_;
		_tmp3_ = gst_element_set_state ((GstElement*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gst_pipeline_get_type (), GstPipeline), GST_STATE_PAUSED);
		_tmp4_ = __gst_state_change_return_dup0 (&_tmp3_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp4_;
	}
	_g_free0 (_tmp2_);
}

void
g4_gst_player_seek (G4GstPlayer* self,
                    GstClockTime position)
{
	gboolean _tmp0_ = FALSE;
	GstPipeline* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_pipeline;
	if (_tmp1_ != NULL) {
		_tmp0_ = !self->priv->_seeking;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GstPipeline* _tmp2_;
		_tmp2_ = self->priv->_pipeline;
		self->priv->_seeking = gst_element_seek_simple ((GstElement*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gst_pipeline_get_type (), GstPipeline), GST_FORMAT_TIME, GST_SEEK_FLAG_ACCURATE | GST_SEEK_FLAG_FLUSH, (gint64) position);
	}
}

static void
__lambda39_ (G4GstPlayer* self)
{
	const gchar* _tmp0_;
	GstTagList* _tmp1_;
	self->priv->_tag_handle = (guint) 0;
	self->priv->_tag_parsed = TRUE;
	_tmp0_ = self->priv->_current_uri;
	_tmp1_ = self->priv->_tag_list;
	g_signal_emit (self, g4_gst_player_signals[G4_GST_PLAYER_TAG_PARSED_SIGNAL], 0, _tmp0_, _tmp1_);
}

static void
___lambda39__g4_void_func (gpointer self)
{
	__lambda39_ ((G4GstPlayer*) self);
}

static void
g4_gst_player_emit_tag_parsed (G4GstPlayer* self,
                               guint delay)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_tag_handle != ((guint) 0)) {
		g_source_remove (self->priv->_tag_handle);
	}
	self->priv->_tag_handle = g4_run_timeout_once (delay, ___lambda39__g4_void_func, g_object_ref (self), g_object_unref);
}

static gpointer
_gst_message_ref0 (gpointer self)
{
	return self ? gst_message_ref (self) : NULL;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		G4GstPlayer* self;
		self = _data16_->self;
		_gst_message_unref0 (_data16_->message);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static gboolean
___lambda40_ (Block16Data* _data16_)
{
	G4GstPlayer* self;
	gboolean result;
	self = _data16_->self;
	g4_gst_player_on_bus_message (self, _data16_->message);
	gst_mini_object_unref ((GstMiniObject*) _data16_->message);
	result = FALSE;
	return result;
}

static gboolean
____lambda40__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda40_ (self);
	return result;
}

static gboolean
g4_gst_player_bus_callback (G4GstPlayer* self,
                            GstBus* bus,
                            GstMessage* message)
{
	Block16Data* _data16_;
	GstMessage* _tmp0_;
	GThread* thread = NULL;
	GThread* _tmp1_;
	GThread* _tmp2_;
	GThread* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = _gst_message_ref0 (message);
	_gst_message_unref0 (_data16_->message);
	_data16_->message = _tmp0_;
	_tmp1_ = g_thread_self ();
	thread = _tmp1_;
	_tmp2_ = thread;
	_tmp3_ = self->priv->_main_thread;
	if (_tmp2_ == _tmp3_) {
		g4_gst_player_on_bus_message (self, _data16_->message);
	} else {
		GThread* _tmp4_;
		const gchar* _tmp5_;
		gst_mini_object_ref ((GstMiniObject*) _data16_->message);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda40__gsource_func, block16_data_ref (_data16_), block16_data_unref);
		_tmp4_ = thread;
		_tmp5_ = gst_message_type_get_name (_data16_->message->type);
		g_warning ("gst-player.vala:244: Bus message not in main thread: %p, %s\n", _tmp4_, _tmp5_);
	}
	result = TRUE;
	block16_data_unref (_data16_);
	_data16_ = NULL;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
g4_gst_player_on_bus_message (G4GstPlayer* self,
                              GstMessage* message)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	switch (message->type) {
		case GST_MESSAGE_ASYNC_DONE:
		{
			g4_gst_player_parse_position (self);
			self->priv->_seeking = FALSE;
			break;
		}
		case GST_MESSAGE_DURATION_CHANGED:
		{
			g4_gst_player_parse_duration (self);
			break;
		}
		case GST_MESSAGE_STATE_CHANGED:
		{
			GstObject* _tmp0_;
			GstPipeline* _tmp1_;
			_tmp0_ = message->src;
			_tmp1_ = self->priv->_pipeline;
			if (_tmp0_ == G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gst_pipeline_get_type (), GstPipeline), gst_object_get_type (), GstObject)) {
				GstState old = 0;
				GstState state = 0;
				GstState pend = 0;
				GstState _tmp2_ = 0;
				GstState _tmp3_ = 0;
				GstState _tmp4_ = 0;
				old = GST_STATE_NULL;
				state = GST_STATE_NULL;
				pend = GST_STATE_NULL;
				gst_message_parse_state_changed (message, &_tmp2_, &_tmp3_, &_tmp4_);
				old = _tmp2_;
				state = _tmp3_;
				pend = _tmp4_;
				g4_gst_player_on_state_changed (self, old, state);
			}
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* err = NULL;
			gchar* debug = NULL;
			GError* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			GError* _tmp7_;
			const gchar* _tmp8_;
			GError* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			GError* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GError* _tmp17_;
			gst_message_parse_error (message, &_tmp5_, &_tmp6_);
			_g_error_free0 (err);
			err = _tmp5_;
			_g_free0 (debug);
			debug = _tmp6_;
			_tmp7_ = err;
			_tmp8_ = g_quark_to_string (_tmp7_->domain);
			_tmp9_ = err;
			_tmp10_ = g_strdup_printf ("%i", _tmp9_->code);
			_tmp11_ = _tmp10_;
			_tmp12_ = err;
			_tmp13_ = _tmp12_->message;
			_tmp14_ = string_to_string (_tmp13_);
			_tmp15_ = g_strconcat ("Player error: ", _tmp8_, ", ", _tmp11_, ", ", _tmp14_, "\n", NULL);
			_tmp16_ = _tmp15_;
			g_print ("%s", _tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp11_);
			_tmp17_ = err;
			if (self->priv->_last_error_code < _tmp17_->code) {
				GError* _tmp18_;
				GError* _tmp19_;
				_tmp18_ = err;
				self->priv->_last_error_code = _tmp18_->code;
				_tmp19_ = err;
				g_signal_emit (self, g4_gst_player_signals[G4_GST_PLAYER_ERROR_SIGNAL], 0, _tmp19_);
			}
			_g_free0 (debug);
			_g_error_free0 (err);
			break;
		}
		case GST_MESSAGE_EOS:
		{
			g_signal_emit (self, g4_gst_player_signals[G4_GST_PLAYER_END_OF_STREAM_SIGNAL], 0);
			break;
		}
		case GST_MESSAGE_STREAM_START:
		{
			g4_gst_player_on_stream_start (self);
			if (!self->priv->_tag_parsed) {
				g4_gst_player_emit_tag_parsed (self, (guint) 50);
			}
			break;
		}
		case GST_MESSAGE_TAG:
		{
			GstTagList* tags = NULL;
			GstTagList* _tmp20_ = NULL;
			GstTagList* _tmp21_;
			GstTagList* _tmp22_;
			GstTagList* _tmp23_;
			tags = NULL;
			gst_message_parse_tag (message, &_tmp20_);
			_gst_tag_list_unref0 (tags);
			tags = _tmp20_;
			_tmp21_ = self->priv->_tag_list;
			_tmp22_ = tags;
			_tmp23_ = g4_merge_tags (_tmp21_, _tmp22_, GST_TAG_MERGE_KEEP);
			_gst_tag_list_unref0 (self->priv->_tag_list);
			self->priv->_tag_list = _tmp23_;
			if (!self->priv->_tag_parsed) {
				gint _tmp24_ = 0;
				GstTagList* _tmp25_;
				_tmp25_ = self->priv->_tag_list;
				if (g4_tags_has_image (_tmp25_)) {
					_tmp24_ = 0;
				} else {
					_tmp24_ = 50;
				}
				g4_gst_player_emit_tag_parsed (self, (guint) _tmp24_);
			}
			_gst_tag_list_unref0 (tags);
			break;
		}
		default:
		{
			break;
		}
	}
}

static gboolean
_g4_gst_player_parse_position_gsource_func (gpointer self)
{
	gboolean result;
	result = g4_gst_player_parse_position ((G4GstPlayer*) self);
	return result;
}

static void
g4_gst_player_on_state_changed (G4GstPlayer* self,
                                GstState old,
                                GstState state)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (old != state) {
		_tmp0_ = self->priv->_state != state;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->_state = state;
		g_signal_emit (self, g4_gst_player_signals[G4_GST_PLAYER_STATE_CHANGED_SIGNAL], 0, state);
	}
	if (self->priv->_timer_handle == ((guint) 0)) {
		_tmp1_ = state == GST_STATE_PLAYING;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		self->priv->_timer_handle = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _g4_gst_player_parse_position_gsource_func, g_object_ref (self), g_object_unref);
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->priv->_timer_handle != ((guint) 0)) {
			_tmp2_ = state != GST_STATE_PLAYING;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			g_source_remove (self->priv->_timer_handle);
			self->priv->_timer_handle = (guint) 0;
		}
	}
}

static void
g4_gst_player_on_stream_start (G4GstPlayer* self)
{
	G4LevelCalculator* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_last_error_code = 0;
	_tmp0_ = self->priv->_peak_calculator;
	g4_level_calculator_clear (_tmp0_);
	_gst_tag_list_unref0 (self->priv->_tag_list);
	self->priv->_tag_list = NULL;
	self->priv->_tag_parsed = FALSE;
	_tmp1_ = g_atomic_int_compare_and_exchange ((volatile gint *) (&self->priv->_next_uri_requested), 1, 0);
	if (_tmp1_) {
		g_signal_emit (self, g4_gst_player_signals[G4_GST_PLAYER_NEXT_URI_START_SIGNAL], 0);
	}
	g4_gst_player_parse_duration (self);
	g4_gst_player_parse_position (self);
}

static void
g4_gst_player_on_stream_to_finish (G4GstPlayer* self)
{
	gchar* next_uri = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_signal_emit (self, g4_gst_player_signals[G4_GST_PLAYER_NEXT_URI_REQUEST_SIGNAL], 0, &_tmp0_);
	next_uri = _tmp0_;
	_tmp2_ = next_uri;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = next_uri;
		_tmp4_ = strlen ((const gchar*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp6_;
		g_atomic_int_set ((volatile gint *) (&self->priv->_next_uri_requested), 1);
		_tmp6_ = next_uri;
		g4_gst_player_set_uri (self, (const gchar*) _tmp6_);
	}
	_g_free0 (next_uri);
}

static void
g4_gst_player_parse_duration (G4GstPlayer* self)
{
	GstPipeline* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_pipeline;
	_tmp2_ = gst_element_query_duration ((GstElement*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gst_pipeline_get_type (), GstPipeline), GST_FORMAT_TIME, &_tmp1_);
	self->priv->_duration = (GstClockTime) _tmp1_;
	if (_tmp2_) {
		g_signal_emit (self, g4_gst_player_signals[G4_GST_PLAYER_DURATION_CHANGED_SIGNAL], 0, self->priv->_duration);
	} else {
		self->priv->_duration = GST_CLOCK_TIME_NONE;
	}
}

static gboolean
g4_gst_player_parse_position (G4GstPlayer* self)
{
	GstPipeline* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_pipeline;
	_tmp2_ = gst_element_query_position ((GstElement*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gst_pipeline_get_type (), GstPipeline), GST_FORMAT_TIME, &_tmp1_);
	self->priv->_position = (GstClockTime) _tmp1_;
	if (_tmp2_) {
		g_signal_emit (self, g4_gst_player_signals[G4_GST_PLAYER_POSITION_UPDATED_SIGNAL], 0, self->priv->_position);
	} else {
		self->priv->_position = GST_CLOCK_TIME_NONE;
	}
	result = TRUE;
	return result;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static GstElement*
g4_gst_player_setup_audio_sink (G4GstPlayer* self)
{
	GstBin* sink_bin = NULL;
	GstElement* _tmp0_;
	GstBin* _tmp1_;
	GstElement* _tmp2_;
	GstElement* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GstElement* _tmp24_;
	GstElement* _tmp47_ = NULL;
	GstElement* _tmp48_;
	gchar* _tmp49_ = NULL;
	const gchar* _tmp52_ = NULL;
	GstElement* _tmp53_ = NULL;
	GstElement* _tmp54_;
	GstElement* _tmp56_ = NULL;
	GstPad* _tmp57_ = NULL;
	GstPad* static_pad = NULL;
	GstPad* _tmp59_;
	GstPad* _tmp60_;
	GstElement* _tmp79_ = NULL;
	GstPad* _tmp80_;
	GstElement* _tmp83_;
	GstElement* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gst_element_factory_make ("bin", "audio-sink-bin");
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gst_bin_get_type ()) ? ((GstBin*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	if (_tmp1_ != NULL) {
		g_object_ref_sink (_tmp1_);
	}
	sink_bin = _tmp1_;
	_tmp2_ = self->priv->_replay_gain;
	if (_tmp2_ != NULL) {
		GstElement* _tmp3_ = NULL;
		GstElement* _tmp4_;
		GstObject* _tmp5_ = NULL;
		GstBin* _tmp8_ = NULL;
		gboolean* _tmp9_ = NULL;
		GstBin* _tmp13_ = NULL;
		GstBin* _tmp14_;
		gboolean* _tmp15_ = NULL;
		_tmp4_ = self->priv->_replay_gain;
		_tmp3_ = _tmp4_;
		_tmp5_ = NULL;
		if (_tmp3_ != NULL) {
			GstObject* _tmp6_;
			GstObject* _tmp7_;
			_tmp6_ = gst_object_get_parent ((GstObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gst_element_get_type (), GstElement));
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_tmp5_ = _tmp7_;
		}
		_tmp8_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gst_bin_get_type ()) ? ((GstBin*) _tmp5_) : NULL;
		_tmp9_ = NULL;
		if (_tmp8_ != NULL) {
			GstElement* _tmp10_;
			gboolean _tmp11_;
			gboolean* _tmp12_;
			_tmp10_ = self->priv->_replay_gain;
			_tmp11_ = G_TYPE_INSTANCE_GET_CLASS (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gst_bin_get_type (), GstBin), gst_bin_get_type (), GstBinClass)->remove_element (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gst_bin_get_type (), GstBin), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gst_element_get_type (), GstElement));
			_tmp12_ = __bool_dup0 (&_tmp11_);
			_g_free0 (_tmp9_);
			_tmp9_ = _tmp12_;
		}
		_tmp14_ = sink_bin;
		_tmp13_ = _tmp14_;
		_tmp15_ = NULL;
		if (_tmp13_ != NULL) {
			GstElement* _tmp16_;
			gboolean _tmp17_;
			gboolean* _tmp18_;
			_tmp16_ = self->priv->_replay_gain;
			_tmp17_ = gst_bin_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gst_bin_get_type (), GstBin), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gst_element_get_type (), GstElement));
			_tmp18_ = __bool_dup0 (&_tmp17_);
			_g_free0 (_tmp15_);
			_tmp15_ = _tmp18_;
		}
		_g_free0 (_tmp15_);
		_g_free0 (_tmp9_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp19_ = self->priv->_replay_gain;
	_tmp20_ = bool_to_string (_tmp19_ != NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat ("Enable ReplayGain: ", _tmp21_, "\n", NULL);
	_tmp23_ = _tmp22_;
	g_print ("%s", _tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_tmp24_ = self->priv->_audio_sink;
	if (_tmp24_ != NULL) {
		GstElement* _tmp25_ = NULL;
		GstElement* _tmp26_;
		GstObject* _tmp27_ = NULL;
		GstBin* _tmp30_ = NULL;
		gboolean* _tmp31_ = NULL;
		GstBin* _tmp35_ = NULL;
		GstBin* _tmp36_;
		gboolean* _tmp37_ = NULL;
		GstElement* _tmp41_ = NULL;
		GstElement* _tmp42_;
		gboolean* _tmp43_ = NULL;
		_tmp26_ = self->priv->_audio_sink;
		_tmp25_ = _tmp26_;
		_tmp27_ = NULL;
		if (_tmp25_ != NULL) {
			GstObject* _tmp28_;
			GstObject* _tmp29_;
			_tmp28_ = gst_object_get_parent ((GstObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gst_element_get_type (), GstElement));
			_tmp29_ = _tmp28_;
			_g_object_unref0 (_tmp27_);
			_tmp27_ = _tmp29_;
		}
		_tmp30_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, gst_bin_get_type ()) ? ((GstBin*) _tmp27_) : NULL;
		_tmp31_ = NULL;
		if (_tmp30_ != NULL) {
			GstElement* _tmp32_;
			gboolean _tmp33_;
			gboolean* _tmp34_;
			_tmp32_ = self->priv->_audio_sink;
			_tmp33_ = G_TYPE_INSTANCE_GET_CLASS (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gst_bin_get_type (), GstBin), gst_bin_get_type (), GstBinClass)->remove_element (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gst_bin_get_type (), GstBin), G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gst_element_get_type (), GstElement));
			_tmp34_ = __bool_dup0 (&_tmp33_);
			_g_free0 (_tmp31_);
			_tmp31_ = _tmp34_;
		}
		_tmp36_ = sink_bin;
		_tmp35_ = _tmp36_;
		_tmp37_ = NULL;
		if (_tmp35_ != NULL) {
			GstElement* _tmp38_;
			gboolean _tmp39_;
			gboolean* _tmp40_;
			_tmp38_ = self->priv->_audio_sink;
			_tmp39_ = gst_bin_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gst_bin_get_type (), GstBin), G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gst_element_get_type (), GstElement));
			_tmp40_ = __bool_dup0 (&_tmp39_);
			_g_free0 (_tmp37_);
			_tmp37_ = _tmp40_;
		}
		_tmp42_ = self->priv->_replay_gain;
		_tmp41_ = _tmp42_;
		_tmp43_ = NULL;
		if (_tmp41_ != NULL) {
			GstElement* _tmp44_;
			gboolean _tmp45_;
			gboolean* _tmp46_;
			_tmp44_ = self->priv->_audio_sink;
			_tmp45_ = gst_element_link (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gst_element_get_type (), GstElement), G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gst_element_get_type (), GstElement));
			_tmp46_ = __bool_dup0 (&_tmp45_);
			_g_free0 (_tmp43_);
			_tmp43_ = _tmp46_;
		}
		_g_free0 (_tmp43_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp31_);
		_g_object_unref0 (_tmp27_);
	}
	_tmp48_ = self->priv->_audio_sink;
	_tmp47_ = _tmp48_;
	_tmp49_ = NULL;
	if (_tmp47_ != NULL) {
		gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp50_ = gst_object_get_name ((GstObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gst_element_get_type (), GstElement));
		_tmp51_ = _tmp50_;
		_g_free0 (_tmp49_);
		_tmp49_ = _tmp51_;
	}
	_tmp52_ = _tmp49_;
	if (_tmp52_ == NULL) {
		_tmp52_ = "";
	}
	g_print ("Audio Sink: %s\n", (const gchar*) _tmp52_);
	_tmp54_ = self->priv->_replay_gain;
	_tmp53_ = _tmp54_;
	if (_tmp53_ == NULL) {
		GstElement* _tmp55_;
		_tmp55_ = self->priv->_audio_sink;
		_tmp53_ = _tmp55_;
	}
	_tmp56_ = _tmp53_;
	_tmp57_ = NULL;
	if (_tmp56_ != NULL) {
		GstPad* _tmp58_;
		_tmp58_ = gst_element_get_static_pad (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gst_element_get_type (), GstElement), "sink");
		_g_object_unref0 (_tmp57_);
		_tmp57_ = _tmp58_;
	}
	_tmp59_ = _tmp57_;
	_tmp57_ = NULL;
	static_pad = _tmp59_;
	_tmp60_ = static_pad;
	if (_tmp60_ != NULL) {
		GstBin* _tmp61_ = NULL;
		GstBin* _tmp62_;
		gboolean* _tmp63_ = NULL;
		_tmp62_ = sink_bin;
		_tmp61_ = _tmp62_;
		_tmp63_ = NULL;
		if (_tmp61_ != NULL) {
			GstPad* _tmp64_;
			GstGhostPad* _tmp65_;
			GstGhostPad* _tmp66_;
			gboolean _tmp67_;
			gboolean* _tmp68_;
			_tmp64_ = static_pad;
			_tmp65_ = (GstGhostPad*) gst_ghost_pad_new ("sink", G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gst_pad_get_type (), GstPad));
			g_object_ref_sink (_tmp65_);
			_tmp66_ = _tmp65_;
			_tmp67_ = gst_element_add_pad ((GstElement*) G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gst_bin_get_type (), GstBin), (GstPad*) _tmp66_);
			_tmp68_ = __bool_dup0 (&_tmp67_);
			_g_free0 (_tmp63_);
			_tmp63_ = _tmp68_;
			_g_object_unref0 (_tmp66_);
		}
		_g_free0 (_tmp63_);
	} else {
		GstElement* _tmp69_ = NULL;
		GstElement* _tmp70_;
		GstObject* _tmp71_ = NULL;
		GstBin* _tmp74_ = NULL;
		gboolean* _tmp75_ = NULL;
		_tmp70_ = self->priv->_audio_sink;
		_tmp69_ = _tmp70_;
		_tmp71_ = NULL;
		if (_tmp69_ != NULL) {
			GstObject* _tmp72_;
			GstObject* _tmp73_;
			_tmp72_ = gst_object_get_parent ((GstObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gst_element_get_type (), GstElement));
			_tmp73_ = _tmp72_;
			_g_object_unref0 (_tmp71_);
			_tmp71_ = _tmp73_;
		}
		_tmp74_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, gst_bin_get_type ()) ? ((GstBin*) _tmp71_) : NULL;
		_tmp75_ = NULL;
		if (_tmp74_ != NULL) {
			GstElement* _tmp76_;
			gboolean _tmp77_;
			gboolean* _tmp78_;
			_tmp76_ = self->priv->_audio_sink;
			_tmp77_ = G_TYPE_INSTANCE_GET_CLASS (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, gst_bin_get_type (), GstBin), gst_bin_get_type (), GstBinClass)->remove_element (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, gst_bin_get_type (), GstBin), G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, gst_element_get_type (), GstElement));
			_tmp78_ = __bool_dup0 (&_tmp77_);
			_g_free0 (_tmp75_);
			_tmp75_ = _tmp78_;
		}
		_g_free0 (_tmp75_);
		_g_object_unref0 (_tmp71_);
	}
	_tmp80_ = static_pad;
	if (_tmp80_ != NULL) {
		GstBin* _tmp81_;
		_tmp81_ = sink_bin;
		_tmp79_ = (GstElement*) _tmp81_;
	} else {
		GstElement* _tmp82_;
		_tmp82_ = self->priv->_audio_sink;
		_tmp79_ = _tmp82_;
	}
	_tmp83_ = _g_object_ref0 (_tmp79_);
	result = _tmp83_;
	_g_object_unref0 (static_pad);
	_g_object_unref0 (_tmp57_);
	_g_free0 (_tmp49_);
	_g_object_unref0 (sink_bin);
	return result;
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		G4GstPlayer* self;
		self = _data17_->self;
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static gboolean
___lambda41_ (Block17Data* _data17_)
{
	G4GstPlayer* self;
	gboolean result;
	self = _data17_->self;
	if (self->priv->_state == _data17_->saved_state) {
		g4_gst_player_seek (self, _data17_->saved_pos);
		result = FALSE;
		return result;
	}
	result = self->priv->_state != GST_STATE_NULL;
	return result;
}

static gboolean
____lambda41__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda41_ (self);
	return result;
}

static void
g4_gst_player_update_audio_sink (G4GstPlayer* self)
{
	Block17Data* _data17_;
	GstPipeline* pipeline = NULL;
	GstPipeline* _tmp0_;
	GstPipeline* _tmp1_;
	GstPipeline* _tmp2_;
	GstPipeline* _tmp3_;
	GstElement* _tmp4_;
	GstElement* _tmp5_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = self->priv->_pipeline;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gst_pipeline_get_type (), GstPipeline));
	pipeline = _tmp1_;
	_data17_->saved_pos = self->priv->_position;
	_data17_->saved_state = self->priv->_state;
	_tmp2_ = pipeline;
	gst_element_set_state ((GstElement*) _tmp2_, GST_STATE_NULL);
	_tmp3_ = pipeline;
	_tmp4_ = g4_gst_player_setup_audio_sink (self);
	_tmp5_ = _tmp4_;
	g_object_set (_tmp3_, "audio-sink", _tmp5_, NULL);
	_g_object_unref0 (_tmp5_);
	if (_data17_->saved_state != GST_STATE_NULL) {
		GstPipeline* _tmp6_;
		_tmp6_ = pipeline;
		gst_element_set_state ((GstElement*) _tmp6_, _data17_->saved_state);
	}
	if (_data17_->saved_pos != GST_CLOCK_TIME_NONE) {
		_tmp7_ = _data17_->saved_state >= GST_STATE_PAUSED;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		g_idle_add_full (G_PRIORITY_LOW, ____lambda41__gsource_func, block17_data_ref (_data17_), block17_data_unref);
	}
	_g_object_unref0 (pipeline);
	block17_data_unref (_data17_);
	_data17_ = NULL;
}

gboolean
g4_gst_player_get_gapless (G4GstPlayer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_about_to_finish_id != ((gulong) 0);
	return result;
}

static void
_g4_gst_player_on_stream_to_finish_dynamic_about_to_finish0_ (GstPipeline* _sender,
                                                              gpointer self)
{
	g4_gst_player_on_stream_to_finish ((G4GstPlayer*) self);
}

void
g4_gst_player_set_gapless (G4GstPlayer* self,
                           gboolean value)
{
	GstPipeline* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_pipeline;
	if (_tmp0_ != NULL) {
		GstPipeline* pipeline = NULL;
		GstPipeline* _tmp1_;
		GstPipeline* _tmp2_;
		_tmp1_ = self->priv->_pipeline;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gst_pipeline_get_type (), GstPipeline));
		pipeline = _tmp2_;
		if (self->priv->_about_to_finish_id != ((gulong) 0)) {
			GstPipeline* _tmp3_;
			_tmp3_ = pipeline;
			g_signal_handler_disconnect ((GObject*) _tmp3_, self->priv->_about_to_finish_id);
			self->priv->_about_to_finish_id = (gulong) 0;
		}
		if (value) {
			GstPipeline* _tmp4_;
			gulong _tmp5_;
			_tmp4_ = pipeline;
			_tmp5_ = g_signal_connect_object (_tmp4_, "about-to-finish", (GCallback) _g4_gst_player_on_stream_to_finish_dynamic_about_to_finish0_, self, 0);
			self->priv->_about_to_finish_id = _tmp5_;
		}
		_g_object_unref0 (pipeline);
	}
	g_object_notify_by_pspec ((GObject *) self, g4_gst_player_properties[G4_GST_PLAYER_GAPLESS_PROPERTY]);
}

gboolean
g4_gst_player_get_playing (G4GstPlayer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_state == GST_STATE_PLAYING;
	return result;
}

void
g4_gst_player_set_playing (G4GstPlayer* self,
                           gboolean value)
{
	GstState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	if (self->priv->_state == GST_STATE_PLAYING) {
		_tmp0_ = GST_STATE_PAUSED;
	} else {
		_tmp0_ = GST_STATE_PLAYING;
	}
	g4_gst_player_set_state (self, _tmp0_);
	g_object_notify_by_pspec ((GObject *) self, g4_gst_player_properties[G4_GST_PLAYER_PLAYING_PROPERTY]);
}

GstState
g4_gst_player_get_state (G4GstPlayer* self)
{
	GstState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
g4_gst_player_set_state (G4GstPlayer* self,
                         GstState value)
{
	GstPipeline* _tmp0_ = NULL;
	GstPipeline* _tmp1_;
	GstStateChangeReturn* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_pipeline;
	_tmp0_ = _tmp1_;
	_tmp2_ = NULL;
	if (_tmp0_ != NULL) {
		GstStateChangeReturn _tmp3_;
		GstStateChangeReturn* _tmp4_;
		_tmp3_ = gst_element_set_state ((GstElement*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gst_pipeline_get_type (), GstPipeline), value);
		_tmp4_ = __gst_state_change_return_dup0 (&_tmp3_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp4_;
	}
	_g_free0 (_tmp2_);
	g_object_notify_by_pspec ((GObject *) self, g4_gst_player_properties[G4_GST_PLAYER_STATE_PROPERTY]);
}

const gchar*
g4_gst_player_get_uri (G4GstPlayer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_uri;
	result = _tmp0_;
	return result;
}

void
g4_gst_player_set_uri (G4GstPlayer* self,
                       const gchar* value)
{
	gchar* _tmp0_;
	GstPipeline* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_current_uri);
	self->priv->_current_uri = _tmp0_;
	_tmp1_ = self->priv->_pipeline;
	if (_tmp1_ != NULL) {
		GstPipeline* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = self->priv->_pipeline;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gst_pipeline_get_type (), GstPipeline), "uri", value, NULL);
		_tmp3_ = g_atomic_int_compare_and_exchange ((volatile gint *) (&self->priv->_audio_sink_requested), 1, 0);
		if (_tmp3_) {
			g4_gst_player_update_audio_sink (self);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, g4_gst_player_properties[G4_GST_PLAYER_URI_PROPERTY]);
}

const gchar*
g4_gst_player_get_audio_sink (G4GstPlayer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_audio_sink_name;
	result = _tmp0_;
	return result;
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

void
g4_gst_player_set_audio_sink (G4GstPlayer* self,
                              const gchar* value)
{
	gchar* sink_name = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GstElement* sink = NULL;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GstElement* _tmp24_;
	GstElement* _tmp25_;
	gboolean _tmp30_ = FALSE;
	GstPipeline* _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	sink_name = _tmp0_;
	_tmp2_ = sink_name;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		_tmp1_ = TRUE;
	} else {
		GstElementFactory* _tmp5_ = NULL;
		const gchar* _tmp6_;
		GstElementFactory* _tmp7_;
		guint* _tmp8_ = NULL;
		guint* _tmp11_ = NULL;
		guint* _tmp12_;
		_tmp6_ = sink_name;
		_tmp7_ = gst_element_factory_find (_tmp6_);
		_tmp5_ = _tmp7_;
		_tmp8_ = NULL;
		if (_tmp5_ != NULL) {
			guint _tmp9_;
			guint* _tmp10_;
			_tmp9_ = gst_plugin_feature_get_rank ((GstPluginFeature*) G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gst_element_factory_get_type (), GstElementFactory));
			_tmp10_ = __uint_dup0 (&_tmp9_);
			_g_free0 (_tmp8_);
			_tmp8_ = _tmp10_;
		}
		_tmp12_ = __uint_dup0 (_tmp8_);
		_tmp11_ = _tmp12_;
		if (_tmp11_ == NULL) {
			guint _tmp13_;
			guint* _tmp14_;
			_tmp13_ = (guint) GST_RANK_NONE;
			_tmp14_ = __uint_dup0 (&_tmp13_);
			_g_free0 (_tmp11_);
			_tmp11_ = _tmp14_;
		}
		_tmp1_ = (*_tmp11_) <= ((guint) GST_RANK_MARGINAL);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp8_);
		_g_object_unref0 (_tmp5_);
	}
	if (_tmp1_) {
		GList* list = NULL;
		GList* _tmp15_;
		GList* _tmp16_;
		_tmp15_ = gst_element_factory_list_get_elements (GST_ELEMENT_FACTORY_TYPE_AUDIOVIDEO_SINKS, GST_RANK_PRIMARY);
		list = _tmp15_;
		_tmp16_ = list;
		if (!vala_g_list_is_empty (_tmp16_)) {
			GList* _tmp17_;
			GList* _tmp18_;
			gconstpointer _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp17_ = list;
			_tmp18_ = g_list_first (_tmp17_);
			_tmp19_ = _tmp18_->data;
			_tmp20_ = gst_object_get_name ((GstObject*) ((GstElementFactory*) _tmp19_));
			_tmp21_ = _tmp20_;
			_g_free0 (sink_name);
			sink_name = _tmp21_;
		}
		(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
	}
	_tmp22_ = sink_name;
	_tmp23_ = sink_name;
	_tmp24_ = gst_element_factory_make (_tmp22_, _tmp23_);
	if (_tmp24_ != NULL) {
		g_object_ref_sink (_tmp24_);
	}
	sink = _tmp24_;
	_tmp25_ = sink;
	if (_tmp25_ != NULL) {
		GstElement* _tmp26_;
		GstElement* _tmp27_;
		gchar* _tmp28_;
		GstElement* _tmp29_;
		_tmp26_ = sink;
		_tmp27_ = _g_object_ref0 (_tmp26_);
		_g_object_unref0 (self->priv->_audio_sink);
		self->priv->_audio_sink = _tmp27_;
		_tmp28_ = g_strdup (value);
		_g_free0 (self->priv->_audio_sink_name);
		self->priv->_audio_sink_name = _tmp28_;
		_tmp29_ = self->priv->_audio_sink;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gst_element_get_type (), GstElement), "enable-last-sample", TRUE, NULL);
	}
	_tmp31_ = self->priv->_pipeline;
	if (_tmp31_ != NULL) {
		const gchar* _tmp32_;
		_tmp32_ = self->priv->_current_uri;
		_tmp30_ = _tmp32_ != NULL;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		g4_gst_player_update_audio_sink (self);
	} else {
		g_atomic_int_set ((volatile gint *) (&self->priv->_audio_sink_requested), 1);
	}
	_g_object_unref0 (sink);
	_g_free0 (sink_name);
	g_object_notify_by_pspec ((GObject *) self, g4_gst_player_properties[G4_GST_PLAYER_AUDIO_SINK_PROPERTY]);
}

gdouble
g4_gst_player_get_peak (G4GstPlayer* self)
{
	gdouble result;
	gdouble value = 0.0;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_;
	GstElement* sink = NULL;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	gdouble _tmp15_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	value = self->priv->_last_peak;
	_tmp1_ = self->priv->_audio_sink;
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		GstPipeline* _tmp2_ = NULL;
		GstPipeline* _tmp3_;
		GstPipeline* _tmp4_ = NULL;
		_tmp3_ = self->priv->_pipeline;
		_tmp2_ = _tmp3_;
		_tmp4_ = NULL;
		if (_tmp2_ != NULL) {
			GstPipeline* _tmp5_;
			GstPipeline* _tmp6_;
			g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gst_pipeline_get_type (), GstPipeline), "audio-sink", &_tmp5_, NULL);
			_tmp6_ = _tmp5_;
			_tmp4_ = _tmp6_;
		}
		_tmp0_ = (GstElement*) _tmp4_;
	}
	_tmp7_ = _g_object_ref0 (_tmp0_);
	sink = _tmp7_;
	_tmp8_ = sink;
	if (_tmp8_ != NULL) {
		GstSample* sample = NULL;
		GstElement* _tmp9_;
		GstSample* _tmp10_;
		GstSample* _tmp11_;
		GstSample* _tmp12_;
		_tmp9_ = sink;
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gst_element_get_type (), GstElement), "last-sample", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		sample = _tmp11_;
		_tmp12_ = sample;
		if (_tmp12_ != NULL) {
			G4LevelCalculator* _tmp13_;
			GstSample* _tmp14_;
			_tmp13_ = self->priv->_peak_calculator;
			_tmp14_ = sample;
			g4_level_calculator_calculate_sample (_tmp13_, (GstSample*) _tmp14_, self->priv->_position, &value);
		}
		_gst_sample_unref0 (sample);
	}
	if (self->priv->_last_peak >= 0.033) {
		_tmp15_ = self->priv->_last_peak - 0.033;
	} else {
		_tmp15_ = (gdouble) 0;
	}
	value = MAX (value, _tmp15_);
	self->priv->_last_peak = value;
	result = value;
	_g_object_unref0 (sink);
	return result;
}

GstClockTime
g4_gst_player_get_position (G4GstPlayer* self)
{
	GstClockTime result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_position;
	return result;
}

void
g4_gst_player_set_position (G4GstPlayer* self,
                            GstClockTime value)
{
	g_return_if_fail (self != NULL);
	g4_gst_player_seek (self, value);
	g_object_notify_by_pspec ((GObject *) self, g4_gst_player_properties[G4_GST_PLAYER_POSITION_PROPERTY]);
}

guint
g4_gst_player_get_replay_gain (G4GstPlayer* self)
{
	guint result;
	GstElement* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_replay_gain;
	if (_tmp0_ != NULL) {
		gint _tmp1_ = 0;
		GstElement* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->_replay_gain;
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gst_element_get_type (), GstElement), "album-mode", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			_tmp1_ = 2;
		} else {
			_tmp1_ = 1;
		}
		result = (guint) _tmp1_;
		return result;
	}
	result = (guint) 0;
	return result;
}

void
g4_gst_player_set_replay_gain (G4GstPlayer* self,
                               guint value)
{
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp2_;
	GstElement* _tmp3_;
	gboolean _tmp5_ = FALSE;
	GstPipeline* _tmp6_;
	g_return_if_fail (self != NULL);
	if (value != ((guint) 0)) {
		GstElement* _tmp1_;
		_tmp1_ = gst_element_factory_make ("rgvolume", "gain");
		if (_tmp1_ != NULL) {
			g_object_ref_sink (_tmp1_);
		}
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	_tmp2_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_replay_gain);
	self->priv->_replay_gain = _tmp2_;
	_tmp3_ = self->priv->_replay_gain;
	if (_tmp3_ != NULL) {
		GstElement* _tmp4_;
		_tmp4_ = self->priv->_replay_gain;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gst_element_get_type (), GstElement), "album-mode", value == ((guint) 2), NULL);
	}
	_tmp6_ = self->priv->_pipeline;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = self->priv->_current_uri;
		_tmp5_ = _tmp7_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		g4_gst_player_update_audio_sink (self);
	} else {
		g_atomic_int_set ((volatile gint *) (&self->priv->_audio_sink_requested), 1);
	}
	_g_object_unref0 (_tmp0_);
	g_object_notify_by_pspec ((GObject *) self, g4_gst_player_properties[G4_GST_PLAYER_REPLAY_GAIN_PROPERTY]);
}

GstTagList*
g4_gst_player_get_tag_list (G4GstPlayer* self)
{
	GstTagList* result;
	GstTagList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tag_list;
	result = _tmp0_;
	return result;
}

gdouble
g4_gst_player_get_volume (G4GstPlayer* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_volume;
	return result;
}

void
g4_gst_player_set_volume (G4GstPlayer* self,
                          gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = g4_gst_player_get_volume (self);
	if (old_value != value) {
		self->priv->_volume = value;
		g_object_notify_by_pspec ((GObject *) self, g4_gst_player_properties[G4_GST_PLAYER_VOLUME_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__UINT64 (GClosure * closure,
                                      GValue * return_value,
                                      guint n_param_values,
                                      const GValue * param_values,
                                      gpointer invocation_hint,
                                      gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT64) (gpointer data1, GstClockTime arg_1, gpointer data2);
	register GMarshalFunc_VOID__UINT64 callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT64) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint64 (param_values + 1), data2);
}

static void
g_cclosure_user_marshal_STRING__VOID (GClosure * closure,
                                      GValue * return_value,
                                      guint n_param_values,
                                      const GValue * param_values,
                                      gpointer invocation_hint,
                                      gpointer marshal_data)
{
	typedef const char* (*GMarshalFunc_STRING__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_STRING__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	const char* v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_STRING__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_take_string (return_value, v_return);
}

static void
g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}

static void
g4_gst_player_class_init (G4GstPlayerClass * klass,
                          gpointer klass_data)
{
	g4_gst_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &G4GstPlayer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_g4_gst_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_g4_gst_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = g4_gst_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_GST_PLAYER_GAPLESS_PROPERTY, g4_gst_player_properties[G4_GST_PLAYER_GAPLESS_PROPERTY] = g_param_spec_boolean ("gapless", "gapless", "gapless", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_GST_PLAYER_PLAYING_PROPERTY, g4_gst_player_properties[G4_GST_PLAYER_PLAYING_PROPERTY] = g_param_spec_boolean ("playing", "playing", "playing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_GST_PLAYER_STATE_PROPERTY, g4_gst_player_properties[G4_GST_PLAYER_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", gst_state_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_GST_PLAYER_URI_PROPERTY, g4_gst_player_properties[G4_GST_PLAYER_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_GST_PLAYER_AUDIO_SINK_PROPERTY, g4_gst_player_properties[G4_GST_PLAYER_AUDIO_SINK_PROPERTY] = g_param_spec_string ("audio-sink", "audio-sink", "audio-sink", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_GST_PLAYER_PEAK_PROPERTY, g4_gst_player_properties[G4_GST_PLAYER_PEAK_PROPERTY] = g_param_spec_double ("peak", "peak", "peak", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_GST_PLAYER_POSITION_PROPERTY, g4_gst_player_properties[G4_GST_PLAYER_POSITION_PROPERTY] = g_param_spec_uint64 ("position", "position", "position", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_GST_PLAYER_REPLAY_GAIN_PROPERTY, g4_gst_player_properties[G4_GST_PLAYER_REPLAY_GAIN_PROPERTY] = g_param_spec_uint ("replay-gain", "replay-gain", "replay-gain", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_GST_PLAYER_TAG_LIST_PROPERTY, g4_gst_player_properties[G4_GST_PLAYER_TAG_LIST_PROPERTY] = g_param_spec_boxed ("tag-list", "tag-list", "tag-list", gst_tag_list_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_GST_PLAYER_VOLUME_PROPERTY, g4_gst_player_properties[G4_GST_PLAYER_VOLUME_PROPERTY] = g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g4_gst_player_signals[G4_GST_PLAYER_DURATION_CHANGED_SIGNAL] = g_signal_new ("duration-changed", G4_TYPE_GST_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT64, G_TYPE_NONE, 1, G_TYPE_UINT64);
	g4_gst_player_signals[G4_GST_PLAYER_ERROR_SIGNAL] = g_signal_new ("error", G4_TYPE_GST_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_ERROR);
	g4_gst_player_signals[G4_GST_PLAYER_END_OF_STREAM_SIGNAL] = g_signal_new ("end-of-stream", G4_TYPE_GST_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g4_gst_player_signals[G4_GST_PLAYER_POSITION_UPDATED_SIGNAL] = g_signal_new ("position-updated", G4_TYPE_GST_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT64, G_TYPE_NONE, 1, G_TYPE_UINT64);
	g4_gst_player_signals[G4_GST_PLAYER_NEXT_URI_REQUEST_SIGNAL] = g_signal_new ("next-uri-request", G4_TYPE_GST_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_STRING__VOID, G_TYPE_STRING, 0);
	g4_gst_player_signals[G4_GST_PLAYER_NEXT_URI_START_SIGNAL] = g_signal_new ("next-uri-start", G4_TYPE_GST_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g4_gst_player_signals[G4_GST_PLAYER_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", G4_TYPE_GST_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, gst_state_get_type ());
	g4_gst_player_signals[G4_GST_PLAYER_TAG_PARSED_SIGNAL] = g_signal_new ("tag-parsed", G4_TYPE_GST_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, gst_tag_list_get_type ());
}

static void
g4_gst_player_instance_init (G4GstPlayer * self,
                             gpointer klass)
{
	gchar* _tmp0_;
	G4LevelCalculator* _tmp1_;
	GThread* _tmp2_;
	self->priv = g4_gst_player_get_instance_private (self);
	self->priv->_pipeline = NULL;
	self->priv->_audio_sink = NULL;
	self->priv->_replay_gain = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_audio_sink_name = _tmp0_;
	self->priv->_audio_sink_requested = 0;
	self->priv->_current_uri = NULL;
	self->priv->_duration = GST_CLOCK_TIME_NONE;
	self->priv->_position = GST_CLOCK_TIME_NONE;
	self->priv->_last_error_code = 0;
	self->priv->_about_to_finish_id = (gulong) 0;
	self->priv->_next_uri_requested = 0;
	self->priv->_last_peak = (gdouble) 0;
	_tmp1_ = g4_level_calculator_new ();
	self->priv->_peak_calculator = _tmp1_;
	self->priv->_state = GST_STATE_NULL;
	self->priv->_seeking = FALSE;
	self->priv->_tag_list = NULL;
	self->priv->_tag_handle = (guint) 0;
	self->priv->_tag_parsed = FALSE;
	self->priv->_timer_handle = (guint) 0;
	_tmp2_ = g_thread_self ();
	self->priv->_main_thread = _tmp2_;
}

static void
g4_gst_player_finalize (GObject * obj)
{
	G4GstPlayer * self;
	G4LevelCalculator* _tmp0_;
	GstPipeline* _tmp1_ = NULL;
	GstPipeline* _tmp2_;
	GstStateChangeReturn* _tmp3_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_GST_PLAYER, G4GstPlayer);
	if (self->priv->_tag_handle != ((guint) 0)) {
		g_source_remove (self->priv->_tag_handle);
	}
	if (self->priv->_timer_handle != ((guint) 0)) {
		g_source_remove (self->priv->_timer_handle);
	}
	_tmp0_ = self->priv->_peak_calculator;
	g4_level_calculator_clear (_tmp0_);
	_tmp2_ = self->priv->_pipeline;
	_tmp1_ = _tmp2_;
	_tmp3_ = NULL;
	if (_tmp1_ != NULL) {
		GstStateChangeReturn _tmp4_;
		GstStateChangeReturn* _tmp5_;
		_tmp4_ = gst_element_set_state ((GstElement*) G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gst_pipeline_get_type (), GstPipeline), GST_STATE_NULL);
		_tmp5_ = __gst_state_change_return_dup0 (&_tmp4_);
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp5_;
	}
	_g_free0 (_tmp3_);
	_g_object_unref0 (self->priv->_pipeline);
	_g_object_unref0 (self->priv->_audio_sink);
	_g_object_unref0 (self->priv->_replay_gain);
	_g_free0 (self->priv->_audio_sink_name);
	_g_free0 (self->priv->_current_uri);
	_g4_level_calculator_unref0 (self->priv->_peak_calculator);
	_gst_tag_list_unref0 (self->priv->_tag_list);
	G_OBJECT_CLASS (g4_gst_player_parent_class)->finalize (obj);
}

static GType
g4_gst_player_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (G4GstPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_gst_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4GstPlayer), 0, (GInstanceInitFunc) g4_gst_player_instance_init, NULL };
	GType g4_gst_player_type_id;
	g4_gst_player_type_id = g_type_register_static (G_TYPE_OBJECT, "G4GstPlayer", &g_define_type_info, 0);
	G4GstPlayer_private_offset = g_type_add_instance_private (g4_gst_player_type_id, sizeof (G4GstPlayerPrivate));
	return g4_gst_player_type_id;
}

GType
g4_gst_player_get_type (void)
{
	static volatile gsize g4_gst_player_type_id__once = 0;
	if (g_once_init_enter (&g4_gst_player_type_id__once)) {
		GType g4_gst_player_type_id;
		g4_gst_player_type_id = g4_gst_player_get_type_once ();
		g_once_init_leave (&g4_gst_player_type_id__once, g4_gst_player_type_id);
	}
	return g4_gst_player_type_id__once;
}

static void
_vala_g4_gst_player_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	G4GstPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_GST_PLAYER, G4GstPlayer);
	switch (property_id) {
		case G4_GST_PLAYER_GAPLESS_PROPERTY:
		g_value_set_boolean (value, g4_gst_player_get_gapless (self));
		break;
		case G4_GST_PLAYER_PLAYING_PROPERTY:
		g_value_set_boolean (value, g4_gst_player_get_playing (self));
		break;
		case G4_GST_PLAYER_STATE_PROPERTY:
		g_value_set_enum (value, g4_gst_player_get_state (self));
		break;
		case G4_GST_PLAYER_URI_PROPERTY:
		g_value_set_string (value, g4_gst_player_get_uri (self));
		break;
		case G4_GST_PLAYER_AUDIO_SINK_PROPERTY:
		g_value_set_string (value, g4_gst_player_get_audio_sink (self));
		break;
		case G4_GST_PLAYER_PEAK_PROPERTY:
		g_value_set_double (value, g4_gst_player_get_peak (self));
		break;
		case G4_GST_PLAYER_POSITION_PROPERTY:
		g_value_set_uint64 (value, g4_gst_player_get_position (self));
		break;
		case G4_GST_PLAYER_REPLAY_GAIN_PROPERTY:
		g_value_set_uint (value, g4_gst_player_get_replay_gain (self));
		break;
		case G4_GST_PLAYER_TAG_LIST_PROPERTY:
		g_value_set_boxed (value, g4_gst_player_get_tag_list (self));
		break;
		case G4_GST_PLAYER_VOLUME_PROPERTY:
		g_value_set_double (value, g4_gst_player_get_volume (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_g4_gst_player_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	G4GstPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_GST_PLAYER, G4GstPlayer);
	switch (property_id) {
		case G4_GST_PLAYER_GAPLESS_PROPERTY:
		g4_gst_player_set_gapless (self, g_value_get_boolean (value));
		break;
		case G4_GST_PLAYER_PLAYING_PROPERTY:
		g4_gst_player_set_playing (self, g_value_get_boolean (value));
		break;
		case G4_GST_PLAYER_STATE_PROPERTY:
		g4_gst_player_set_state (self, g_value_get_enum (value));
		break;
		case G4_GST_PLAYER_URI_PROPERTY:
		g4_gst_player_set_uri (self, g_value_get_string (value));
		break;
		case G4_GST_PLAYER_AUDIO_SINK_PROPERTY:
		g4_gst_player_set_audio_sink (self, g_value_get_string (value));
		break;
		case G4_GST_PLAYER_POSITION_PROPERTY:
		g4_gst_player_set_position (self, g_value_get_uint64 (value));
		break;
		case G4_GST_PLAYER_REPLAY_GAIN_PROPERTY:
		g4_gst_player_set_replay_gain (self, g_value_get_uint (value));
		break;
		case G4_GST_PLAYER_VOLUME_PROPERTY:
		g4_gst_player_set_volume (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

