/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * gimplanguagestore-data.h
 * Copyright (C) 2024 Jehan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#pragma once

/* NOTE: this file is auto-generated by /build/gimp-git/src/build/tools/gen-languages */

#define GIMP_L10N_LANGS_SIZE 85
#define GIMP_ALL_LANGS_SIZE 189

typedef struct
{
  gchar *code;
  gchar *name;
} GimpLanguageDef;

static const GimpLanguageDef GimpL10nLanguages[GIMP_L10N_LANGS_SIZE] =
{
  { "kab", "Taqbaylit [kab]" },
  { "ckb", "Kurdish, Central [ckb]" },
  { "nds", "German, Low [nds]" },
  { "oc", "Occitan [oc]" },
  { "be", "беларуская [be]" },
  { "ca@valencia", "Català [ca@valencia]" },
  { "mk", "Македонски [mk]" },
  { "nb", "Norwegian Bokmål [nb]" },
  { "ml", "Malayalam [ml]" },
  { "lv", "Latviešu [lv]" },
  { "sv", "Svenska [sv]" },
  { "cs", "čeština [cs]" },
  { "nn", "Norwegian Nynorsk [nn]" },
  { "fa", "فارسی [fa]" },
  { "pt_BR", "Português [pt_BR]" },
  { "ta", "தமிழ் [ta]" },
  { "sk", "Slovenský [sk]" },
  { "ru", "русский [ru]" },
  { "br", "Brezhoneg [br]" },
  { "yi", "Yiddish [yi]" },
  { "xh", "isiXhosa [xh]" },
  { "he", "עברית [he]" },
  { "my", "Burmese [my]" },
  { "el", "Ελληνικά [el]" },
  { "bg", "Български [bg]" },
  { "gd", "Gaelic, Scottish [gd]" },
  { "bs", "Bosnian [bs]" },
  { "is", "Íslenska [is]" },
  { "kk", "Kazakh [kk]" },
  { "ar", "العربية [ar]" },
  { "hr", "Hrvatski [hr]" },
  { "rw", "Ikinyarwanda [rw]" },
  { "ne", "Nepali (macrolanguage) [ne]" },
  { "it", "Italiano [it]" },
  { "pt", "Português [pt]" },
  { "en_CA", "English [en_CA]" },
  { "en_US", "English [en_US]" },
  { "sl", "slovenščina [sl]" },
  { "da", "Dansk [da]" },
  { "ka", "Georgian [ka]" },
  { "sr@latin", "srpski [sr@latin]" },
  { "km", "Khmer [km]" },
  { "zh_CN", "中文 [zh_CN]" },
  { "eo", "Esperanto [eo]" },
  { "te", "Telugu [te]" },
  { "ky", "Kirghiz [ky]" },
  { "zh_HK", "Chinese [zh_HK]" },
  { "hi", "हिंदी [hi]" },
  { "kn", "ಕನ್ನಡ [kn]" },
  { "ca", "Català [ca]" },
  { "ja", "日本語 [ja]" },
  { "hu", "magyar [hu]" },
  { "dz", "Dzongkha [dz]" },
  { "fr", "Français [fr]" },
  { "mr", "मराठी [mr]" },
  { "tr", "Türkçe [tr]" },
  { "ko", "한국어 [ko]" },
  { "ro", "română [ro]" },
  { "pl", "polski [pl]" },
  { "vi", "Tiếng Việt [vi]" },
  { "ms", "Malay (macrolanguage) [ms]" },
  { "pa", "ਪੰਜਾਬੀ [pa]" },
  { "gu", "ગુજરાતી [gu]" },
  { "th", "ไทย [th]" },
  { "de", "Deutsch [de]" },
  { "sr", "српски [sr]" },
  { "ast", "Asturianu [ast]" },
  { "tt", "Татарча [tt]" },
  { "fi", "suomi [fi]" },
  { "es", "Español [es]" },
  { "bn", "বাংলা [bn]" },
  { "zh_TW", "中文 [zh_TW]" },
  { "uk", "українська [uk]" },
  { "csb", "Kashubian [csb]" },
  { "en_GB", "English [en_GB]" },
  { "am", "አማርኛ [am]" },
  { "et", "eesti [et]" },
  { "lt", "Lietuvių [lt]" },
  { "gl", "Galego [gl]" },
  { "nl", "Nederlands [nl]" },
  { "id", "Bahasa Indonesia [id]" },
  { "si", "Sinhala [si]" },
  { "ga", "Gaeilge [ga]" },
  { "eu", "Euskara [eu]" },
  { "az", "Azerbaijani [az]" },
};


static const GimpLanguageDef GimpAllLanguages[GIMP_ALL_LANGS_SIZE] =
{
  { "mi", "Maori" },
  { "bg", "Bulgarian" },
  { "nv", "Navajo" },
  { "kg", "Kongo" },
  { "sq", "Albanian" },
  { "ho", "Hiri Motu" },
  { "lt", "Lithuanian" },
  { "ie", "Interlingue" },
  { "ar", "Arabic" },
  { "tg", "Tajik" },
  { "vi", "Vietnamese" },
  { "cu", "Slavic, Church" },
  { "om", "Oromo" },
  { "sr", "Serbian" },
  { "lu", "Luba-Katanga" },
  { "as", "Assamese" },
  { "mk", "Macedonian" },
  { "bi", "Bislama" },
  { "na", "Nauru" },
  { "gd", "Gaelic, Scottish" },
  { "ki", "Kikuyu" },
  { "cv", "Chuvash" },
  { "ss", "Swati" },
  { "th", "Thai" },
  { "lv", "Latvian" },
  { "ig", "Igbo" },
  { "ml", "Malayalam" },
  { "ti", "Tigrinya" },
  { "fo", "Faroese" },
  { "nb", "Norwegian Bokmål" },
  { "ny", "Chichewa" },
  { "kj", "Kuanyama" },
  { "st", "Sotho, Southern" },
  { "hr", "Croatian" },
  { "wa", "Walloon" },
  { "ca", "Catalan" },
  { "kk", "Kazakh" },
  { "la", "Latin" },
  { "su", "Sundanese" },
  { "tk", "Turkmen" },
  { "ii", "Yi, Sichuan" },
  { "av", "Avaric" },
  { "mn", "Mongolian" },
  { "nd", "Ndebele, North" },
  { "jv", "Javanese" },
  { "kl", "Kalaallisut" },
  { "cy", "Welsh" },
  { "lb", "Luxembourgish" },
  { "ht", "Haitian" },
  { "ee", "Ewe" },
  { "sv", "Swedish" },
  { "bm", "Bambara" },
  { "ne", "Nepali (macrolanguage)" },
  { "kab", "Kabyle" },
  { "tl", "Tagalog" },
  { "km", "Khmer" },
  { "or", "Oriya (macrolanguage)" },
  { "sw", "Swahili (macrolanguage)" },
  { "hu", "Hungarian" },
  { "aa", "Afar" },
  { "ik", "Inupiaq" },
  { "ja", "Japanese" },
  { "bn", "Bengali" },
  { "uz", "Uzbek" },
  { "qu", "Quechua" },
  { "kn", "Kannada" },
  { "fr", "French" },
  { "os", "Ossetian" },
  { "ab", "Abkhazian" },
  { "pi", "Pali" },
  { "ay", "Aymara" },
  { "sa", "Sanskrit" },
  { "bo", "Tibetan" },
  { "ng", "Ndonga" },
  { "ce", "Chechen" },
  { "tn", "Tswana" },
  { "ko", "Korean" },
  { "yi", "Yiddish" },
  { "to", "Tonga (Tonga Islands)" },
  { "az", "Azerbaijani" },
  { "mr", "Marathi" },
  { "rm", "Romansh" },
  { "zu", "Zulu" },
  { "sc", "Sardinian" },
  { "ha", "Hausa" },
  { "vo", "Volapük" },
  { "ms", "Malay (macrolanguage)" },
  { "rn", "Rundi" },
  { "gl", "Galician" },
  { "sd", "Sindhi" },
  { "za", "Zhuang" },
  { "lg", "Ganda" },
  { "ae", "Avestan" },
  { "hy", "Armenian" },
  { "io", "Ido" },
  { "mt", "Maltese" },
  { "br", "Breton" },
  { "ch", "Chamorro" },
  { "ro", "Romanian" },
  { "kr", "Kanuri" },
  { "csb", "Kashubian" },
  { "pl", "Polish" },
  { "hz", "Herero" },
  { "af", "Afrikaans" },
  { "tr", "Turkish" },
  { "fa", "Persian" },
  { "bs", "Bosnian" },
  { "nds", "German, Low" },
  { "gn", "Guarani" },
  { "ks", "Kashmiri" },
  { "li", "Limburgan" },
  { "dv", "Divehi" },
  { "el", "Greek, Modern (1453-)" },
  { "ts", "Tsonga" },
  { "fy", "Frisian, Western" },
  { "nl", "Dutch" },
  { "se", "Sami, Northern" },
  { "sg", "Sango" },
  { "he", "Hebrew" },
  { "tt", "Tatar" },
  { "yo", "Yoruba" },
  { "ug", "Uighur" },
  { "oc", "Occitan (post 1500)" },
  { "ku", "Kurdish" },
  { "da", "Danish" },
  { "sh", "Serbo-Croatian" },
  { "en", "English" },
  { "is", "Icelandic" },
  { "uk", "Ukrainian" },
  { "nn", "Norwegian Nynorsk" },
  { "kv", "Komi" },
  { "si", "Sinhala" },
  { "eo", "Esperanto" },
  { "it", "Italian" },
  { "my", "Burmese" },
  { "no", "Norwegian" },
  { "kw", "Cornish" },
  { "wo", "Wolof" },
  { "dz", "Dzongkha" },
  { "ak", "Akan" },
  { "tw", "Twi" },
  { "iu", "Inuktitut" },
  { "ff", "Fulah" },
  { "ba", "Bashkir" },
  { "ka", "Georgian" },
  { "ru", "Russian" },
  { "sk", "Slovak" },
  { "hi", "Hindi" },
  { "ln", "Lingala" },
  { "ps", "Pushto" },
  { "zh", "Chinese" },
  { "ta", "Tamil" },
  { "co", "Corsican" },
  { "ky", "Kirghiz" },
  { "de", "German" },
  { "lo", "Lao" },
  { "am", "Amharic" },
  { "pt", "Portuguese" },
  { "ty", "Tahitian" },
  { "sl", "Slovenian" },
  { "nr", "Ndebele, South" },
  { "rw", "Kinyarwanda" },
  { "gu", "Gujarati" },
  { "sm", "Samoan" },
  { "ast", "Asturian" },
  { "an", "Aragonese" },
  { "ia", "Interlingua (International Auxiliary Language Association)" },
  { "es", "Spanish" },
  { "fi", "Finnish" },
  { "ve", "Venda" },
  { "xh", "Xhosa" },
  { "gv", "Manx" },
  { "sn", "Shona" },
  { "mg", "Malagasy" },
  { "be", "Belarusian" },
  { "fj", "Fijian" },
  { "et", "Estonian" },
  { "cr", "Cree" },
  { "ckb", "Kurdish, Central" },
  { "oj", "Ojibwa" },
  { "so", "Somali" },
  { "te", "Telugu" },
  { "eu", "Basque" },
  { "mh", "Marshallese" },
  { "ur", "Urdu" },
  { "ga", "Irish" },
  { "cs", "Czech" },
  { "pa", "Panjabi" },
  { "id", "Indonesian" },
};
