/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.sdk;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public enum SDKVersion {
    V211("2.1.1", "1.1", null, null),
    V212("2.1.2", "1.1", null, null),
    V221("2.2.1", "1.2", null, null),
    V222("2.2.2", "1.5", null, null),
    V301("3.0.1", "1.6", null, Arrays.asList(8, 11)),
    V304("3.0.4", "1.6", null, Arrays.asList(8, 11)),
    V305("3.0.5", "1.6", null, Arrays.asList(8, 11)),
    V310("3.1.0", "1.7", Arrays.asList(V304, V305), Arrays.asList(8, 11, 17)),
    V320("3.2.0", "1.7", Arrays.asList(V304, V305, V310), Arrays.asList(8, 11, 17)),
    V320_24_1("3.2.0", "1.7", Arrays.asList(V304, V305, V310, V320), Arrays.asList(11, 17)),
    V320_25_0("3.2.0", "1.8", Arrays.asList(V304, V305, V310, V320), Arrays.asList(8, 11, 17, 21)),
    V320_25_1("3.2.0", "1.8", Arrays.asList(V304, V305, V310, V320), Arrays.asList(8, 11, 17, 21));

    final String v;
    final String class_file_target;
    final Set<Integer> jdks;
    final Set<SDKVersion> targets;

    private SDKVersion(String v, String classfile, Collection<SDKVersion> targets, List<Integer> jdks) {
        this.v = v;
        this.class_file_target = classfile;
        this.targets = targets == null ? new HashSet<SDKVersion>() : new HashSet<SDKVersion>(targets);
        this.jdks = new HashSet<Integer>(jdks == null ? Arrays.asList(8) : jdks);
    }

    public String toString() {
        return this.v;
    }

    public Set<SDKVersion> targets() {
        return Collections.unmodifiableSet(this.targets);
    }

    public boolean isOneOf(SDKVersion ... versions) {
        for (SDKVersion v : versions) {
            if (!this.equals((Object)v)) continue;
            return true;
        }
        return false;
    }

    public String javaVersion() {
        return this.class_file_target;
    }

    public Set<Integer> jdkVersions() {
        return Collections.unmodifiableSet(this.jdks);
    }

    public static Optional<SDKVersion> fromVersion(String versionString) {
        return Arrays.stream(SDKVersion.values()).filter(ver -> ver.v.equals(versionString)).findFirst();
    }

    public boolean equalOrNewer(SDKVersion other) {
        return this.ordinal() >= other.ordinal();
    }
}

