/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.CommandAPDU;
import apdu4j.core.HexUtils;
import apdu4j.core.ResponseAPDU;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPException;
import pro.javacard.gp.SecureChannelWrapper;

class SCP02Wrapper
extends SecureChannelWrapper {
    private static final Logger logger = LoggerFactory.getLogger(SCP02Wrapper.class);
    private final ByteArrayOutputStream rMac = new ByteArrayOutputStream();
    private byte[] icv = null;
    private byte[] ricv = null;
    private boolean icvEnc = false;
    private boolean macModifiedAPDU = false;
    private boolean postAPDU = false;

    SCP02Wrapper(byte[] enc, byte[] mac, byte[] rmac, int bs) {
        super(enc, mac, rmac, bs);
        this.setVariant(85);
    }

    private static byte clearBits(byte b, byte mask) {
        return (byte)(b & ~mask & 0xFF);
    }

    private static byte setBits(byte b, byte mask) {
        return (byte)((b | mask) & 0xFF);
    }

    public void setVariant(int i) {
        this.icvEnc = true;
        this.macModifiedAPDU = true;
    }

    @Override
    public CommandAPDU wrap(CommandAPDU command) throws GPException {
        try {
            int origLc;
            int origCLA;
            if (this.rmac) {
                this.rMac.reset();
                this.rMac.write(SCP02Wrapper.clearBits((byte)command.getCLA(), (byte)7));
                this.rMac.write(command.getINS());
                this.rMac.write(command.getP1());
                this.rMac.write(command.getP2());
                if (command.getNc() >= 0) {
                    this.rMac.write(command.getNc());
                    this.rMac.write(command.getData());
                }
            }
            if (!this.mac && !this.enc) {
                return command;
            }
            int newCLA = origCLA = command.getCLA();
            int origINS = command.getINS();
            int origP1 = command.getP1();
            int origP2 = command.getP2();
            byte[] origData = command.getData();
            int newLc = origLc = command.getNc();
            byte[] newData = null;
            int le = command.getNe();
            ByteArrayOutputStream t = new ByteArrayOutputStream();
            if (origLc > this.getBlockSize()) {
                throw new IllegalArgumentException("APDU too long for wrapping.");
            }
            if (this.mac) {
                if (this.icv == null) {
                    this.icv = new byte[8];
                } else if (this.icvEnc) {
                    this.icv = GPCrypto.des_ecb(this.icv, this.macKey);
                }
                if (this.macModifiedAPDU) {
                    newCLA = SCP02Wrapper.setBits((byte)newCLA, (byte)4);
                    newLc += 8;
                }
                t.write(newCLA);
                t.write(origINS);
                t.write(origP1);
                t.write(origP2);
                t.write(newLc);
                t.write(origData);
                logger.trace("MAC input: {}", (Object)HexUtils.bin2hex(t.toByteArray()));
                this.icv = GPCrypto.mac_des_3des(this.macKey, t.toByteArray(), this.icv);
                if (this.postAPDU) {
                    newCLA = SCP02Wrapper.setBits((byte)newCLA, (byte)4);
                    newLc += 8;
                }
                t.reset();
                newData = origData;
            }
            if (this.enc && origLc > 0) {
                t.write(GPCrypto.pad80(origData, 8));
                newLc += t.size() - origData.length;
                newData = GPCrypto.des3_cbc(t.toByteArray(), this.encKey, new byte[8]);
                t.reset();
            }
            t.write(newCLA);
            t.write(origINS);
            t.write(origP1);
            t.write(origP2);
            if (newLc > 0) {
                t.write(newLc);
                t.write(newData);
            }
            if (this.mac) {
                t.write(this.icv);
            }
            if (le > 0) {
                t.write(le);
            }
            CommandAPDU wrapped = new CommandAPDU(t.toByteArray());
            return wrapped;
        }
        catch (IOException e) {
            throw new RuntimeException("APDU wrapping failed", e);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("APDU wrapping failed", e);
        }
        catch (GeneralSecurityException e) {
            throw new GPException("APDU wrapping failed", e);
        }
    }

    @Override
    public ResponseAPDU unwrap(ResponseAPDU response) throws GPException {
        if (this.rmac) {
            if (response.getData().length < 8) {
                throw new GPException("Wrong response length (too short).");
            }
            int respLen = response.getData().length - 8;
            this.rMac.write(respLen);
            this.rMac.write(response.getData(), 0, respLen);
            this.rMac.write(response.getSW1());
            this.rMac.write(response.getSW2());
            this.ricv = GPCrypto.mac_des_3des(this.rmacKey, GPCrypto.pad80(this.rMac.toByteArray(), 8), this.ricv);
            byte[] actualMac = new byte[8];
            System.arraycopy(response.getData(), respLen, actualMac, 0, 8);
            if (!Arrays.equals(this.ricv, actualMac)) {
                throw new GPException("RMAC invalid.");
            }
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            o.write(response.getBytes(), 0, respLen);
            o.write(response.getSW1());
            o.write(response.getSW2());
            response = new ResponseAPDU(o.toByteArray());
        }
        return response;
    }
}

