/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp.data;

import apdu4j.core.HexUtils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface BitField<T extends Enum<T>> {
    public static final Logger log = LoggerFactory.getLogger(BitField.class);

    public static <T extends Enum<T>> Set<T> parse(Class<T> clazz, byte[] bytes, int ... validLengths) {
        boolean valid;
        if (validLengths.length > 0 && !(valid = Arrays.stream(validLengths).anyMatch(l -> l == bytes.length))) {
            throw new IllegalArgumentException(clazz.getSimpleName() + " must be " + Arrays.toString(validLengths) + " bytes: " + HexUtils.bin2hex(bytes));
        }
        Set<Enum> r = BitField.parse(clazz, bytes);
        for (Enum e : r) {
            if (!(((BitField)((Object)e)).def() instanceof Def.RFU)) continue;
            throw new IllegalArgumentException("RFU bits set in " + clazz.getSimpleName() + ": " + HexUtils.bin2hex(bytes));
        }
        return r;
    }

    public static <T extends Enum<T>> byte[] encode(Set<T> fields, int length) {
        return BitField.toBytes(EnumSet.copyOf(fields), length);
    }

    public static boolean has(byte[] bytes, Def f, boolean lax) {
        if (f instanceof Def.Bits) {
            Def.Bits bits = (Def.Bits)f;
            int yes = 0;
            for (Byte bit : bits.bits()) {
                if (!BitField.get_bit(bit, bytes)) continue;
                ++yes;
            }
            return yes == bits.bits().size();
        }
        if (f instanceof Def.ByteMask) {
            Def.ByteMask byteMask = (Def.ByteMask)f;
            if (byteMask.n() >= bytes.length) {
                if (lax) {
                    log.error("Mask is for a byte that is more than bytes available, defaulting to false");
                    return false;
                }
                throw new IllegalArgumentException("Need byte at index " + byteMask.n() + " but only " + bytes.length + " bytes provided");
            }
            return (bytes[byteMask.n()] & byteMask.mask()) == byteMask.mask();
        }
        if (f instanceof Def.RFU) {
            Def.RFU rfu = (Def.RFU)f;
            return BitField.has(bytes, rfu.def(), true);
        }
        return false;
    }

    public static <T extends Enum<T>> Set<T> parse(Class<T> base, byte[] bytes) {
        EnumSet<T> result = EnumSet.noneOf(base);
        for (Enum e : (Enum[])base.getEnumConstants()) {
            if (!BitField.has(bytes, ((BitField)((Object)e)).def(), true)) continue;
            result.add(e);
            if (!(((BitField)((Object)e)).def() instanceof Def.RFU)) continue;
            log.warn("{} RFU bits set in {}", (Object)base.getName(), (Object)HexUtils.bin2hex(bytes));
        }
        return result;
    }

    public static <T extends Enum<T>> byte[] toBytes(Set<T> fields, int length) {
        byte[] result = new byte[length];
        for (Enum field : fields) {
            Def def = ((BitField)((Object)field)).def();
            if (def instanceof Def.Bits) {
                Def.Bits bits = (Def.Bits)def;
                for (Byte bit : bits.bits()) {
                    int byteIdx = bit >> 3;
                    if (byteIdx >= length) continue;
                    BitField.set_bit(bit, result);
                }
                continue;
            }
            if (def instanceof Def.ByteMask) {
                Def.ByteMask byteMask = (Def.ByteMask)def;
                if (byteMask.n() >= length) continue;
                byte by = byteMask.n();
                result[by] = (byte)(result[by] | byteMask.mask());
                continue;
            }
            if (!(def instanceof Def.RFU)) continue;
            Def.RFU rfu = (Def.RFU)def;
            throw new IllegalArgumentException("RFU bits should never be serialized: " + String.valueOf(rfu));
        }
        return result;
    }

    public static <T extends Enum<T>> byte[] toBytes(Set<T> fields) {
        int length;
        byte[] result = BitField.toBytes(fields, 16);
        for (length = 16; length > 0 && result[length - 1] == 0; --length) {
        }
        byte[] trimmed = new byte[length];
        System.arraycopy(result, 0, trimmed, 0, length);
        return trimmed;
    }

    public static boolean set_bit(byte bit, byte[] bytes) {
        return BitField.set_bit(bytes, (short)0, bit);
    }

    public static boolean get_bit(byte bit, byte[] bytes) {
        return BitField.set_bit(bytes, (short)0, bit);
    }

    public static boolean set_bit(byte[] buffer, short offset, byte bit) {
        short byteIdx = (short)(offset + (bit >> 3));
        byte bitInByte = (byte)(7 - (bit & 7));
        boolean previous = (byte)(buffer[byteIdx] >> bitInByte & 1) == 1;
        buffer[byteIdx] = (byte)(buffer[byteIdx] | (byte)(1 << bitInByte));
        return previous;
    }

    public static boolean get_bit(byte[] buffer, short offset, byte bit) {
        short byteIdx = (short)(offset + (bit >> 3));
        byte bitInByte = (byte)(7 - (bit & 7));
        return (byte)(buffer[byteIdx] >> bitInByte & 1) == 1;
    }

    public static Def.Bits bit(int n) {
        return BitField.bits((byte)n);
    }

    public static Def.Bits bits(int ... bits) {
        return new Def.Bits(Arrays.stream(bits).mapToObj(i -> (byte)i).toList());
    }

    public static Def.Bits byte_bit(int nthByte, int bit) {
        return BitField.bits((byte)(nthByte * 8 + bit));
    }

    public static Def.Bits byte_bit_rl(byte nthByte, int bit) {
        return BitField.bits((byte)((nthByte - 1) * 8 + (8 - bit)));
    }

    public static Def byte_mask(int n, int mask) {
        return new Def.ByteMask((byte)n, (byte)(mask & 0xFF));
    }

    public static <T extends Enum<T>> int length(Class<T> clazz) {
        int max = 0;
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            int len = ((BitField)((Object)e)).def().length();
            if (len <= max) continue;
            max = len;
        }
        return max;
    }

    public Def def();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Def {
        default public int length() {
            Def def = this;
            if (def instanceof Bits) {
                Bits bits = (Bits)def;
                int max = 0;
                for (byte b : bits.bits()) {
                    int v = b & 0xFF;
                    if (v <= max) continue;
                    max = v;
                }
                return max / 8 + 1;
            }
            def = this;
            if (def instanceof ByteMask) {
                ByteMask byteMask = (ByteMask)def;
                return (byteMask.n() & 0xFF) + 1;
            }
            def = this;
            if (def instanceof RFU) {
                RFU rfu = (RFU)def;
                return rfu.def().length();
            }
            throw new IllegalArgumentException("Unknown definition type: " + String.valueOf(this));
        }

        public record Bits(List<Byte> bits) implements Def
        {
            public Bits {
                bits = List.copyOf(bits);
            }
        }

        public record ByteMask(byte n, byte mask) implements Def
        {
        }

        public record RFU(Def def) implements Def
        {
        }
    }
}

