/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.KDFCounterBytesGenerator;
import org.bouncycastle.crypto.macs.CMac;
import org.bouncycastle.crypto.params.KDFCounterParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import pro.javacard.gp.GPUtils;

public final class GPCrypto {
    private static final byte[] one_bytes_16 = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    public static final String DES3_CBC_CIPHER = "DESede/CBC/NoPadding";
    public static final String DES3_ECB_CIPHER = "DESede/ECB/NoPadding";
    static final String DES_CBC_CIPHER = "DES/CBC/NoPadding";
    static final String DES_ECB_CIPHER = "DES/ECB/NoPadding";
    static final String AES_CBC_CIPHER = "AES/CBC/NoPadding";
    private static final SecureRandom rnd;

    private GPCrypto() {
    }

    public static byte[] random(int num) {
        byte[] bytes = new byte[num];
        rnd.nextBytes(bytes);
        return bytes;
    }

    public static byte[] pad80(byte[] text, int blocksize) {
        int total = (text.length / blocksize + 1) * blocksize;
        byte[] result = Arrays.copyOfRange(text, 0, total);
        result[text.length] = -128;
        return result;
    }

    public static byte[] unpad80(byte[] text) throws BadPaddingException {
        int offset;
        if (text.length < 1) {
            throw new BadPaddingException("Invalid ISO 7816-4 padding");
        }
        for (offset = text.length - 1; offset > 0 && text[offset] == 0; --offset) {
        }
        if (text[offset] != -128) {
            throw new BadPaddingException("Invalid ISO 7816-4 padding");
        }
        return Arrays.copyOf(text, offset);
    }

    private static void buffer_increment(byte[] buffer, int offset, int len) {
        if (len < 1) {
            return;
        }
        for (int i = offset + len - 1; i >= offset; --i) {
            if (buffer[i] != -1) {
                int n = i;
                buffer[n] = (byte)(buffer[n] + 1);
                break;
            }
            buffer[i] = 0;
        }
    }

    public static void buffer_increment(byte[] buffer) {
        GPCrypto.buffer_increment(buffer, 0, buffer.length);
    }

    public static byte[] aes_cbc(byte[] data, byte[] key, byte[] iv) throws GeneralSecurityException {
        Cipher c = Cipher.getInstance(AES_CBC_CIPHER);
        c.init(1, GPCrypto.aeskey(key), new IvParameterSpec(iv));
        return c.doFinal(data);
    }

    public static byte[] aes_cbc_decrypt(byte[] data, byte[] key, byte[] iv) throws GeneralSecurityException {
        Cipher c = Cipher.getInstance(AES_CBC_CIPHER);
        c.init(2, GPCrypto.aeskey(key), new IvParameterSpec(iv));
        return c.doFinal(data);
    }

    public static byte[] des3_cbc(byte[] data, byte[] key, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(DES3_CBC_CIPHER);
        cipher.init(1, GPCrypto.des3key(key), new IvParameterSpec(iv));
        return cipher.doFinal(data);
    }

    public static byte[] des_cbc(byte[] data, byte[] key, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(DES_CBC_CIPHER);
        cipher.init(1, (Key)new SecretKeySpec(GPCrypto.resize_des(key, 8), "DES"), new IvParameterSpec(iv));
        return cipher.doFinal(data);
    }

    public static byte[] des_ecb(byte[] data, byte[] key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(DES_ECB_CIPHER);
        cipher.init(1, new SecretKeySpec(GPCrypto.resize_des(key, 8), "DES"));
        return cipher.doFinal(data);
    }

    public static byte[] des3_ecb(byte[] data, byte[] key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(DES3_ECB_CIPHER);
        cipher.init(1, GPCrypto.des3key(key));
        return cipher.doFinal(data);
    }

    public static byte[] mac_3des(byte[] text, byte[] key, byte[] iv) {
        try {
            byte[] d = GPCrypto.pad80(text, 8);
            byte[] cgram = GPCrypto.des3_cbc(d, key, iv);
            return Arrays.copyOfRange(cgram, cgram.length - 8, cgram.length);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("MAC computation failed", e);
        }
    }

    public static byte[] mac_des_3des(byte[] key, byte[] data, byte[] iv) {
        try {
            byte[] d = GPCrypto.pad80(data, 8);
            if (d.length > 8) {
                byte[] des = GPCrypto.des_cbc(Arrays.copyOf(d, d.length - 8), key, iv);
                iv = Arrays.copyOfRange(des, des.length - 8, des.length);
            }
            byte[] cgram = GPCrypto.des3_cbc(Arrays.copyOfRange(d, d.length - 8, d.length), key, iv);
            return Arrays.copyOfRange(cgram, cgram.length - 8, cgram.length);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("MAC computation failed", e);
        }
    }

    public static byte[] aes_cmac(byte[] key, byte[] data, int lengthBits) {
        MultiBlockCipher cipher = AESEngine.newInstance();
        CMac cmac = new CMac(cipher);
        cmac.init(new KeyParameter(key));
        cmac.update(data, 0, data.length);
        byte[] out = new byte[cmac.getMacSize()];
        cmac.doFinal(out, 0);
        return Arrays.copyOf(out, lengthBits / 8);
    }

    public static byte[] aes_cmac(SecretKey key, byte[] data, int lengthBits) throws GeneralSecurityException {
        Mac mac = Mac.getInstance("AESCMAC");
        mac.init(key);
        mac.update(data);
        return Arrays.copyOf(mac.doFinal(), lengthBits / 8);
    }

    public static byte[] scp03_kdf_blocka(byte constant, int blocklen_bits) {
        byte[] label = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(label);
            bo.write(constant);
            bo.write(0);
            bo.write(blocklen_bits >> 8 & 0xFF);
            bo.write(blocklen_bits & 0xFF);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return bo.toByteArray();
    }

    public static byte[] scp03_kdf(byte[] key, byte constant, byte[] context, int blocklen_bits) {
        byte[] blocka = GPCrypto.scp03_kdf_blocka(constant, blocklen_bits);
        byte[] blockb = context;
        return GPCrypto.scp03_kdf(key, blocka, blockb, blocklen_bits / 8);
    }

    public static byte[] scp03_kdf(byte[] key, byte[] a, byte[] b, int bytes) {
        MultiBlockCipher cipher = AESEngine.newInstance();
        CMac cmac = new CMac(cipher);
        KDFCounterBytesGenerator kdf = new KDFCounterBytesGenerator(cmac);
        kdf.init(new KDFCounterParameters(key, a, b, 8));
        byte[] cgram = new byte[bytes];
        kdf.generateBytes(cgram, 0, cgram.length);
        return cgram;
    }

    public static byte[] kcv_aes(byte[] key) {
        try {
            return Arrays.copyOfRange(GPCrypto.aes_cbc(one_bytes_16, key, new byte[16]), 0, 3);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not calculate KCV", e);
        }
    }

    public static byte[] kcv_aes0(byte[] key) {
        try {
            return Arrays.copyOfRange(GPCrypto.aes_cbc(new byte[16], key, new byte[16]), 0, 3);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not calculate KCV", e);
        }
    }

    public static byte[] kcv_3des(byte[] key) {
        try {
            return Arrays.copyOf(GPCrypto.des3_ecb(new byte[8], key), 3);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not calculate KCV", e);
        }
    }

    public static Key des3key(byte[] v) {
        return new SecretKeySpec(GPCrypto.resize_des(v, 24), "DESede");
    }

    public static Key aeskey(byte[] v) {
        return new SecretKeySpec(v, "AES");
    }

    public static byte[] rsa_sign(RSAPrivateKey key, byte[] dtbs) throws GeneralSecurityException {
        int keylen = (key.getModulus().bitLength() + 7) / 8;
        if (keylen == 128) {
            return GPCrypto.rsa_scheme1(key, dtbs);
        }
        return GPCrypto.rsa_scheme2(key, dtbs);
    }

    public static byte[] rsa_scheme2(RSAPrivateKey key, byte[] dtbs) throws GeneralSecurityException {
        MGF1ParameterSpec mgf = MGF1ParameterSpec.SHA256;
        PSSParameterSpec spec = new PSSParameterSpec(mgf.getDigestAlgorithm(), "MGF1", mgf, 32, 1);
        Signature signer = Signature.getInstance("RSASSA-PSS");
        signer.setParameter(spec);
        signer.initSign(key);
        signer.update(dtbs);
        return signer.sign();
    }

    public static byte[] rsa_scheme1(RSAPrivateKey key, byte[] dtbs) throws GeneralSecurityException {
        Signature signer = Signature.getInstance("SHA1withRSA");
        signer.initSign(key);
        signer.update(dtbs);
        return signer.sign();
    }

    public static PublicKey pem2PublicKey(InputStream in) throws IOException {
        try (PEMParser pem = new PEMParser(new InputStreamReader(in, StandardCharsets.US_ASCII));){
            Object ohh = pem.readObject();
            if (ohh instanceof PEMKeyPair) {
                PEMKeyPair kp = (PEMKeyPair)ohh;
                PublicKey publicKey = new JcaPEMKeyConverter().getKeyPair(kp).getPublic();
                return publicKey;
            }
            if (ohh instanceof SubjectPublicKeyInfo) {
                SubjectPublicKeyInfo spki = (SubjectPublicKeyInfo)ohh;
                PublicKey publicKey = new JcaPEMKeyConverter().getPublicKey(spki);
                return publicKey;
            }
            if (ohh instanceof X509CertificateHolder) {
                X509CertificateHolder certHolder = (X509CertificateHolder)ohh;
                try {
                    PublicKey publicKey = new JcaX509CertificateConverter().getCertificate(certHolder).getPublicKey();
                    return publicKey;
                }
                catch (CertificateException ce) {
                    throw new IllegalArgumentException("Can not read PEM: " + ce.getMessage());
                }
            }
            throw new IllegalArgumentException("Can not read PEM");
        }
    }

    public static PrivateKey pem2PrivateKey(InputStream in) throws IOException {
        try (PEMParser pem = new PEMParser(new InputStreamReader(in, StandardCharsets.US_ASCII));){
            Object ohh = pem.readObject();
            if (ohh instanceof PEMKeyPair) {
                PEMKeyPair kp = (PEMKeyPair)ohh;
                PrivateKey privateKey = new JcaPEMKeyConverter().getKeyPair(kp).getPrivate();
                return privateKey;
            }
            if (ohh instanceof PrivateKeyInfo) {
                PrivateKeyInfo pki = (PrivateKeyInfo)ohh;
                PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(pki);
                return privateKey;
            }
            throw new IllegalArgumentException("Can not read PEM");
        }
    }

    static byte[] resize_des(byte[] key, int length) {
        switch (length) {
            case 24: {
                return GPUtils.concatenate(Arrays.copyOf(key, 16), Arrays.copyOf(key, 8));
            }
            case 8: {
                return Arrays.copyOf(key, 8);
            }
        }
        throw new IllegalArgumentException("Invalid DES key length: " + length);
    }

    public static byte[] der2rs(byte[] der, int len) throws SignatureException {
        byte[] byArray;
        ASN1InputStream input = new ASN1InputStream(der);
        try {
            DLSequence seq = (DLSequence)input.readObject();
            ASN1Integer r = (ASN1Integer)seq.getObjectAt(0);
            ASN1Integer s = (ASN1Integer)seq.getObjectAt(1);
            byArray = GPUtils.concatenate(GPCrypto.leftpad(r.getPositiveValue().toByteArray(), len), GPCrypto.leftpad(s.getPositiveValue().toByteArray(), len));
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SignatureException("Could not convert DER to R||S: " + e.getMessage());
            }
        }
        input.close();
        return byArray;
    }

    public static byte[] leftpad(byte[] bytes, int len) {
        if (bytes.length < len) {
            byte[] nv = new byte[len];
            System.arraycopy(bytes, 0, nv, len - bytes.length, bytes.length);
            return nv;
        }
        if (bytes.length > len) {
            byte[] nv = new byte[len];
            System.arraycopy(bytes, bytes.length - len, nv, 0, len);
            return nv;
        }
        return bytes;
    }

    static {
        try {
            rnd = SecureRandom.getInstance("SHA1PRNG");
            rnd.nextBytes(new byte[2]);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Need SecureRandom to run");
        }
    }
}

