/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gptool;

import apdu4j.core.HexUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Optional;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import pro.javacard.gp.GPCrypto;

public final class Key {
    java.security.Key symmetricKey;
    PublicKey publicKey;
    PrivateKey privateKey;
    String s;

    private Key(String s, java.security.Key sym, PublicKey publicKey, PrivateKey privateKey) {
        this.symmetricKey = sym;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.s = s;
    }

    public Optional<java.security.Key> getSymmetric() {
        return Optional.ofNullable(this.symmetricKey);
    }

    public Optional<PublicKey> getPublic() {
        return Optional.ofNullable(this.publicKey);
    }

    public Optional<PrivateKey> getPrivate() {
        return Optional.ofNullable(this.privateKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Key valueOf(String v) {
        Path p = Paths.get(v, new String[0]);
        if (Files.isReadable(p)) {
            try (InputStream inputStream = Files.newInputStream(p, new OpenOption[0]);
                 PEMParser pem = new PEMParser(new InputStreamReader(inputStream, StandardCharsets.US_ASCII));){
                Object ohh = pem.readObject();
                if (ohh instanceof PEMKeyPair) {
                    PEMKeyPair kp = (PEMKeyPair)ohh;
                    KeyPair keyPair = new JcaPEMKeyConverter().getKeyPair(kp);
                    Key key = new Key(v, null, keyPair.getPublic(), keyPair.getPrivate());
                    return key;
                }
                if (ohh instanceof SubjectPublicKeyInfo) {
                    SubjectPublicKeyInfo spki = (SubjectPublicKeyInfo)ohh;
                    Key keyPair = new Key(v, null, new JcaPEMKeyConverter().getPublicKey(spki), null);
                    return keyPair;
                }
                if (ohh instanceof X509CertificateHolder) {
                    X509CertificateHolder certHolder = (X509CertificateHolder)ohh;
                    try {
                        Key keyPair = new Key(v, null, new JcaX509CertificateConverter().getCertificate(certHolder).getPublicKey(), null);
                        return keyPair;
                    }
                    catch (CertificateException ce) {
                        throw new IllegalArgumentException("Can not read certificate from PEM: " + ce.getMessage());
                    }
                }
                if (!(ohh instanceof PrivateKeyInfo)) throw new IllegalArgumentException("Can not read PEM");
                PrivateKeyInfo pki = (PrivateKeyInfo)ohh;
                PrivateKey pk = new JcaPEMKeyConverter().getPrivateKey(pki);
                if (pk instanceof RSAPrivateKey) {
                    RSAPrivateKey rsaKey = (RSAPrivateKey)((Object)pk);
                    BigInteger modulus = rsaKey.getModulus();
                    BigInteger exponent = rsaKey.getPublicExponent();
                    PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, exponent));
                    Key key = new Key(v, null, publicKey, pk);
                    return key;
                }
                if (pk instanceof RSAPrivateCrtKey) {
                    RSAPrivateCrtKey rsaCrtKey = (RSAPrivateCrtKey)pk;
                    BigInteger modulus = rsaCrtKey.getModulus();
                    BigInteger exponent = rsaCrtKey.getPublicExponent();
                    PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, exponent));
                    Key key = new Key(v, null, publicKey, pk);
                    return key;
                }
                Key key = new Key(v, null, null, pk);
                return key;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalArgumentException("Could not read PEM: " + e.getMessage(), e);
            }
        }
        if (v.startsWith("aes:")) {
            byte[] bv = HexUtils.hex2bin(v.substring(4));
            if (bv.length == 16) return new Key(v, GPCrypto.aeskey(bv), null, null);
            if (bv.length == 24) return new Key(v, GPCrypto.aeskey(bv), null, null);
            if (bv.length != 32) throw new IllegalArgumentException("Invalid key length: " + bv.length);
            return new Key(v, GPCrypto.aeskey(bv), null, null);
        }
        if (v.startsWith("3des:")) {
            byte[] bv = HexUtils.hex2bin(v.substring(5));
            if (bv.length != 16) throw new IllegalArgumentException("Invalid key length: " + bv.length);
            return new Key(v, GPCrypto.des3key(bv), null, null);
        }
        byte[] k = HexUtils.hex2bin(v);
        if (k.length == 24) return new Key(v, GPCrypto.aeskey(k), null, null);
        if (k.length == 32) {
            return new Key(v, GPCrypto.aeskey(k), null, null);
        }
        if (k.length != 16) throw new IllegalArgumentException("Invalid key length: " + k.length);
        return new Key(v, GPCrypto.des3key(k), null, null);
    }

    public String toString() {
        return this.s;
    }
}

