/* action.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from action.vala, do not modify */

/*
 * Copyright (c) 2016 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "actions.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ACTIONS_ACTION_0_PROPERTY,
	ACTIONS_ACTION_NAME_PROPERTY,
	ACTIONS_ACTION_COMMAND_PROPERTY,
	ACTIONS_ACTION_PATH_PROPERTY,
	ACTIONS_ACTION_STATES_PROPERTY,
	ACTIONS_ACTION_TRIGGERS_PROPERTY,
	ACTIONS_ACTION_COMMAND_VALID_PROPERTY,
	ACTIONS_ACTION_NUM_PROPERTIES
};
static GParamSpec* actions_action_properties[ACTIONS_ACTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ActionsActionPrivate {
	gchar* _name;
	ActionsState _states;
	ActionsTrigger _triggers;
	gboolean _command_valid;
	gchar* _command;
	GSettings* settings;
	GSimpleAction* remove_action;
};

static gint ActionsAction_private_offset;
static gpointer actions_action_parent_class = NULL;
static GType actions_action_type_id = 0;

static void actions_action_activate_remove (ActionsAction* self,
                                     GSimpleAction* action,
                                     GVariant* parameter);
static void _actions_action_activate_remove_g_simple_action_activate (GSimpleAction* _sender,
                                                               GVariant* parameter,
                                                               gpointer self);
static void actions_action_validate_command (ActionsAction* self);
static void actions_action_set_command_valid (ActionsAction* self,
                                       gboolean value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void actions_action_finalize (GObject * obj);
static void _vala_actions_action_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_actions_action_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
actions_action_get_instance_private (ActionsAction* self)
{
	return G_STRUCT_MEMBER_P (self, ActionsAction_private_offset);
}

ActionsAction*
actions_action_construct_for_path (GType object_type,
                                   const gchar* path)
{
	ActionsAction * self = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	self = (ActionsAction*) g_object_new (object_type, NULL);
	actions_action_set_path (self, path);
	return self;
}

ActionsAction*
actions_action_new_for_path (const gchar* path)
{
	return actions_action_construct_for_path (ACTIONS_TYPE_ACTION, path);
}

/**
         * Reset action to defaults
         */
void
actions_action_reset (ActionsAction* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	_tmp1_ = self->priv->settings;
	g_settings_reset (_tmp1_, "name");
	_tmp2_ = self->priv->settings;
	g_settings_reset (_tmp2_, "command");
	_tmp3_ = self->priv->settings;
	g_settings_reset (_tmp3_, "states");
	_tmp4_ = self->priv->settings;
	g_settings_reset (_tmp4_, "triggers");
	_tmp5_ = self->priv->settings;
	g_settings_apply (_tmp5_);
}

static void
_actions_action_activate_remove_g_simple_action_activate (GSimpleAction* _sender,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	actions_action_activate_remove ((ActionsAction*) self, _sender, parameter);
}

GActionGroup*
actions_action_get_action_group (ActionsAction* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GActionGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	_tmp1_ = g_simple_action_new ("remove", NULL);
	_g_object_unref0 (self->priv->remove_action);
	self->priv->remove_action = _tmp1_;
	_tmp2_ = self->priv->remove_action;
	g_signal_connect_object (_tmp2_, "activate", (GCallback) _actions_action_activate_remove_g_simple_action_activate, self, 0);
	_tmp3_ = self->priv->remove_action;
	g_action_map_add_action ((GActionMap*) action_group, (GAction*) _tmp3_);
	result = (GActionGroup*) action_group;
	return result;
}

static void
actions_action_activate_remove (ActionsAction* self,
                                GSimpleAction* action,
                                GVariant* parameter)
{
	ActionsActionManager* action_manager = NULL;
	ActionsActionManager* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = actions_action_manager_get_instance ();
	action_manager = _tmp0_;
	actions_action_manager_remove (action_manager, self);
	_g_object_unref0 (action_manager);
}

static void
actions_action_validate_command (ActionsAction* self)
{
	gchar** spawn_args = NULL;
	gint spawn_args_length1 = 0;
	gint _spawn_args_size_ = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar** _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gboolean _tmp5_;
		_tmp1_ = actions_action_get_command (self);
		_tmp2_ = _tmp1_;
		_tmp5_ = g_shell_parse_argv (_tmp2_, &_tmp4_, &_tmp3_, &_inner_error0_);
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
		spawn_args = _tmp3_;
		spawn_args_length1 = _tmp4_;
		_spawn_args_size_ = spawn_args_length1;
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SHELL_ERROR) {
				goto __catch0_g_shell_error;
			}
			spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		actions_action_set_command_valid (self, _tmp0_);
	}
	goto __finally0;
	__catch0_g_shell_error:
	{
		g_clear_error (&_inner_error0_);
		actions_action_set_command_valid (self, FALSE);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gboolean
actions_action_execute (ActionsAction* self,
                        ActionsContext* context)
{
	gchar** spawn_env = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint spawn_env_length1;
	gint _spawn_env_size_;
	gchar** spawn_args = NULL;
	gint spawn_args_length1 = 0;
	gint _spawn_args_size_ = 0;
	gchar** trigger_strings = NULL;
	gchar** _tmp2_;
	gint trigger_strings_length1;
	gint _trigger_strings_size_;
	ActionsContext _tmp3_;
	GList* _tmp4_;
	gchar* command = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	ActionsContext _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	ActionsContext _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	ActionsContext _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp1_ = _tmp0_ = g_get_environ ();
	spawn_env = _tmp1_;
	spawn_env_length1 = _vala_array_length (_tmp0_);
	_spawn_env_size_ = spawn_env_length1;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	trigger_strings = _tmp2_;
	trigger_strings_length1 = 0;
	_trigger_strings_size_ = trigger_strings_length1;
	_tmp3_ = *context;
	_tmp4_ = actions_trigger_to_list (_tmp3_.triggers);
	{
		GList* trigger_collection = NULL;
		GList* trigger_it = NULL;
		trigger_collection = _tmp4_;
		for (trigger_it = trigger_collection; trigger_it != NULL; trigger_it = trigger_it->next) {
			ActionsTrigger trigger = 0U;
			trigger = (ActionsTrigger) ((gintptr) trigger_it->data);
			{
				gchar* _tmp5_;
				_tmp5_ = actions_trigger_to_string (trigger);
				_vala_array_add2 (&trigger_strings, &trigger_strings_length1, &_trigger_strings_size_, _tmp5_);
			}
		}
		(trigger_collection == NULL) ? NULL : (trigger_collection = (g_list_free (trigger_collection), NULL));
	}
	_tmp6_ = actions_action_get_command (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup (_tmp7_);
	command = _tmp8_;
	_tmp9_ = command;
	_tmp10_ = *context;
	_tmp11_ = actions_state_to_string (_tmp10_.state);
	_tmp12_ = _tmp11_;
	_tmp13_ = string_replace (_tmp9_, "$(state)", _tmp12_);
	_g_free0 (command);
	command = _tmp13_;
	_g_free0 (_tmp12_);
	_tmp14_ = command;
	_tmp15_ = *context;
	_tmp16_ = double_to_string (_tmp15_.elapsed);
	_tmp17_ = _tmp16_;
	_tmp18_ = string_replace (_tmp14_, "$(elapsed)", _tmp17_);
	_g_free0 (command);
	command = _tmp18_;
	_g_free0 (_tmp17_);
	_tmp19_ = command;
	_tmp20_ = *context;
	_tmp21_ = double_to_string (_tmp20_.duration);
	_tmp22_ = _tmp21_;
	_tmp23_ = string_replace (_tmp19_, "$(duration)", _tmp22_);
	_g_free0 (command);
	command = _tmp23_;
	_g_free0 (_tmp22_);
	_tmp24_ = command;
	_tmp25_ = trigger_strings;
	_tmp25__length1 = trigger_strings_length1;
	_tmp26_ = _vala_g_strjoinv (" ", _tmp25_, (gint) _tmp25__length1);
	_tmp27_ = _tmp26_;
	_tmp28_ = string_replace (_tmp24_, "$(triggers)", _tmp27_);
	_g_free0 (command);
	command = _tmp28_;
	_g_free0 (_tmp27_);
	{
		const gchar* _tmp29_;
		gchar** _tmp30_ = NULL;
		gint _tmp31_ = 0;
		_tmp29_ = command;
		g_shell_parse_argv (_tmp29_, &_tmp31_, &_tmp30_, &_inner_error0_);
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
		spawn_args = _tmp30_;
		spawn_args_length1 = _tmp31_;
		_spawn_args_size_ = spawn_args_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp32_ = FALSE;
			if (_inner_error0_->domain == G_SHELL_ERROR) {
				goto __catch0_g_shell_error;
			}
			_g_free0 (command);
			trigger_strings = (_vala_array_free (trigger_strings, trigger_strings_length1, (GDestroyNotify) g_free), NULL);
			spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
			spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp32_;
		}
	}
	goto __finally0;
	__catch0_g_shell_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp33_;
		GError* _tmp34_;
		const gchar* _tmp35_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp33_ = command;
		_tmp34_ = _error_;
		_tmp35_ = _tmp34_->message;
		g_debug ("action.vala:151: Error while executing command \"%s\": %s", _tmp33_, _tmp35_);
		result = FALSE;
		_g_error_free0 (_error_);
		_g_free0 (command);
		trigger_strings = (_vala_array_free (trigger_strings, trigger_strings_length1, (GDestroyNotify) g_free), NULL);
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
		spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp36_ = FALSE;
		_g_free0 (command);
		trigger_strings = (_vala_array_free (trigger_strings, trigger_strings_length1, (GDestroyNotify) g_free), NULL);
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
		spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp36_;
	}
	{
		gchar** _tmp37_;
		gint _tmp37__length1;
		gchar** _tmp38_;
		gint _tmp38__length1;
		_tmp37_ = spawn_args;
		_tmp37__length1 = spawn_args_length1;
		_tmp38_ = spawn_env;
		_tmp38__length1 = spawn_env_length1;
		g_spawn_sync ("/", _tmp37_, _tmp38_, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp39_ = FALSE;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			_g_free0 (command);
			trigger_strings = (_vala_array_free (trigger_strings, trigger_strings_length1, (GDestroyNotify) g_free), NULL);
			spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
			spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp39_;
		}
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* _error_ = NULL;
		FILE* _tmp40_;
		GError* _tmp41_;
		const gchar* _tmp42_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp40_ = stdout;
		_tmp41_ = _error_;
		_tmp42_ = _tmp41_->message;
		fprintf (_tmp40_, "Error: %s\n", _tmp42_);
		result = FALSE;
		_g_error_free0 (_error_);
		_g_free0 (command);
		trigger_strings = (_vala_array_free (trigger_strings, trigger_strings_length1, (GDestroyNotify) g_free), NULL);
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
		spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp43_ = FALSE;
		_g_free0 (command);
		trigger_strings = (_vala_array_free (trigger_strings, trigger_strings_length1, (GDestroyNotify) g_free), NULL);
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
		spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp43_;
	}
	result = TRUE;
	_g_free0 (command);
	trigger_strings = (_vala_array_free (trigger_strings, trigger_strings_length1, (GDestroyNotify) g_free), NULL);
	spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
	spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

ActionsAction*
actions_action_construct (GType object_type)
{
	ActionsAction * self = NULL;
	self = (ActionsAction*) g_object_new (object_type, NULL);
	return self;
}

ActionsAction*
actions_action_new (void)
{
	return actions_action_construct (ACTIONS_TYPE_ACTION);
}

const gchar*
actions_action_get_name (ActionsAction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
actions_action_set_name (ActionsAction* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = actions_action_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, actions_action_properties[ACTIONS_ACTION_NAME_PROPERTY]);
	}
}

const gchar*
actions_action_get_command (ActionsAction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_command;
	result = _tmp0_;
	return result;
}

void
actions_action_set_command (ActionsAction* self,
                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_command);
	self->priv->_command = _tmp0_;
	actions_action_validate_command (self);
	g_object_notify_by_pspec ((GObject *) self, actions_action_properties[ACTIONS_ACTION_COMMAND_PROPERTY]);
}

gchar*
actions_action_get_path (ActionsAction* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	GSettings* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->settings;
	if (_tmp1_ != NULL) {
		GSettings* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->settings;
		g_object_get (_tmp2_, "path", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

void
actions_action_set_path (ActionsAction* self,
                         const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		GSettings* _tmp0_;
		GSettings* _tmp1_;
		GSettings* _tmp2_;
		GSettings* _tmp3_;
		GSettings* _tmp4_;
		_tmp0_ = g_settings_new_with_path ("org.gnome.pomodoro.plugins.actions.action", value);
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = _tmp0_;
		_tmp1_ = self->priv->settings;
		g_settings_bind (_tmp1_, "name", (GObject*) self, "name", G_SETTINGS_BIND_DEFAULT);
		_tmp2_ = self->priv->settings;
		g_settings_bind (_tmp2_, "command", (GObject*) self, "command", G_SETTINGS_BIND_DEFAULT);
		_tmp3_ = self->priv->settings;
		g_settings_bind (_tmp3_, "states", (GObject*) self, "states", G_SETTINGS_BIND_DEFAULT);
		_tmp4_ = self->priv->settings;
		g_settings_bind (_tmp4_, "triggers", (GObject*) self, "triggers", G_SETTINGS_BIND_DEFAULT);
	} else {
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = NULL;
	}
	g_object_notify_by_pspec ((GObject *) self, actions_action_properties[ACTIONS_ACTION_PATH_PROPERTY]);
}

ActionsState
actions_action_get_states (ActionsAction* self)
{
	ActionsState result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_states;
	return result;
}

void
actions_action_set_states (ActionsAction* self,
                           ActionsState value)
{
	ActionsState old_value;
	g_return_if_fail (self != NULL);
	old_value = actions_action_get_states (self);
	if (old_value != value) {
		self->priv->_states = value;
		g_object_notify_by_pspec ((GObject *) self, actions_action_properties[ACTIONS_ACTION_STATES_PROPERTY]);
	}
}

ActionsTrigger
actions_action_get_triggers (ActionsAction* self)
{
	ActionsTrigger result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_triggers;
	return result;
}

void
actions_action_set_triggers (ActionsAction* self,
                             ActionsTrigger value)
{
	ActionsTrigger old_value;
	g_return_if_fail (self != NULL);
	old_value = actions_action_get_triggers (self);
	if (old_value != value) {
		self->priv->_triggers = value;
		g_object_notify_by_pspec ((GObject *) self, actions_action_properties[ACTIONS_ACTION_TRIGGERS_PROPERTY]);
	}
}

gboolean
actions_action_get_command_valid (ActionsAction* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_command_valid;
	return result;
}

static void
actions_action_set_command_valid (ActionsAction* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = actions_action_get_command_valid (self);
	if (old_value != value) {
		self->priv->_command_valid = value;
		g_object_notify_by_pspec ((GObject *) self, actions_action_properties[ACTIONS_ACTION_COMMAND_VALID_PROPERTY]);
	}
}

static void
actions_action_class_init (ActionsActionClass * klass,
                           gpointer klass_data)
{
	actions_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ActionsAction_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_actions_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_actions_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = actions_action_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACTIONS_ACTION_NAME_PROPERTY, actions_action_properties[ACTIONS_ACTION_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACTIONS_ACTION_COMMAND_PROPERTY, actions_action_properties[ACTIONS_ACTION_COMMAND_PROPERTY] = g_param_spec_string ("command", "command", "command", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACTIONS_ACTION_PATH_PROPERTY, actions_action_properties[ACTIONS_ACTION_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACTIONS_ACTION_STATES_PROPERTY, actions_action_properties[ACTIONS_ACTION_STATES_PROPERTY] = g_param_spec_flags ("states", "states", "states", ACTIONS_TYPE_STATE, ACTIONS_STATE_ANY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACTIONS_ACTION_TRIGGERS_PROPERTY, actions_action_properties[ACTIONS_ACTION_TRIGGERS_PROPERTY] = g_param_spec_flags ("triggers", "triggers", "triggers", ACTIONS_TYPE_TRIGGER, ACTIONS_TRIGGER_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACTIONS_ACTION_COMMAND_VALID_PROPERTY, actions_action_properties[ACTIONS_ACTION_COMMAND_VALID_PROPERTY] = g_param_spec_boolean ("command-valid", "command-valid", "command-valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
actions_action_instance_init (ActionsAction * self,
                              gpointer klass)
{
	self->priv = actions_action_get_instance_private (self);
	self->priv->_states = ACTIONS_STATE_ANY;
	self->priv->_triggers = ACTIONS_TRIGGER_NONE;
	self->priv->_command_valid = FALSE;
}

static void
actions_action_finalize (GObject * obj)
{
	ActionsAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACTIONS_TYPE_ACTION, ActionsAction);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_command);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->remove_action);
	G_OBJECT_CLASS (actions_action_parent_class)->finalize (obj);
}

GType
actions_action_get_type (void)
{
	return actions_action_type_id;
}

GType
actions_action_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ActionsActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) actions_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ActionsAction), 0, (GInstanceInitFunc) actions_action_instance_init, NULL };
	actions_action_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ActionsAction", &g_define_type_info, 0);
	ActionsAction_private_offset = sizeof (ActionsActionPrivate);
	return actions_action_type_id;
}

static void
_vala_actions_action_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	ActionsAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ACTIONS_TYPE_ACTION, ActionsAction);
	switch (property_id) {
		case ACTIONS_ACTION_NAME_PROPERTY:
		g_value_set_string (value, actions_action_get_name (self));
		break;
		case ACTIONS_ACTION_COMMAND_PROPERTY:
		g_value_set_string (value, actions_action_get_command (self));
		break;
		case ACTIONS_ACTION_PATH_PROPERTY:
		g_value_take_string (value, actions_action_get_path (self));
		break;
		case ACTIONS_ACTION_STATES_PROPERTY:
		g_value_set_flags (value, actions_action_get_states (self));
		break;
		case ACTIONS_ACTION_TRIGGERS_PROPERTY:
		g_value_set_flags (value, actions_action_get_triggers (self));
		break;
		case ACTIONS_ACTION_COMMAND_VALID_PROPERTY:
		g_value_set_boolean (value, actions_action_get_command_valid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_actions_action_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	ActionsAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ACTIONS_TYPE_ACTION, ActionsAction);
	switch (property_id) {
		case ACTIONS_ACTION_NAME_PROPERTY:
		actions_action_set_name (self, g_value_get_string (value));
		break;
		case ACTIONS_ACTION_COMMAND_PROPERTY:
		actions_action_set_command (self, g_value_get_string (value));
		break;
		case ACTIONS_ACTION_PATH_PROPERTY:
		actions_action_set_path (self, g_value_get_string (value));
		break;
		case ACTIONS_ACTION_STATES_PROPERTY:
		actions_action_set_states (self, g_value_get_flags (value));
		break;
		case ACTIONS_ACTION_TRIGGERS_PROPERTY:
		actions_action_set_triggers (self, g_value_get_flags (value));
		break;
		case ACTIONS_ACTION_COMMAND_VALID_PROPERTY:
		actions_action_set_command_valid (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

