/* gnome-plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gnome-plugin.vala, do not modify */

/*
 * Copyright (c) 2016 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "gnome.h"
#include "gnome-pomodoro.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <config.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <libpeas.h>

#define GNOME_PLUGIN_IDLE_MONITOR_MIN_IDLE_TIME 0.5
#define GNOME_PLUGIN_CURRENT_DESKTOP_VARIABLE "XDG_CURRENT_DESKTOP"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION (gnome_plugin_gnome_shell_extension_get_type ())
#define GNOME_PLUGIN_GNOME_SHELL_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION, GnomePluginGnomeShellExtension))
#define GNOME_PLUGIN_GNOME_SHELL_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION, GnomePluginGnomeShellExtensionClass))
#define GNOME_PLUGIN_IS_GNOME_SHELL_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION))
#define GNOME_PLUGIN_IS_GNOME_SHELL_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION))
#define GNOME_PLUGIN_GNOME_SHELL_EXTENSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION, GnomePluginGnomeShellExtensionClass))

typedef struct _GnomePluginGnomeShellExtension GnomePluginGnomeShellExtension;
typedef struct _GnomePluginGnomeShellExtensionClass GnomePluginGnomeShellExtensionClass;
enum  {
	GNOME_PLUGIN_APPLICATION_EXTENSION_0_PROPERTY,
	GNOME_PLUGIN_APPLICATION_EXTENSION_NUM_PROPERTIES
};
static GParamSpec* gnome_plugin_application_extension_properties[GNOME_PLUGIN_APPLICATION_EXTENSION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GnomePluginApplicationExtensionEnableExtensionData GnomePluginApplicationExtensionEnableExtensionData;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GnomePluginApplicationExtensionInitShellExtensionData GnomePluginApplicationExtensionInitShellExtensionData;
typedef struct _GnomePluginApplicationExtensionInitAsyncData GnomePluginApplicationExtensionInitAsyncData;
enum  {
	GNOME_PLUGIN_PREFERENCES_DIALOG_EXTENSION_0_PROPERTY,
	GNOME_PLUGIN_PREFERENCES_DIALOG_EXTENSION_NUM_PROPERTIES
};
static GParamSpec* gnome_plugin_preferences_dialog_extension_properties[GNOME_PLUGIN_PREFERENCES_DIALOG_EXTENSION_NUM_PROPERTIES];

struct _GnomePluginApplicationExtensionPrivate {
	PomodoroTimer* timer;
	GSettings* settings;
	PomodoroCapabilityGroup* capabilities;
	GnomePluginGnomeShellExtension* shell_extension;
	gchar* shell_extension_expected_path;
	gchar* shell_extension_expected_version;
	GnomePluginIdleMonitor* idle_monitor;
	guint become_active_id;
	gboolean is_gnome;
	gdouble last_activity_time;
	GnomeShell* shell_proxy;
	GnomeShellExtensions* shell_extensions_proxy;
};

struct _GnomePluginApplicationExtensionEnableExtensionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GnomePluginApplicationExtension* self;
	GCancellable* cancellable;
	gboolean _tmp0_;
	GnomePluginGnomeShellExtension* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GnomePluginGnomeShellExtension* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GnomePluginGnomeShellExtension* _tmp9_;
	GnomePluginGnomeShellExtension* _tmp10_;
	GError* _inner_error0_;
};

struct _GnomePluginApplicationExtensionInitShellExtensionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GnomePluginApplicationExtension* self;
	GCancellable* cancellable;
	gchar* expected_version;
	gchar* _tmp0_;
	gchar* expected_path;
	gchar* _tmp1_;
	gboolean should_enable;
	GnomePluginGnomeShellExtension* _tmp2_;
	GnomeShell* _tmp3_;
	GnomeShellExtensions* _tmp4_;
	GnomePluginGnomeShellExtension* _tmp5_;
	GnomePluginGnomeShellExtension* _tmp6_;
	GError* _error_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GnomePluginGnomeShellExtension* _tmp13_;
	GnomeExtensionState _tmp14_;
	GnomeExtensionState _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GnomePluginGnomeShellExtension* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GnomePluginGnomeShellExtension* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gboolean _tmp24_;
	GnomePluginGnomeShellExtension* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GnomePluginGnomeShellExtension* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GnomePluginGnomeShellExtension* _tmp33_;
	GError* _vala1__error_;
	GError* _tmp34_;
	const gchar* _tmp35_;
	GnomePluginGnomeShellExtension* _tmp36_;
	GnomeExtensionState _tmp37_;
	GnomeExtensionState _tmp38_;
	gboolean _tmp39_;
	GnomePluginGnomeShellExtension* _tmp40_;
	GnomeExtensionState _tmp41_;
	GnomeExtensionState _tmp42_;
	GnomePluginGnomeShellExtension* _tmp43_;
	gboolean _tmp44_;
	GnomePluginGnomeShellExtension* _tmp45_;
	GnomeExtensionState _tmp46_;
	GnomeExtensionState _tmp47_;
	GnomePluginGnomeShellExtension* _tmp48_;
	GError* _inner_error0_;
};

struct _GnomePluginApplicationExtensionInitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GnomePluginApplicationExtension* self;
	gint io_priority;
	GCancellable* cancellable;
	gboolean result;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	PomodoroCapabilityGroup* _tmp3_;
	GnomePluginIdleMonitor* _tmp4_;
	GnomePluginIdleMonitor* _tmp5_;
	GnomePluginIdleMonitor* _tmp6_;
	GnomePluginIdleMonitor* _tmp7_;
	PomodoroTimer* _tmp8_;
	PomodoroTimer* _tmp9_;
	PomodoroTimer* _tmp10_;
	PomodoroCapabilityGroup* _tmp11_;
	PomodoroCapability* _tmp12_;
	PomodoroCapability* _tmp13_;
	PomodoroApplication* application;
	PomodoroApplication* _tmp14_;
	PomodoroApplication* _tmp15_;
	PomodoroApplication* _tmp16_;
	PomodoroCapabilityManager* _tmp17_;
	PomodoroCapabilityGroup* _tmp18_;
	GnomeShell* _tmp19_;
	GnomeShell* _tmp20_;
	GnomeShell* _tmp21_;
	GError* _error_;
	GError* _tmp22_;
	const gchar* _tmp23_;
	GError* _tmp24_;
	GError* _tmp25_;
	GnomeShellExtensions* _tmp26_;
	GnomeShellExtensions* _tmp27_;
	GnomeShellExtensions* _tmp28_;
	GError* _vala1__error_;
	GError* _tmp29_;
	const gchar* _tmp30_;
	GError* _tmp31_;
	GError* _tmp32_;
	GError* _inner_error0_;
};

struct _GnomePluginPreferencesDialogExtensionPrivate {
	PomodoroPreferencesDialog* dialog;
	GSettings* settings;
	GList* rows;
};

static gint GnomePluginApplicationExtension_private_offset;
static gpointer gnome_plugin_application_extension_parent_class = NULL;
static PomodoroApplicationExtensionIface * gnome_plugin_application_extension_pomodoro_application_extension_parent_iface = NULL;
static GAsyncInitableIface * gnome_plugin_application_extension_g_async_initable_parent_iface = NULL;
static GType gnome_plugin_application_extension_type_id = 0;
static gint GnomePluginPreferencesDialogExtension_private_offset;
static gpointer gnome_plugin_preferences_dialog_extension_parent_class = NULL;
static PomodoroPreferencesDialogExtensionIface * gnome_plugin_preferences_dialog_extension_pomodoro_preferences_dialog_extension_parent_iface = NULL;
static GType gnome_plugin_preferences_dialog_extension_type_id = 0;

GType gnome_plugin_gnome_shell_extension_register_type (GTypeModule * module);
VALA_EXTERN GType gnome_plugin_gnome_shell_extension_get_type (void) G_GNUC_CONST ;
static void gnome_plugin_application_extension_on_timer_state_changed (GnomePluginApplicationExtension* self,
                                                                PomodoroTimerState* state,
                                                                PomodoroTimerState* previous_state);
static void _gnome_plugin_application_extension_on_timer_state_changed_pomodoro_timer_state_changed (PomodoroTimer* _sender,
                                                                                              PomodoroTimerState* state,
                                                                                              PomodoroTimerState* previous_state,
                                                                                              gpointer self);
static void gnome_plugin_application_extension_enable_extension_data_free (gpointer _data);
static void gnome_plugin_application_extension_enable_extension (GnomePluginApplicationExtension* self,
                                                          GCancellable* cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void gnome_plugin_application_extension_enable_extension_finish (GnomePluginApplicationExtension* self,
                                                                 GAsyncResult* _res_,
                                                                 GError** error);
static gboolean gnome_plugin_application_extension_enable_extension_co (GnomePluginApplicationExtensionEnableExtensionData* _data_);
VALA_EXTERN const gchar* gnome_plugin_gnome_shell_extension_get_path (GnomePluginGnomeShellExtension* self);
VALA_EXTERN void gnome_plugin_gnome_shell_extension_reload (GnomePluginGnomeShellExtension* self,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN gboolean gnome_plugin_gnome_shell_extension_reload_finish (GnomePluginGnomeShellExtension* self,
                                                           GAsyncResult* _res_,
                                                           GError** error);
static void gnome_plugin_application_extension_enable_extension_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
VALA_EXTERN void gnome_plugin_gnome_shell_extension_enable (GnomePluginGnomeShellExtension* self,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN gboolean gnome_plugin_gnome_shell_extension_enable_finish (GnomePluginGnomeShellExtension* self,
                                                           GAsyncResult* _res_);
static gchar* gnome_plugin_application_extension_get_extension_version (GnomePluginApplicationExtension* self,
                                                                 const gchar* extension_path);
static void gnome_plugin_application_extension_init_shell_extension_data_free (gpointer _data);
static gboolean gnome_plugin_application_extension_init_shell_extension_co (GnomePluginApplicationExtensionInitShellExtensionData* _data_);
VALA_EXTERN GnomePluginGnomeShellExtension* gnome_plugin_gnome_shell_extension_new (GnomeShell* shell_proxy,
                                                                        GnomeShellExtensions* shell_extensions_proxy,
                                                                        const gchar* uuid);
VALA_EXTERN GnomePluginGnomeShellExtension* gnome_plugin_gnome_shell_extension_construct (GType object_type,
                                                                              GnomeShell* shell_proxy,
                                                                              GnomeShellExtensions* shell_extensions_proxy,
                                                                              const gchar* uuid);
VALA_EXTERN void gnome_plugin_gnome_shell_extension_init_async (GnomePluginGnomeShellExtension* self,
                                                    gint io_priority,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN gboolean gnome_plugin_gnome_shell_extension_init_finish (GnomePluginGnomeShellExtension* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static void gnome_plugin_application_extension_init_shell_extension_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_);
VALA_EXTERN GnomeExtensionState gnome_plugin_gnome_shell_extension_get_state (GnomePluginGnomeShellExtension* self);
VALA_EXTERN const gchar* gnome_plugin_gnome_shell_extension_get_version (GnomePluginGnomeShellExtension* self);
VALA_EXTERN void gnome_plugin_gnome_shell_extension_disable (GnomePluginGnomeShellExtension* self,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN gboolean gnome_plugin_gnome_shell_extension_disable_finish (GnomePluginGnomeShellExtension* self,
                                                            GAsyncResult* _res_);
static void gnome_plugin_application_extension_real_init_async_data_free (gpointer _data);
static void gnome_plugin_application_extension_real_init_async (GAsyncInitable* base,
                                                         gint io_priority,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static gboolean gnome_plugin_application_extension_real_init_async_co (GnomePluginApplicationExtensionInitAsyncData* _data_);
static void gnome_plugin_application_extension_init_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void gnome_plugin_application_extension_on_become_active (GnomePluginApplicationExtension* self,
                                                          GnomePluginIdleMonitor* monitor,
                                                          guint id);
static void _gnome_plugin_application_extension_on_become_active_gnome_plugin_idle_monitor_watch_func (GnomePluginIdleMonitor* monitor,
                                                                                                guint id,
                                                                                                gpointer self);
static void gnome_plugin_application_extension_finalize (GObject * obj);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void gnome_plugin_preferences_dialog_extension_setup_main_page (GnomePluginPreferencesDialogExtension* self);
static GtkListBoxRow* gnome_plugin_preferences_dialog_extension_create_row (GnomePluginPreferencesDialogExtension* self,
                                                                     const gchar* label,
                                                                     GtkWidget* widget);
static GObject * gnome_plugin_preferences_dialog_extension_constructor (GType type,
                                                                 guint n_construct_properties,
                                                                 GObjectConstructParam * construct_properties);
static void gnome_plugin_preferences_dialog_extension_finalize (GObject * obj);
GType gnome_shell_register_type (GTypeModule * module);
VALA_EXTERN void gnome_shell_proxy_register_dynamic_type (GTypeModule* module);
GType gnome_shell_extensions_register_type (GTypeModule * module);
VALA_EXTERN void gnome_shell_extensions_proxy_register_dynamic_type (GTypeModule* module);
GType meta_idle_monitor_register_type (GTypeModule * module);
VALA_EXTERN void meta_idle_monitor_proxy_register_dynamic_type (GTypeModule* module);
GType gnome_plugin_idle_monitor_watch_register_type (GTypeModule * module);
GType gnome_plugin_idle_monitor_register_type (GTypeModule * module);
GType gnome_plugin_gnome_shell_extension_register_type (GTypeModule * module);

static inline gpointer
gnome_plugin_application_extension_get_instance_private (GnomePluginApplicationExtension* self)
{
	return G_STRUCT_MEMBER_P (self, GnomePluginApplicationExtension_private_offset);
}

static void
_gnome_plugin_application_extension_on_timer_state_changed_pomodoro_timer_state_changed (PomodoroTimer* _sender,
                                                                                         PomodoroTimerState* state,
                                                                                         PomodoroTimerState* previous_state,
                                                                                         gpointer self)
{
	gnome_plugin_application_extension_on_timer_state_changed ((GnomePluginApplicationExtension*) self, state, previous_state);
}

static void
gnome_plugin_application_extension_enable_extension_data_free (gpointer _data)
{
	GnomePluginApplicationExtensionEnableExtensionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GnomePluginApplicationExtensionEnableExtensionData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gnome_plugin_application_extension_enable_extension (GnomePluginApplicationExtension* self,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	GnomePluginApplicationExtensionEnableExtensionData* _data_;
	GnomePluginApplicationExtension* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GnomePluginApplicationExtensionEnableExtensionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gnome_plugin_application_extension_enable_extension_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	gnome_plugin_application_extension_enable_extension_co (_data_);
}

static void
gnome_plugin_application_extension_enable_extension_finish (GnomePluginApplicationExtension* self,
                                                            GAsyncResult* _res_,
                                                            GError** error)
{
	GnomePluginApplicationExtensionEnableExtensionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
         * Method for enabling extension after install
         */
static void
gnome_plugin_application_extension_enable_extension_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	GnomePluginApplicationExtensionEnableExtensionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gnome_plugin_application_extension_enable_extension_co (_data_);
}

static gboolean
gnome_plugin_application_extension_enable_extension_co (GnomePluginApplicationExtensionEnableExtensionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->shell_extension;
	_data_->_tmp2_ = gnome_plugin_gnome_shell_extension_get_path (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->self->priv->shell_extension_expected_path;
	if (g_strcmp0 (_data_->_tmp3_, _data_->_tmp4_) != 0) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp5_ = _data_->self->priv->shell_extension;
		_data_->_tmp6_ = gnome_plugin_gnome_shell_extension_get_path (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = _data_->self->priv->shell_extension_expected_version;
		_data_->_tmp0_ = g_strcmp0 (_data_->_tmp7_, _data_->_tmp8_) != 0;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp9_ = _data_->self->priv->shell_extension;
		_data_->_state_ = 1;
		gnome_plugin_gnome_shell_extension_reload (_data_->_tmp9_, NULL, gnome_plugin_application_extension_enable_extension_ready, _data_);
		return FALSE;
		_state_1:
		gnome_plugin_gnome_shell_extension_reload_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp10_ = _data_->self->priv->shell_extension;
	_data_->_state_ = 2;
	gnome_plugin_gnome_shell_extension_enable (_data_->_tmp10_, NULL, gnome_plugin_application_extension_enable_extension_ready, _data_);
	return FALSE;
	_state_2:
	gnome_plugin_gnome_shell_extension_enable_finish (_data_->_tmp10_, _data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
         * Read extension version from metadata.json
         */
static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gchar*
gnome_plugin_application_extension_get_extension_version (GnomePluginApplicationExtension* self,
                                                          const gchar* extension_path)
{
	gchar* metadata_path = NULL;
	gchar* _tmp0_;
	JsonParser* parser = NULL;
	JsonParser* _tmp1_;
	gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (extension_path != NULL, NULL);
	_tmp0_ = g_build_filename (extension_path, "metadata.json", NULL);
	metadata_path = _tmp0_;
	_tmp1_ = json_parser_new ();
	parser = _tmp1_;
	{
		JsonParser* _tmp2_;
		const gchar* _tmp3_;
		JsonObject* data = NULL;
		JsonParser* _tmp4_;
		JsonNode* _tmp5_;
		JsonObject* _tmp6_;
		JsonObject* _tmp7_;
		_tmp2_ = parser;
		_tmp3_ = metadata_path;
		json_parser_load_from_file (_tmp2_, _tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
				goto __catch0_g_file_error_noent;
			}
			goto __catch0_g_error;
		}
		_tmp4_ = parser;
		_tmp5_ = json_parser_get_root (_tmp4_);
		_tmp6_ = json_node_get_object (_tmp5_);
		_tmp7_ = _json_object_ref0 (_tmp6_);
		data = _tmp7_;
		if (data != NULL) {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = json_object_get_string_member_with_default (data, "version", "");
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			_json_object_unref0 (data);
			_g_object_unref0 (parser);
			_g_free0 (metadata_path);
			return result;
		}
		_json_object_unref0 (data);
	}
	goto __finally0;
	__catch0_g_file_error_noent:
	{
		g_clear_error (&_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_warning ("gnome-plugin.vala:83: Error while parsing file %s: %s\n", extension_path, _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		_g_free0 (metadata_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp12_ = g_strdup ("");
	result = _tmp12_;
	_g_object_unref0 (parser);
	_g_free0 (metadata_path);
	return result;
}

static void
gnome_plugin_application_extension_init_shell_extension_data_free (gpointer _data)
{
	GnomePluginApplicationExtensionInitShellExtensionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GnomePluginApplicationExtensionInitShellExtensionData, _data_);
}

void
gnome_plugin_application_extension_init_shell_extension (GnomePluginApplicationExtension* self,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GnomePluginApplicationExtensionInitShellExtensionData* _data_;
	GnomePluginApplicationExtension* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GnomePluginApplicationExtensionInitShellExtensionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gnome_plugin_application_extension_init_shell_extension_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	gnome_plugin_application_extension_init_shell_extension_co (_data_);
}

void
gnome_plugin_application_extension_init_shell_extension_finish (GnomePluginApplicationExtension* self,
                                                                GAsyncResult* _res_)
{
	GnomePluginApplicationExtensionInitShellExtensionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static void
gnome_plugin_application_extension_init_shell_extension_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_)
{
	GnomePluginApplicationExtensionInitShellExtensionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gnome_plugin_application_extension_init_shell_extension_co (_data_);
}

static gboolean
gnome_plugin_application_extension_init_shell_extension_co (GnomePluginApplicationExtensionInitShellExtensionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup (PACKAGE_VERSION);
	_data_->expected_version = _data_->_tmp0_;
	_data_->_tmp1_ = g_strdup (EXTENSION_DIR);
	_data_->expected_path = _data_->_tmp1_;
	_data_->should_enable = TRUE;
	_data_->_tmp2_ = _data_->self->priv->shell_extension;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp3_ = _data_->self->priv->shell_proxy;
		_data_->_tmp4_ = _data_->self->priv->shell_extensions_proxy;
		_data_->_tmp5_ = gnome_plugin_gnome_shell_extension_new (_data_->_tmp3_, _data_->_tmp4_, EXTENSION_UUID);
		_g_object_unref0 (_data_->self->priv->shell_extension);
		_data_->self->priv->shell_extension = _data_->_tmp5_;
		{
			_data_->_tmp6_ = _data_->self->priv->shell_extension;
			_data_->_state_ = 1;
			gnome_plugin_gnome_shell_extension_init_async (_data_->_tmp6_, G_PRIORITY_DEFAULT, _data_->cancellable, gnome_plugin_application_extension_init_shell_extension_ready, _data_);
			return FALSE;
			_state_1:
			gnome_plugin_gnome_shell_extension_init_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp7_ = _data_->_error_;
			_data_->_tmp8_ = _data_->_tmp7_->message;
			g_warning ("gnome-plugin.vala:106: Error while initializing extension: %s", _data_->_tmp8_);
			_g_error_free0 (_data_->_error_);
			_g_free0 (_data_->expected_path);
			_g_free0 (_data_->expected_version);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->expected_path);
			_g_free0 (_data_->expected_version);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp9_ = _data_->expected_path;
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
	_g_free0 (_data_->self->priv->shell_extension_expected_path);
	_data_->self->priv->shell_extension_expected_path = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->expected_version;
	_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
	_g_free0 (_data_->self->priv->shell_extension_expected_version);
	_data_->self->priv->shell_extension_expected_version = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->self->priv->shell_extension;
	_data_->_tmp14_ = gnome_plugin_gnome_shell_extension_get_state (_data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = gnome_extension_state_to_string (_data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_tmp18_ = _data_->self->priv->shell_extension;
	_data_->_tmp19_ = gnome_plugin_gnome_shell_extension_get_version (_data_->_tmp18_);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = _data_->self->priv->shell_extension;
	_data_->_tmp22_ = gnome_plugin_gnome_shell_extension_get_path (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	g_info ("gnome-plugin.vala:114: Extension state=\"%s\" version=\"%s\" path=\"%s" \
"\"", _data_->_tmp17_, _data_->_tmp20_, _data_->_tmp23_);
	_g_free0 (_data_->_tmp17_);
	_data_->_tmp25_ = _data_->self->priv->shell_extension;
	_data_->_tmp26_ = gnome_plugin_gnome_shell_extension_get_path (_data_->_tmp25_);
	_data_->_tmp27_ = _data_->_tmp26_;
	_data_->_tmp28_ = _data_->expected_path;
	if (g_strcmp0 (_data_->_tmp27_, _data_->_tmp28_) != 0) {
		_data_->_tmp24_ = TRUE;
	} else {
		_data_->_tmp29_ = _data_->self->priv->shell_extension;
		_data_->_tmp30_ = gnome_plugin_gnome_shell_extension_get_version (_data_->_tmp29_);
		_data_->_tmp31_ = _data_->_tmp30_;
		_data_->_tmp32_ = _data_->expected_version;
		_data_->_tmp24_ = g_strcmp0 (_data_->_tmp31_, _data_->_tmp32_) != 0;
	}
	if (_data_->_tmp24_) {
		{
			_data_->_tmp33_ = _data_->self->priv->shell_extension;
			_data_->_state_ = 2;
			gnome_plugin_gnome_shell_extension_reload (_data_->_tmp33_, NULL, gnome_plugin_application_extension_init_shell_extension_ready, _data_);
			return FALSE;
			_state_2:
			gnome_plugin_gnome_shell_extension_reload_finish (_data_->_tmp33_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala1__error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp34_ = _data_->_vala1__error_;
			_data_->_tmp35_ = _data_->_tmp34_->message;
			g_warning ("gnome-plugin.vala:127: Error while reloading extension: %s", _data_->_tmp35_);
			_g_error_free0 (_data_->_vala1__error_);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->expected_path);
			_g_free0 (_data_->expected_version);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp36_ = _data_->self->priv->shell_extension;
	_data_->_tmp37_ = gnome_plugin_gnome_shell_extension_get_state (_data_->_tmp36_);
	_data_->_tmp38_ = _data_->_tmp37_;
	if (_data_->_tmp38_ != GNOME_EXTENSION_STATE_OUT_OF_DATE) {
	}
	if (_data_->should_enable) {
		_data_->_tmp40_ = _data_->self->priv->shell_extension;
		_data_->_tmp41_ = gnome_plugin_gnome_shell_extension_get_state (_data_->_tmp40_);
		_data_->_tmp42_ = _data_->_tmp41_;
		_data_->_tmp39_ = _data_->_tmp42_ != GNOME_EXTENSION_STATE_ENABLED;
	} else {
		_data_->_tmp39_ = FALSE;
	}
	if (_data_->_tmp39_) {
		_data_->_tmp43_ = _data_->self->priv->shell_extension;
		_data_->_state_ = 3;
		gnome_plugin_gnome_shell_extension_enable (_data_->_tmp43_, _data_->cancellable, gnome_plugin_application_extension_init_shell_extension_ready, _data_);
		return FALSE;
		_state_3:
		gnome_plugin_gnome_shell_extension_enable_finish (_data_->_tmp43_, _data_->_res_);
	} else {
		if (!_data_->should_enable) {
			_data_->_tmp45_ = _data_->self->priv->shell_extension;
			_data_->_tmp46_ = gnome_plugin_gnome_shell_extension_get_state (_data_->_tmp45_);
			_data_->_tmp47_ = _data_->_tmp46_;
			_data_->_tmp44_ = _data_->_tmp47_ == GNOME_EXTENSION_STATE_ENABLED;
		} else {
			_data_->_tmp44_ = FALSE;
		}
		if (_data_->_tmp44_) {
			_data_->_tmp48_ = _data_->self->priv->shell_extension;
			_data_->_state_ = 4;
			gnome_plugin_gnome_shell_extension_disable (_data_->_tmp48_, _data_->cancellable, gnome_plugin_application_extension_init_shell_extension_ready, _data_);
			return FALSE;
			_state_4:
			gnome_plugin_gnome_shell_extension_disable_finish (_data_->_tmp48_, _data_->_res_);
		}
	}
	_g_free0 (_data_->expected_path);
	_g_free0 (_data_->expected_version);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gnome_plugin_application_extension_real_init_async_data_free (gpointer _data)
{
	GnomePluginApplicationExtensionInitAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GnomePluginApplicationExtensionInitAsyncData, _data_);
}

static void
gnome_plugin_application_extension_real_init_async (GAsyncInitable* base,
                                                    gint io_priority,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	GnomePluginApplicationExtension * self;
	GnomePluginApplicationExtensionInitAsyncData* _data_;
	GnomePluginApplicationExtension* _tmp0_;
	GCancellable* _tmp1_;
	self = (GnomePluginApplicationExtension*) base;
	_data_ = g_slice_new0 (GnomePluginApplicationExtensionInitAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gnome_plugin_application_extension_real_init_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->io_priority = io_priority;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	gnome_plugin_application_extension_real_init_async_co (_data_);
}

static gboolean
gnome_plugin_application_extension_init_finish (GAsyncInitable* base,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	gboolean result;
	GnomePluginApplicationExtensionInitAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
gnome_plugin_application_extension_init_async_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	GnomePluginApplicationExtensionInitAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gnome_plugin_application_extension_real_init_async_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
gnome_plugin_application_extension_real_init_async_co (GnomePluginApplicationExtensionInitAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_getenv (GNOME_PLUGIN_CURRENT_DESKTOP_VARIABLE);
	_data_->self->priv->is_gnome = g_str_has_suffix (_data_->_tmp0_, "GNOME");
	_data_->_tmp1_ = pomodoro_get_settings ();
	_data_->_tmp2_ = g_settings_get_child (_data_->_tmp1_, "preferences");
	_g_object_unref0 (_data_->self->priv->settings);
	_data_->self->priv->settings = _data_->_tmp2_;
	_data_->_tmp3_ = pomodoro_capability_group_new ("gnome");
	_g_object_unref0 (_data_->self->priv->capabilities);
	_data_->self->priv->capabilities = _data_->_tmp3_;
	if (!_data_->self->priv->is_gnome) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->idle_monitor;
	if (_data_->_tmp4_ == NULL) {
		{
			_data_->_tmp6_ = gnome_plugin_idle_monitor_new (&_data_->_inner_error0_);
			_data_->_tmp5_ = _data_->_tmp6_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp7_ = _data_->_tmp5_;
			_data_->_tmp5_ = NULL;
			_g_object_unref0 (_data_->self->priv->idle_monitor);
			_data_->self->priv->idle_monitor = _data_->_tmp7_;
			_data_->_tmp8_ = pomodoro_timer_get_default ();
			_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
			_g_object_unref0 (_data_->self->priv->timer);
			_data_->self->priv->timer = _data_->_tmp9_;
			_data_->_tmp10_ = _data_->self->priv->timer;
			g_signal_connect_object (_data_->_tmp10_, "state-changed", (GCallback) _gnome_plugin_application_extension_on_timer_state_changed_pomodoro_timer_state_changed, _data_->self, G_CONNECT_AFTER);
			_data_->_tmp11_ = _data_->self->priv->capabilities;
			_data_->_tmp12_ = pomodoro_capability_new ("idle-monitor", NULL, NULL, NULL, NULL, NULL, NULL);
			g_object_ref_sink (_data_->_tmp12_);
			_data_->_tmp13_ = _data_->_tmp12_;
			pomodoro_capability_group_add (_data_->_tmp11_, _data_->_tmp13_);
			_g_object_unref0 (_data_->_tmp13_);
			_g_object_unref0 (_data_->_tmp5_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			g_debug ("gnome-plugin.vala:176: Gnome.IdleMonitor is not available");
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp14_ = pomodoro_application_get_default ();
	_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp14_);
	_data_->application = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->application;
	_data_->_tmp17_ = _data_->_tmp16_->capabilities;
	_data_->_tmp18_ = _data_->self->priv->capabilities;
	pomodoro_capability_manager_add_group (_data_->_tmp17_, _data_->_tmp18_, POMODORO_PRIORITY_HIGH);
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (GNOME_TYPE_SHELL_PROXY, 0, _data_->cancellable, gnome_plugin_application_extension_init_async_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START, "g-name", "org.gnome.Shell", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/Shell", "g-interface-name", "org.gnome.Shell", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp20_ = (GnomeShell*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp19_ = (GnomeShell*) _data_->_tmp20_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp21_ = _data_->_tmp19_;
		_data_->_tmp19_ = NULL;
		_g_object_unref0 (_data_->self->priv->shell_proxy);
		_data_->self->priv->shell_proxy = _data_->_tmp21_;
		_g_object_unref0 (_data_->_tmp19_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp22_ = _data_->_error_;
		_data_->_tmp23_ = _data_->_tmp22_->message;
		g_warning ("gnome-plugin.vala:193: Failed to connect to org.gnome.Shell: %s", _data_->_tmp23_);
		_data_->_tmp24_ = _data_->_error_;
		_data_->_tmp25_ = _g_error_copy0 (_data_->_tmp24_);
		_data_->_inner_error0_ = _data_->_tmp25_;
		_g_error_free0 (_data_->_error_);
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->application);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 2;
		g_async_initable_new_async (GNOME_TYPE_SHELL_EXTENSIONS_PROXY, 0, _data_->cancellable, gnome_plugin_application_extension_init_async_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START, "g-name", "org.gnome.Shell", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/Shell", "g-interface-name", "org.gnome.Shell.Extensions", NULL);
		return FALSE;
		_state_2:
		_data_->_tmp27_ = (GnomeShellExtensions*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp26_ = (GnomeShellExtensions*) _data_->_tmp27_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_data_->_tmp28_ = _data_->_tmp26_;
		_data_->_tmp26_ = NULL;
		_g_object_unref0 (_data_->self->priv->shell_extensions_proxy);
		_data_->self->priv->shell_extensions_proxy = _data_->_tmp28_;
		_g_object_unref0 (_data_->_tmp26_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->_vala1__error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp29_ = _data_->_vala1__error_;
		_data_->_tmp30_ = _data_->_tmp29_->message;
		g_warning ("gnome-plugin.vala:206: Failed to connect to org.gnome.Shell.Extensions" \
": %s", _data_->_tmp30_);
		_data_->_tmp31_ = _data_->_vala1__error_;
		_data_->_tmp32_ = _g_error_copy0 (_data_->_tmp31_);
		_data_->_inner_error0_ = _data_->_tmp32_;
		_g_error_free0 (_data_->_vala1__error_);
		goto __finally2;
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->application);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 3;
	gnome_plugin_application_extension_init_shell_extension (_data_->self, _data_->cancellable, gnome_plugin_application_extension_init_async_ready, _data_);
	return FALSE;
	_state_3:
	gnome_plugin_application_extension_init_shell_extension_finish (_data_->self, _data_->_res_);
	_data_->result = TRUE;
	_g_object_unref0 (_data_->application);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_gnome_plugin_application_extension_on_become_active_gnome_plugin_idle_monitor_watch_func (GnomePluginIdleMonitor* monitor,
                                                                                           guint id,
                                                                                           gpointer self)
{
	gnome_plugin_application_extension_on_become_active ((GnomePluginApplicationExtension*) self, monitor, id);
}

static void
gnome_plugin_application_extension_on_timer_state_changed (GnomePluginApplicationExtension* self,
                                                           PomodoroTimerState* state,
                                                           PomodoroTimerState* previous_state)
{
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	g_return_if_fail (previous_state != NULL);
	if (self->priv->become_active_id != ((guint) 0)) {
		GnomePluginIdleMonitor* _tmp0_;
		_tmp0_ = self->priv->idle_monitor;
		gnome_plugin_idle_monitor_remove_watch (_tmp0_, self->priv->become_active_id);
		self->priv->become_active_id = (guint) 0;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (state, POMODORO_TYPE_POMODORO_STATE)) {
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (previous_state, POMODORO_TYPE_BREAK_STATE);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = pomodoro_timer_state_is_completed (previous_state);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GSettings* _tmp4_;
		_tmp4_ = self->priv->settings;
		_tmp1_ = g_settings_get_boolean (_tmp4_, "pause-when-idle");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GnomePluginIdleMonitor* _tmp5_;
		PomodoroTimer* _tmp6_;
		_tmp5_ = self->priv->idle_monitor;
		self->priv->become_active_id = gnome_plugin_idle_monitor_add_user_active_watch (_tmp5_, _gnome_plugin_application_extension_on_become_active_gnome_plugin_idle_monitor_watch_func, g_object_ref (self), g_object_unref);
		_tmp6_ = self->priv->timer;
		pomodoro_timer_pause (_tmp6_, pomodoro_get_current_time ());
	}
}

/**
         * on_become_active callback
         *
         * We want to detect user/human activity so it sparse events.
         */
static void
gnome_plugin_application_extension_on_become_active (GnomePluginApplicationExtension* self,
                                                     GnomePluginIdleMonitor* monitor,
                                                     guint id)
{
	gdouble timestamp = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	timestamp = pomodoro_get_current_time ();
	if ((timestamp - self->priv->last_activity_time) < GNOME_PLUGIN_IDLE_MONITOR_MIN_IDLE_TIME) {
		PomodoroTimer* _tmp0_;
		self->priv->become_active_id = (guint) 0;
		_tmp0_ = self->priv->timer;
		pomodoro_timer_resume (_tmp0_, pomodoro_get_current_time ());
	} else {
		GnomePluginIdleMonitor* _tmp1_;
		_tmp1_ = self->priv->idle_monitor;
		self->priv->become_active_id = gnome_plugin_idle_monitor_add_user_active_watch (_tmp1_, _gnome_plugin_application_extension_on_become_active_gnome_plugin_idle_monitor_watch_func, g_object_ref (self), g_object_unref);
	}
	self->priv->last_activity_time = timestamp;
}

GnomePluginApplicationExtension*
gnome_plugin_application_extension_construct (GType object_type)
{
	GnomePluginApplicationExtension * self = NULL;
	self = (GnomePluginApplicationExtension*) g_object_new (object_type, NULL);
	return self;
}

GnomePluginApplicationExtension*
gnome_plugin_application_extension_new (void)
{
	return gnome_plugin_application_extension_construct (GNOME_PLUGIN_TYPE_APPLICATION_EXTENSION);
}

static void
gnome_plugin_application_extension_class_init (GnomePluginApplicationExtensionClass * klass,
                                               gpointer klass_data)
{
	gnome_plugin_application_extension_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GnomePluginApplicationExtension_private_offset);
	G_OBJECT_CLASS (klass)->finalize = gnome_plugin_application_extension_finalize;
}

static void
gnome_plugin_application_extension_pomodoro_application_extension_interface_init (PomodoroApplicationExtensionIface * iface,
                                                                                  gpointer iface_data)
{
	gnome_plugin_application_extension_pomodoro_application_extension_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gnome_plugin_application_extension_g_async_initable_interface_init (GAsyncInitableIface * iface,
                                                                    gpointer iface_data)
{
	gnome_plugin_application_extension_g_async_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init_async = (void (*) (GAsyncInitable*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) gnome_plugin_application_extension_real_init_async;
	iface->init_finish = (gboolean (*) (GAsyncInitable*, GAsyncResult*, GError**)) gnome_plugin_application_extension_init_finish;
}

static void
gnome_plugin_application_extension_instance_init (GnomePluginApplicationExtension * self,
                                                  gpointer klass)
{
	self->priv = gnome_plugin_application_extension_get_instance_private (self);
	self->priv->become_active_id = (guint) 0;
	self->priv->is_gnome = FALSE;
	self->priv->last_activity_time = 0.0;
	self->priv->shell_proxy = NULL;
	self->priv->shell_extensions_proxy = NULL;
}

static void
gnome_plugin_application_extension_finalize (GObject * obj)
{
	GnomePluginApplicationExtension * self;
	PomodoroTimer* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PLUGIN_TYPE_APPLICATION_EXTENSION, GnomePluginApplicationExtension);
	_tmp0_ = self->priv->timer;
	g_signal_parse_name ("state-changed", POMODORO_TYPE_TIMER, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gnome_plugin_application_extension_on_timer_state_changed_pomodoro_timer_state_changed, self);
	if (self->priv->become_active_id != ((guint) 0)) {
		GnomePluginIdleMonitor* _tmp2_;
		_tmp2_ = self->priv->idle_monitor;
		gnome_plugin_idle_monitor_remove_watch (_tmp2_, self->priv->become_active_id);
		self->priv->become_active_id = (guint) 0;
	}
	_g_object_unref0 (self->priv->timer);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->capabilities);
	_g_object_unref0 (self->priv->shell_extension);
	_g_free0 (self->priv->shell_extension_expected_path);
	_g_free0 (self->priv->shell_extension_expected_version);
	_g_object_unref0 (self->priv->idle_monitor);
	_g_object_unref0 (self->priv->shell_proxy);
	_g_object_unref0 (self->priv->shell_extensions_proxy);
	G_OBJECT_CLASS (gnome_plugin_application_extension_parent_class)->finalize (obj);
}

GType
gnome_plugin_application_extension_get_type (void)
{
	return gnome_plugin_application_extension_type_id;
}

GType
gnome_plugin_application_extension_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePluginApplicationExtensionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_plugin_application_extension_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePluginApplicationExtension), 0, (GInstanceInitFunc) gnome_plugin_application_extension_instance_init, NULL };
	static const GInterfaceInfo pomodoro_application_extension_info = { (GInterfaceInitFunc) gnome_plugin_application_extension_pomodoro_application_extension_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo g_async_initable_info = { (GInterfaceInitFunc) gnome_plugin_application_extension_g_async_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	gnome_plugin_application_extension_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GnomePluginApplicationExtension", &g_define_type_info, 0);
	g_type_module_add_interface (module, gnome_plugin_application_extension_type_id, POMODORO_TYPE_APPLICATION_EXTENSION, &pomodoro_application_extension_info);
	g_type_module_add_interface (module, gnome_plugin_application_extension_type_id, g_async_initable_get_type (), &g_async_initable_info);
	GnomePluginApplicationExtension_private_offset = sizeof (GnomePluginApplicationExtensionPrivate);
	return gnome_plugin_application_extension_type_id;
}

static inline gpointer
gnome_plugin_preferences_dialog_extension_get_instance_private (GnomePluginPreferencesDialogExtension* self)
{
	return G_STRUCT_MEMBER_P (self, GnomePluginPreferencesDialogExtension_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
gnome_plugin_preferences_dialog_extension_setup_main_page (GnomePluginPreferencesDialogExtension* self)
{
	PomodoroPreferencesMainPage* main_page = NULL;
	PomodoroPreferencesDialog* _tmp0_;
	PomodoroPreferencesPage* _tmp1_;
	PomodoroPreferencesMainPage* _tmp2_;
	GtkSwitch* hide_system_notifications_toggle = NULL;
	GtkSwitch* _tmp3_;
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp4_;
	GtkSizeGroup* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBoxRow* _tmp7_;
	GSettings* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dialog;
	_tmp1_ = pomodoro_preferences_dialog_get_page (_tmp0_, "main");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, POMODORO_TYPE_PREFERENCES_MAIN_PAGE) ? ((PomodoroPreferencesMainPage*) _tmp1_) : NULL);
	main_page = _tmp2_;
	_tmp3_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp3_);
	hide_system_notifications_toggle = _tmp3_;
	gtk_widget_set_valign ((GtkWidget*) hide_system_notifications_toggle, GTK_ALIGN_CENTER);
	_tmp4_ = gnome_plugin_preferences_dialog_extension_create_row (self, _ ("Hide other notifications"), (GtkWidget*) hide_system_notifications_toggle);
	row = _tmp4_;
	gtk_widget_set_name ((GtkWidget*) row, "hide-system-notifications");
	_tmp5_ = main_page->lisboxrow_sizegroup;
	gtk_size_group_add_widget (_tmp5_, (GtkWidget*) row);
	_tmp6_ = main_page->desktop_listbox;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) row);
	_tmp7_ = _g_object_ref0 (row);
	self->priv->rows = g_list_prepend (self->priv->rows, _tmp7_);
	_tmp8_ = self->priv->settings;
	g_settings_bind (_tmp8_, "hide-system-notifications", (GObject*) hide_system_notifications_toggle, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (row);
	_g_object_unref0 (hide_system_notifications_toggle);
	_g_object_unref0 (main_page);
}

static GtkListBoxRow*
gnome_plugin_preferences_dialog_extension_create_row (GnomePluginPreferencesDialogExtension* self,
                                                      const gchar* label,
                                                      GtkWidget* widget)
{
	GtkLabel* name_label = NULL;
	GtkLabel* _tmp0_;
	GtkBox* box = NULL;
	GtkBox* _tmp1_;
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (label);
	g_object_ref_sink (_tmp0_);
	name_label = _tmp0_;
	gtk_widget_set_halign ((GtkWidget*) name_label, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) name_label, GTK_ALIGN_BASELINE);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp1_);
	box = _tmp1_;
	gtk_box_pack_start (box, (GtkWidget*) name_label, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start (box, widget, FALSE, TRUE, (guint) 0);
	_tmp2_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	g_object_ref_sink (_tmp2_);
	row = _tmp2_;
	gtk_list_box_row_set_activatable (row, FALSE);
	gtk_list_box_row_set_selectable (row, FALSE);
	gtk_container_add ((GtkContainer*) row, (GtkWidget*) box);
	gtk_widget_show_all ((GtkWidget*) row);
	result = row;
	_g_object_unref0 (box);
	_g_object_unref0 (name_label);
	return result;
}

GnomePluginPreferencesDialogExtension*
gnome_plugin_preferences_dialog_extension_construct (GType object_type)
{
	GnomePluginPreferencesDialogExtension * self = NULL;
	self = (GnomePluginPreferencesDialogExtension*) g_object_new (object_type, NULL);
	return self;
}

GnomePluginPreferencesDialogExtension*
gnome_plugin_preferences_dialog_extension_new (void)
{
	return gnome_plugin_preferences_dialog_extension_construct (GNOME_PLUGIN_TYPE_PREFERENCES_DIALOG_EXTENSION);
}

static GObject *
gnome_plugin_preferences_dialog_extension_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GnomePluginPreferencesDialogExtension * self;
	GSettings* _tmp0_;
	PomodoroPreferencesDialog* _tmp1_;
	parent_class = G_OBJECT_CLASS (gnome_plugin_preferences_dialog_extension_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PLUGIN_TYPE_PREFERENCES_DIALOG_EXTENSION, GnomePluginPreferencesDialogExtension);
	_tmp0_ = g_settings_new ("org.gnome.pomodoro.plugins.gnome");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = pomodoro_preferences_dialog_get_default ();
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp1_;
	gnome_plugin_preferences_dialog_extension_setup_main_page (self);
	return obj;
}

static void
gnome_plugin_preferences_dialog_extension_class_init (GnomePluginPreferencesDialogExtensionClass * klass,
                                                      gpointer klass_data)
{
	gnome_plugin_preferences_dialog_extension_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GnomePluginPreferencesDialogExtension_private_offset);
	G_OBJECT_CLASS (klass)->constructor = gnome_plugin_preferences_dialog_extension_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_plugin_preferences_dialog_extension_finalize;
}

static void
gnome_plugin_preferences_dialog_extension_pomodoro_preferences_dialog_extension_interface_init (PomodoroPreferencesDialogExtensionIface * iface,
                                                                                                gpointer iface_data)
{
	gnome_plugin_preferences_dialog_extension_pomodoro_preferences_dialog_extension_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gnome_plugin_preferences_dialog_extension_instance_init (GnomePluginPreferencesDialogExtension * self,
                                                         gpointer klass)
{
	self->priv = gnome_plugin_preferences_dialog_extension_get_instance_private (self);
}

static void
gnome_plugin_preferences_dialog_extension_finalize (GObject * obj)
{
	GnomePluginPreferencesDialogExtension * self;
	GList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PLUGIN_TYPE_PREFERENCES_DIALOG_EXTENSION, GnomePluginPreferencesDialogExtension);
	_tmp0_ = self->priv->rows;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp0_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkListBoxRow* _tmp1_;
			GtkListBoxRow* row = NULL;
			_tmp1_ = _g_object_ref0 ((GtkListBoxRow*) row_it->data);
			row = _tmp1_;
			{
				GtkListBoxRow* _tmp2_;
				_tmp2_ = row;
				gtk_widget_destroy ((GtkWidget*) _tmp2_);
				_g_object_unref0 (row);
			}
		}
	}
	(self->priv->rows == NULL) ? NULL : (self->priv->rows = (_g_list_free__g_object_unref0_ (self->priv->rows), NULL));
	self->priv->rows = NULL;
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->settings);
	(self->priv->rows == NULL) ? NULL : (self->priv->rows = (_g_list_free__g_object_unref0_ (self->priv->rows), NULL));
	G_OBJECT_CLASS (gnome_plugin_preferences_dialog_extension_parent_class)->finalize (obj);
}

GType
gnome_plugin_preferences_dialog_extension_get_type (void)
{
	return gnome_plugin_preferences_dialog_extension_type_id;
}

GType
gnome_plugin_preferences_dialog_extension_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePluginPreferencesDialogExtensionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_plugin_preferences_dialog_extension_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePluginPreferencesDialogExtension), 0, (GInstanceInitFunc) gnome_plugin_preferences_dialog_extension_instance_init, NULL };
	static const GInterfaceInfo pomodoro_preferences_dialog_extension_info = { (GInterfaceInitFunc) gnome_plugin_preferences_dialog_extension_pomodoro_preferences_dialog_extension_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	gnome_plugin_preferences_dialog_extension_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GnomePluginPreferencesDialogExtension", &g_define_type_info, 0);
	g_type_module_add_interface (module, gnome_plugin_preferences_dialog_extension_type_id, POMODORO_TYPE_PREFERENCES_DIALOG_EXTENSION, &pomodoro_preferences_dialog_extension_info);
	GnomePluginPreferencesDialogExtension_private_offset = sizeof (GnomePluginPreferencesDialogExtensionPrivate);
	return gnome_plugin_preferences_dialog_extension_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* object_module = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	gnome_shell_register_type (module);
	gnome_shell_proxy_register_dynamic_type (module);
	gnome_shell_extensions_register_type (module);
	gnome_shell_extensions_proxy_register_dynamic_type (module);
	meta_idle_monitor_register_type (module);
	meta_idle_monitor_proxy_register_dynamic_type (module);
	gnome_plugin_idle_monitor_watch_register_type (module);
	gnome_plugin_idle_monitor_register_type (module);
	gnome_plugin_application_extension_register_type (module);
	gnome_plugin_preferences_dialog_extension_register_type (module);
	gnome_plugin_gnome_shell_extension_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	object_module = _tmp0_;
	peas_object_module_register_extension_type (object_module, POMODORO_TYPE_APPLICATION_EXTENSION, GNOME_PLUGIN_TYPE_APPLICATION_EXTENSION);
	peas_object_module_register_extension_type (object_module, POMODORO_TYPE_PREFERENCES_DIALOG_EXTENSION, GNOME_PLUGIN_TYPE_PREFERENCES_DIALOG_EXTENSION);
	_g_object_unref0 (object_module);
}

