/* gnome-shell-extension.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gnome-shell-extension.vala, do not modify */

/*
 * Copyright (c) 2016 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "gnome.h"

#define GNOME_PLUGIN_SCRIPT_WRAPPER "\n(function() {\n    ${SCRIPT}\n\n    return null;\n})();\n"
#define GNOME_PLUGIN_LOAD_SCRIPT "\n" \
"const { Gio } = imports.gi;\n" \
"const FileUtils = imports.misc.fileUtils;\n" \
"const { ExtensionType } = imports.misc.extensionUtils;\n" \
"\n" \
"let perUserDir = Gio.File.new_for_path(global.userdatadir);\n" \
"let uuid = '${UUID}';\n" \
"let extension = Main.extensionManager.lookup(uuid);\n" \
"\n" \
"if (extension)\n" \
"    return;\n" \
"\n" \
"FileUtils.collectFromDatadirs('extensions', true, (dir, info) => {\n" \
"    let fileType = info.get_file_type();\n" \
"    if (fileType != Gio.FileType.DIRECTORY)\n" \
"        return;\n" \
"\n" \
"    if (info.get_name() != uuid)\n" \
"        return;\n" \
"\n" \
"    let extensionType = dir.has_prefix(perUserDir)\n" \
"        ? ExtensionType.PER_USER\n" \
"        : ExtensionType.SYSTEM;\n" \
"    try {\n" \
"        Main.extensionManager.loadExtension(\n" \
"            Main.extensionManager.createExtensionObject(uuid, dir, ext" \
"ensionType)\n" \
"        );\n" \
"    } catch (error) {\n" \
"        logError(error, 'Could not load extension %s'.format(uuid));\n" \
"        throw error;\n" \
"    }\n" \
"});\n" \
"extension = Main.extensionManager.lookup(uuid);\n" \
"if (!extension)\n" \
"    throw new Error('Could not find extension %s'.format(uuid));\n"
#define GNOME_PLUGIN_RELOAD_SCRIPT "\n" \
"let uuid = '${UUID}';\n" \
"let extension = Main.extensionManager.lookup(uuid);\n" \
"\n" \
"try {\n" \
"    if (extension)\n" \
"        Main.extensionManager.reloadExtension(extension);\n" \
"    else\n" \
"        throw new Error('Could not find extension %s'.format(uuid));\n" \
"} catch (error) {\n" \
"    logError(error, 'Error while reloading extension %s'.format(uuid))" \
";\n" \
"    throw error;\n" \
"}\n"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION_ERROR (gnome_plugin_gnome_shell_extension_error_get_type ())

#define GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION (gnome_plugin_gnome_shell_extension_get_type ())
#define GNOME_PLUGIN_GNOME_SHELL_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION, GnomePluginGnomeShellExtension))
#define GNOME_PLUGIN_GNOME_SHELL_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION, GnomePluginGnomeShellExtensionClass))
#define GNOME_PLUGIN_IS_GNOME_SHELL_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION))
#define GNOME_PLUGIN_IS_GNOME_SHELL_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION))
#define GNOME_PLUGIN_GNOME_SHELL_EXTENSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION, GnomePluginGnomeShellExtensionClass))

typedef struct _GnomePluginGnomeShellExtension GnomePluginGnomeShellExtension;
typedef struct _GnomePluginGnomeShellExtensionClass GnomePluginGnomeShellExtensionClass;
typedef struct _GnomePluginGnomeShellExtensionPrivate GnomePluginGnomeShellExtensionPrivate;
enum  {
	GNOME_PLUGIN_GNOME_SHELL_EXTENSION_0_PROPERTY,
	GNOME_PLUGIN_GNOME_SHELL_EXTENSION_UUID_PROPERTY,
	GNOME_PLUGIN_GNOME_SHELL_EXTENSION_PATH_PROPERTY,
	GNOME_PLUGIN_GNOME_SHELL_EXTENSION_VERSION_PROPERTY,
	GNOME_PLUGIN_GNOME_SHELL_EXTENSION_STATE_PROPERTY,
	GNOME_PLUGIN_GNOME_SHELL_EXTENSION_NUM_PROPERTIES
};
static GParamSpec* gnome_plugin_gnome_shell_extension_properties[GNOME_PLUGIN_GNOME_SHELL_EXTENSION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GnomePluginGnomeShellExtensionInitAsyncData GnomePluginGnomeShellExtensionInitAsyncData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GnomePluginGnomeShellExtensionUpdateData GnomePluginGnomeShellExtensionUpdateData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _GnomePluginGnomeShellExtensionLoadData GnomePluginGnomeShellExtensionLoadData;
typedef struct _GnomePluginGnomeShellExtensionReloadData GnomePluginGnomeShellExtensionReloadData;
typedef struct _GnomePluginGnomeShellExtensionEnableData GnomePluginGnomeShellExtensionEnableData;
typedef struct _GnomePluginGnomeShellExtensionDisableData GnomePluginGnomeShellExtensionDisableData;
enum  {
	GNOME_PLUGIN_GNOME_SHELL_EXTENSION_STATE_CHANGED_SIGNAL,
	GNOME_PLUGIN_GNOME_SHELL_EXTENSION_NUM_SIGNALS
};
static guint gnome_plugin_gnome_shell_extension_signals[GNOME_PLUGIN_GNOME_SHELL_EXTENSION_NUM_SIGNALS] = {0};

typedef enum  {
	GNOME_PLUGIN_GNOME_SHELL_EXTENSION_ERROR_SYNC_ERROR,
	GNOME_PLUGIN_GNOME_SHELL_EXTENSION_ERROR_EVAL_ERROR
} GnomePluginGnomeShellExtensionError;
#define GNOME_PLUGIN_GNOME_SHELL_EXTENSION_ERROR gnome_plugin_gnome_shell_extension_error_quark ()

struct _GnomePluginGnomeShellExtension {
	GObject parent_instance;
	GnomePluginGnomeShellExtensionPrivate * priv;
};

struct _GnomePluginGnomeShellExtensionClass {
	GObjectClass parent_class;
	void (*init_async) (GnomePluginGnomeShellExtension* self, gint io_priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*init_finish) (GnomePluginGnomeShellExtension* self, GAsyncResult* _res_, GError** error);
};

struct _GnomePluginGnomeShellExtensionPrivate {
	gchar* _uuid;
	gchar* _path;
	gchar* _version;
	GnomeExtensionState _state;
	GnomeShell* shell_proxy;
	GnomeShellExtensions* shell_extensions_proxy;
	gulong extension_state_changed_id;
};

struct _GnomePluginGnomeShellExtensionInitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GnomePluginGnomeShellExtension* self;
	gint io_priority;
	GCancellable* cancellable;
	gboolean result;
	GError* _tmp0_;
	GnomeShellExtensions* _tmp1_;
	gulong _tmp2_;
	GError* _inner_error0_;
};

struct _GnomePluginGnomeShellExtensionUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GnomePluginGnomeShellExtension* self;
	GCancellable* cancellable;
	GHashTable* data;
	const gchar* _tmp0_;
	GHashTable* _tmp1_;
	GnomeShellExtensions* _tmp2_;
	const gchar* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GError* _error_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GHashTable* _tmp10_;
	GError* _vala1__error_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _inner_error0_;
};

struct _GnomePluginGnomeShellExtensionLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GnomePluginGnomeShellExtension* self;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _error_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GnomeExtensionState _tmp6_;
	GError* _inner_error0_;
};

struct _GnomePluginGnomeShellExtensionReloadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GnomePluginGnomeShellExtension* self;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GnomeExtensionState _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	gchar* previous_path;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* previous_version;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _error_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GnomeExtensionState _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	gboolean _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GError* _inner_error0_;
};

struct _GnomePluginGnomeShellExtensionEnableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GnomePluginGnomeShellExtension* self;
	GCancellable* cancellable;
	gboolean result;
	const gchar* _tmp0_;
	GError* _error_;
	GError* _tmp1_;
	const gchar* _tmp2_;
	GnomeShellExtensions* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GnomeShellExtensions* _tmp6_;
	const gchar* _tmp7_;
	GError* _vala1__error_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GnomeExtensionState _tmp10_;
	GError* _inner_error0_;
};

struct _GnomePluginGnomeShellExtensionDisableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GnomePluginGnomeShellExtension* self;
	GCancellable* cancellable;
	gboolean result;
	GnomeShellExtensions* _tmp0_;
	const gchar* _tmp1_;
	GError* _error_;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GnomeExtensionState _tmp4_;
	GError* _inner_error0_;
};

static gint GnomePluginGnomeShellExtension_private_offset;
static gpointer gnome_plugin_gnome_shell_extension_parent_class = NULL;
static GAsyncInitableIface * gnome_plugin_gnome_shell_extension_g_async_initable_parent_iface = NULL;
static GType gnome_plugin_gnome_shell_extension_type_id = 0;

VALA_EXTERN GQuark gnome_plugin_gnome_shell_extension_error_quark (void);
VALA_EXTERN GType gnome_plugin_gnome_shell_extension_error_get_type (void) G_GNUC_CONST ;
GType gnome_plugin_gnome_shell_extension_register_type (GTypeModule * module);
VALA_EXTERN GType gnome_plugin_gnome_shell_extension_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void gnome_plugin_gnome_shell_extension_init_async (GnomePluginGnomeShellExtension* self,
                                                    gint io_priority,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN gboolean gnome_plugin_gnome_shell_extension_init_finish (GnomePluginGnomeShellExtension* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
VALA_EXTERN GnomePluginGnomeShellExtension* gnome_plugin_gnome_shell_extension_new (GnomeShell* shell_proxy,
                                                                        GnomeShellExtensions* shell_extensions_proxy,
                                                                        const gchar* uuid);
VALA_EXTERN GnomePluginGnomeShellExtension* gnome_plugin_gnome_shell_extension_construct (GType object_type,
                                                                              GnomeShell* shell_proxy,
                                                                              GnomeShellExtensions* shell_extensions_proxy,
                                                                              const gchar* uuid);
static void gnome_plugin_gnome_shell_extension_real_init_async_data_free (gpointer _data);
static void gnome_plugin_gnome_shell_extension_real_init_async (GnomePluginGnomeShellExtension* self,
                                                         gint io_priority,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static gboolean gnome_plugin_gnome_shell_extension_real_init_async_co (GnomePluginGnomeShellExtensionInitAsyncData* _data_);
static void gnome_plugin_gnome_shell_extension_update (GnomePluginGnomeShellExtension* self,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void gnome_plugin_gnome_shell_extension_update_finish (GnomePluginGnomeShellExtension* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void gnome_plugin_gnome_shell_extension_init_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void gnome_plugin_gnome_shell_extension_on_extension_state_changed (GnomePluginGnomeShellExtension* self,
                                                                    const gchar* uuid,
                                                                    GHashTable* data);
static void _gnome_plugin_gnome_shell_extension_on_extension_state_changed_gnome_shell_extensions_extension_state_changed (GnomeShellExtensions* _sender,
                                                                                                                    const gchar* uuid,
                                                                                                                    GHashTable* state,
                                                                                                                    gpointer self);
static void gnome_plugin_gnome_shell_extension_do_update (GnomePluginGnomeShellExtension* self,
                                                   GHashTable* data,
                                                   GError** error);
VALA_EXTERN const gchar* gnome_plugin_gnome_shell_extension_get_uuid (GnomePluginGnomeShellExtension* self);
VALA_EXTERN GnomeExtensionState gnome_plugin_gnome_shell_extension_get_state (GnomePluginGnomeShellExtension* self);
VALA_EXTERN const gchar* gnome_plugin_gnome_shell_extension_get_path (GnomePluginGnomeShellExtension* self);
VALA_EXTERN const gchar* gnome_plugin_gnome_shell_extension_get_version (GnomePluginGnomeShellExtension* self);
VALA_EXTERN void gnome_plugin_gnome_shell_extension_set_path (GnomePluginGnomeShellExtension* self,
                                                  const gchar* value);
VALA_EXTERN void gnome_plugin_gnome_shell_extension_set_version (GnomePluginGnomeShellExtension* self,
                                                     const gchar* value);
VALA_EXTERN void gnome_plugin_gnome_shell_extension_set_state (GnomePluginGnomeShellExtension* self,
                                                   GnomeExtensionState value);
static void gnome_plugin_gnome_shell_extension_update_data_free (gpointer _data);
static gboolean gnome_plugin_gnome_shell_extension_update_co (GnomePluginGnomeShellExtensionUpdateData* _data_);
static void gnome_plugin_gnome_shell_extension_update_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void gnome_plugin_gnome_shell_extension_eval_script (GnomePluginGnomeShellExtension* self,
                                                     const gchar* script,
                                                     GError** error);
static void gnome_plugin_gnome_shell_extension_load_data_free (gpointer _data);
VALA_EXTERN void gnome_plugin_gnome_shell_extension_load (GnomePluginGnomeShellExtension* self,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN gboolean gnome_plugin_gnome_shell_extension_load_finish (GnomePluginGnomeShellExtension* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static gboolean gnome_plugin_gnome_shell_extension_load_co (GnomePluginGnomeShellExtensionLoadData* _data_);
static void gnome_plugin_gnome_shell_extension_load_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void gnome_plugin_gnome_shell_extension_reload_data_free (gpointer _data);
VALA_EXTERN void gnome_plugin_gnome_shell_extension_reload (GnomePluginGnomeShellExtension* self,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN gboolean gnome_plugin_gnome_shell_extension_reload_finish (GnomePluginGnomeShellExtension* self,
                                                           GAsyncResult* _res_,
                                                           GError** error);
static gboolean gnome_plugin_gnome_shell_extension_reload_co (GnomePluginGnomeShellExtensionReloadData* _data_);
static void gnome_plugin_gnome_shell_extension_reload_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void gnome_plugin_gnome_shell_extension_enable_data_free (gpointer _data);
VALA_EXTERN void gnome_plugin_gnome_shell_extension_enable (GnomePluginGnomeShellExtension* self,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN gboolean gnome_plugin_gnome_shell_extension_enable_finish (GnomePluginGnomeShellExtension* self,
                                                           GAsyncResult* _res_);
static gboolean gnome_plugin_gnome_shell_extension_enable_co (GnomePluginGnomeShellExtensionEnableData* _data_);
static void gnome_plugin_gnome_shell_extension_enable_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void gnome_plugin_gnome_shell_extension_disable_data_free (gpointer _data);
VALA_EXTERN void gnome_plugin_gnome_shell_extension_disable (GnomePluginGnomeShellExtension* self,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN gboolean gnome_plugin_gnome_shell_extension_disable_finish (GnomePluginGnomeShellExtension* self,
                                                            GAsyncResult* _res_);
static gboolean gnome_plugin_gnome_shell_extension_disable_co (GnomePluginGnomeShellExtensionDisableData* _data_);
static void gnome_plugin_gnome_shell_extension_disable_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void gnome_plugin_gnome_shell_extension_real_dispose (GObject* base);
VALA_EXTERN void gnome_plugin_gnome_shell_extension_set_uuid (GnomePluginGnomeShellExtension* self,
                                                  const gchar* value);
static void gnome_plugin_gnome_shell_extension_finalize (GObject * obj);
static void _vala_gnome_plugin_gnome_shell_extension_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_gnome_plugin_gnome_shell_extension_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);

GQuark
gnome_plugin_gnome_shell_extension_error_quark (void)
{
	return g_quark_from_static_string ("gnome-plugin-gnome-shell-extension-error-quark");
}

static GType
gnome_plugin_gnome_shell_extension_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GNOME_PLUGIN_GNOME_SHELL_EXTENSION_ERROR_SYNC_ERROR, "GNOME_PLUGIN_GNOME_SHELL_EXTENSION_ERROR_SYNC_ERROR", "sync-error"}, {GNOME_PLUGIN_GNOME_SHELL_EXTENSION_ERROR_EVAL_ERROR, "GNOME_PLUGIN_GNOME_SHELL_EXTENSION_ERROR_EVAL_ERROR", "eval-error"}, {0, NULL, NULL}};
	GType gnome_plugin_gnome_shell_extension_error_type_id;
	gnome_plugin_gnome_shell_extension_error_type_id = g_enum_register_static ("GnomePluginGnomeShellExtensionError", values);
	return gnome_plugin_gnome_shell_extension_error_type_id;
}

GType
gnome_plugin_gnome_shell_extension_error_get_type (void)
{
	static volatile gsize gnome_plugin_gnome_shell_extension_error_type_id__once = 0;
	if (g_once_init_enter (&gnome_plugin_gnome_shell_extension_error_type_id__once)) {
		GType gnome_plugin_gnome_shell_extension_error_type_id;
		gnome_plugin_gnome_shell_extension_error_type_id = gnome_plugin_gnome_shell_extension_error_get_type_once ();
		g_once_init_leave (&gnome_plugin_gnome_shell_extension_error_type_id__once, gnome_plugin_gnome_shell_extension_error_type_id);
	}
	return gnome_plugin_gnome_shell_extension_error_type_id__once;
}

static inline gpointer
gnome_plugin_gnome_shell_extension_get_instance_private (GnomePluginGnomeShellExtension* self)
{
	return G_STRUCT_MEMBER_P (self, GnomePluginGnomeShellExtension_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GnomePluginGnomeShellExtension*
gnome_plugin_gnome_shell_extension_construct (GType object_type,
                                              GnomeShell* shell_proxy,
                                              GnomeShellExtensions* shell_extensions_proxy,
                                              const gchar* uuid)
{
	GnomePluginGnomeShellExtension * self = NULL;
	GnomeShell* _tmp0_;
	GnomeShellExtensions* _tmp1_;
	g_return_val_if_fail (shell_proxy != NULL, NULL);
	g_return_val_if_fail (shell_extensions_proxy != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (GnomePluginGnomeShellExtension*) g_object_new (object_type, "uuid", uuid, "path", "", "version", "", NULL);
	_tmp0_ = _g_object_ref0 (shell_proxy);
	_g_object_unref0 (self->priv->shell_proxy);
	self->priv->shell_proxy = _tmp0_;
	_tmp1_ = _g_object_ref0 (shell_extensions_proxy);
	_g_object_unref0 (self->priv->shell_extensions_proxy);
	self->priv->shell_extensions_proxy = _tmp1_;
	return self;
}

GnomePluginGnomeShellExtension*
gnome_plugin_gnome_shell_extension_new (GnomeShell* shell_proxy,
                                        GnomeShellExtensions* shell_extensions_proxy,
                                        const gchar* uuid)
{
	return gnome_plugin_gnome_shell_extension_construct (GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION, shell_proxy, shell_extensions_proxy, uuid);
}

static void
gnome_plugin_gnome_shell_extension_real_init_async_data_free (gpointer _data)
{
	GnomePluginGnomeShellExtensionInitAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GnomePluginGnomeShellExtensionInitAsyncData, _data_);
}

static void
gnome_plugin_gnome_shell_extension_real_init_async (GnomePluginGnomeShellExtension* self,
                                                    gint io_priority,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	GnomePluginGnomeShellExtensionInitAsyncData* _data_;
	GnomePluginGnomeShellExtension* _tmp0_;
	GCancellable* _tmp1_;
	_data_ = g_slice_new0 (GnomePluginGnomeShellExtensionInitAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gnome_plugin_gnome_shell_extension_real_init_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->io_priority = io_priority;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	gnome_plugin_gnome_shell_extension_real_init_async_co (_data_);
}

static gboolean
gnome_plugin_gnome_shell_extension_real_init_finish (GnomePluginGnomeShellExtension* self,
                                                     GAsyncResult* _res_,
                                                     GError** error)
{
	gboolean result;
	GnomePluginGnomeShellExtensionInitAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
         * Initialize D-Bus proxy and fetch extension state
         */
static void
gnome_plugin_gnome_shell_extension_init_async_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	GnomePluginGnomeShellExtensionInitAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gnome_plugin_gnome_shell_extension_real_init_async_co (_data_);
}

static void
_gnome_plugin_gnome_shell_extension_on_extension_state_changed_gnome_shell_extensions_extension_state_changed (GnomeShellExtensions* _sender,
                                                                                                               const gchar* uuid,
                                                                                                               GHashTable* state,
                                                                                                               gpointer self)
{
	gnome_plugin_gnome_shell_extension_on_extension_state_changed ((GnomePluginGnomeShellExtension*) self, uuid, state);
}

static gboolean
gnome_plugin_gnome_shell_extension_real_init_async_co (GnomePluginGnomeShellExtensionInitAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		gnome_plugin_gnome_shell_extension_update (_data_->self, _data_->cancellable, gnome_plugin_gnome_shell_extension_init_async_ready, _data_);
		return FALSE;
		_state_1:
		gnome_plugin_gnome_shell_extension_update_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp0_ = g_error_new_literal (GNOME_PLUGIN_GNOME_SHELL_EXTENSION_ERROR, GNOME_PLUGIN_GNOME_SHELL_EXTENSION_ERROR_SYNC_ERROR, "Unable to fetch extension state");
		_data_->_inner_error0_ = _data_->_tmp0_;
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->shell_extensions_proxy;
	_data_->_tmp2_ = g_signal_connect_object (_data_->_tmp1_, "extension-state-changed", (GCallback) _gnome_plugin_gnome_shell_extension_on_extension_state_changed_gnome_shell_extensions_extension_state_changed, _data_->self, 0);
	_data_->self->priv->extension_state_changed_id = _data_->_tmp2_;
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
gnome_plugin_gnome_shell_extension_init_async (GnomePluginGnomeShellExtension* self,
                                               gint io_priority,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	GnomePluginGnomeShellExtensionClass* _klass_;
	_klass_ = GNOME_PLUGIN_GNOME_SHELL_EXTENSION_GET_CLASS (self);
	if (_klass_->init_async) {
		_klass_->init_async (self, io_priority, cancellable, _callback_, _user_data_);
	}
}

gboolean
gnome_plugin_gnome_shell_extension_init_finish (GnomePluginGnomeShellExtension* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GnomePluginGnomeShellExtensionClass* _klass_;
	_klass_ = GNOME_PLUGIN_GNOME_SHELL_EXTENSION_GET_CLASS (self);
	if (_klass_->init_finish) {
		return _klass_->init_finish (self, _res_, error);
	}
	return FALSE;
}

static void
gnome_plugin_gnome_shell_extension_do_update (GnomePluginGnomeShellExtension* self,
                                              GHashTable* data,
                                              GError** error)
{
	GnomeExtensionInfo extension_info = {0};
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GnomeExtensionInfo _tmp3_;
	GnomeExtensionState _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->_uuid;
	gnome_extension_info_init_deserialize (&extension_info, _tmp0_, data, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = extension_info;
	_tmp4_ = self->priv->_state;
	if (_tmp3_.state != _tmp4_) {
		_tmp2_ = TRUE;
	} else {
		GnomeExtensionInfo _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = extension_info;
		_tmp6_ = _tmp5_.path;
		_tmp7_ = self->priv->_path;
		_tmp2_ = g_strcmp0 (_tmp6_, _tmp7_) != 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GnomeExtensionInfo _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = extension_info;
		_tmp9_ = _tmp8_.version;
		_tmp10_ = self->priv->_version;
		_tmp1_ = g_strcmp0 (_tmp9_, _tmp10_) != 0;
	}
	if (_tmp1_) {
		GnomeExtensionInfo _tmp11_;
		g_object_freeze_notify ((GObject*) self);
		_tmp11_ = extension_info;
		if (_tmp11_.state != GNOME_EXTENSION_STATE_UNINSTALLED) {
			GnomeExtensionInfo _tmp12_;
			const gchar* _tmp13_;
			GnomeExtensionInfo _tmp14_;
			const gchar* _tmp15_;
			GnomeExtensionInfo _tmp16_;
			_tmp12_ = extension_info;
			_tmp13_ = _tmp12_.path;
			gnome_plugin_gnome_shell_extension_set_path (self, _tmp13_);
			_tmp14_ = extension_info;
			_tmp15_ = _tmp14_.version;
			gnome_plugin_gnome_shell_extension_set_version (self, _tmp15_);
			_tmp16_ = extension_info;
			gnome_plugin_gnome_shell_extension_set_state (self, _tmp16_.state);
		} else {
			GnomeExtensionInfo _tmp17_;
			_tmp17_ = extension_info;
			gnome_plugin_gnome_shell_extension_set_state (self, _tmp17_.state);
		}
		g_object_thaw_notify ((GObject*) self);
		g_signal_emit (self, gnome_plugin_gnome_shell_extension_signals[GNOME_PLUGIN_GNOME_SHELL_EXTENSION_STATE_CHANGED_SIGNAL], 0);
	}
	gnome_extension_info_destroy (&extension_info);
}

static void
gnome_plugin_gnome_shell_extension_update_data_free (gpointer _data)
{
	GnomePluginGnomeShellExtensionUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GnomePluginGnomeShellExtensionUpdateData, _data_);
}

static void
gnome_plugin_gnome_shell_extension_update (GnomePluginGnomeShellExtension* self,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GnomePluginGnomeShellExtensionUpdateData* _data_;
	GnomePluginGnomeShellExtension* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GnomePluginGnomeShellExtensionUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gnome_plugin_gnome_shell_extension_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	gnome_plugin_gnome_shell_extension_update_co (_data_);
}

static void
gnome_plugin_gnome_shell_extension_update_finish (GnomePluginGnomeShellExtension* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	GnomePluginGnomeShellExtensionUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
         * Fetch extension info/state
         */
static void
gnome_plugin_gnome_shell_extension_update_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	GnomePluginGnomeShellExtensionUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gnome_plugin_gnome_shell_extension_update_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
gnome_plugin_gnome_shell_extension_update_co (GnomePluginGnomeShellExtensionUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_uuid;
		g_debug ("gnome-shell-extension.vala:171: Fetching extension info of \"%s\"…", _data_->_tmp0_);
		_data_->_tmp2_ = _data_->self->priv->shell_extensions_proxy;
		_data_->_tmp3_ = _data_->self->priv->_uuid;
		_data_->_state_ = 1;
		gnome_shell_extensions_get_extension_info (_data_->_tmp2_, _data_->_tmp3_, _data_->cancellable, gnome_plugin_gnome_shell_extension_update_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = gnome_shell_extensions_get_extension_info_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_hash_table_unref0 (_data_->data);
		_data_->data = _data_->_tmp5_;
		_g_hash_table_unref0 (_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->_error_;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_warning ("gnome-shell-extension.vala:175: Error while fetching extension state: " \
"%s", _data_->_tmp7_);
		_data_->_tmp8_ = _data_->_error_;
		_data_->_tmp9_ = _g_error_copy0 (_data_->_tmp8_);
		_data_->_inner_error0_ = _data_->_tmp9_;
		_g_error_free0 (_data_->_error_);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_hash_table_unref0 (_data_->data);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp10_ = _data_->data;
		gnome_plugin_gnome_shell_extension_do_update (_data_->self, _data_->_tmp10_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1__error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->_vala1__error_;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_warning ("gnome-shell-extension.vala:183: Error while updating extension state: " \
"%s", _data_->_tmp12_);
		_data_->_tmp13_ = _data_->_vala1__error_;
		_data_->_tmp14_ = _g_error_copy0 (_data_->_tmp13_);
		_data_->_inner_error0_ = _data_->_tmp14_;
		_g_error_free0 (_data_->_vala1__error_);
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_hash_table_unref0 (_data_->data);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_hash_table_unref0 (_data_->data);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gnome_plugin_gnome_shell_extension_on_extension_state_changed (GnomePluginGnomeShellExtension* self,
                                                               const gchar* uuid,
                                                               GHashTable* data)
{
	const gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->_uuid;
	if (g_strcmp0 (uuid, _tmp0_) != 0) {
		return;
	}
	{
		gnome_plugin_gnome_shell_extension_do_update (self, data, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_warning ("gnome-shell-extension.vala:199: %s", _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
gnome_plugin_gnome_shell_extension_eval_script (GnomePluginGnomeShellExtension* self,
                                                const gchar* script,
                                                GError** error)
{
	gboolean success = FALSE;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	GnomeShell* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gboolean _tmp8_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (script != NULL);
	success = FALSE;
	_tmp0_ = g_strdup ("");
	_result_ = _tmp0_;
	_tmp1_ = self->priv->shell_proxy;
	_tmp2_ = string_replace (GNOME_PLUGIN_SCRIPT_WRAPPER, "${SCRIPT}", script);
	_tmp3_ = _tmp2_;
	gnome_shell_eval (_tmp1_, _tmp3_, &_tmp4_, &_tmp5_, &_inner_error0_);
	success = _tmp4_;
	_g_free0 (_result_);
	_result_ = _tmp5_;
	_g_free0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_result_);
		return;
	}
	_tmp6_ = _result_;
	if (g_strcmp0 (_tmp6_, "") != 0) {
		const gchar* _tmp7_;
		_tmp7_ = _result_;
		g_debug ("gnome-shell-extension.vala:214: Eval result: %s", _tmp7_);
	}
	if (success) {
		const gchar* _tmp9_;
		_tmp9_ = _result_;
		_tmp8_ = g_strcmp0 (_tmp9_, "null") == 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
	} else {
		const gchar* _tmp10_;
		GError* _tmp11_;
		_tmp10_ = _result_;
		_tmp11_ = g_error_new_literal (GNOME_PLUGIN_GNOME_SHELL_EXTENSION_ERROR, GNOME_PLUGIN_GNOME_SHELL_EXTENSION_ERROR_EVAL_ERROR, _tmp10_);
		_inner_error0_ = _tmp11_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_result_);
		return;
	}
	_g_free0 (_result_);
}

static void
gnome_plugin_gnome_shell_extension_load_data_free (gpointer _data)
{
	GnomePluginGnomeShellExtensionLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GnomePluginGnomeShellExtensionLoadData, _data_);
}

void
gnome_plugin_gnome_shell_extension_load (GnomePluginGnomeShellExtension* self,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GnomePluginGnomeShellExtensionLoadData* _data_;
	GnomePluginGnomeShellExtension* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GnomePluginGnomeShellExtensionLoadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gnome_plugin_gnome_shell_extension_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	gnome_plugin_gnome_shell_extension_load_co (_data_);
}

gboolean
gnome_plugin_gnome_shell_extension_load_finish (GnomePluginGnomeShellExtension* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	gboolean result;
	GnomePluginGnomeShellExtensionLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
         * GNOME Shell is not aware of freshly installed extensions.
         * Extension normally would be visible after logging out.
         * This function tries to load the extension the same way GNOME Shell does it.
         */
static void
gnome_plugin_gnome_shell_extension_load_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GnomePluginGnomeShellExtensionLoadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gnome_plugin_gnome_shell_extension_load_co (_data_);
}

static gboolean
gnome_plugin_gnome_shell_extension_load_co (GnomePluginGnomeShellExtensionLoadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->cancellable != NULL) {
		_data_->_tmp0_ = g_cancellable_is_cancelled (_data_->cancellable);
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_debug ("gnome-shell-extension.vala:236: Loading extension…");
	{
		_data_->_tmp1_ = _data_->self->priv->_uuid;
		_data_->_tmp2_ = string_replace (GNOME_PLUGIN_LOAD_SCRIPT, "${UUID}", _data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		gnome_plugin_gnome_shell_extension_eval_script (_data_->self, _data_->_tmp3_, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp3_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_state_ = 1;
		gnome_plugin_gnome_shell_extension_update (_data_->self, _data_->cancellable, gnome_plugin_gnome_shell_extension_load_ready, _data_);
		return FALSE;
		_state_1:
		gnome_plugin_gnome_shell_extension_update_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->_error_;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_warning ("gnome-shell-extension.vala:244: Failed to load extension: %s", _data_->_tmp5_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->priv->_state;
	_data_->result = _data_->_tmp6_ != GNOME_EXTENSION_STATE_UNINSTALLED;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gnome_plugin_gnome_shell_extension_reload_data_free (gpointer _data)
{
	GnomePluginGnomeShellExtensionReloadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GnomePluginGnomeShellExtensionReloadData, _data_);
}

void
gnome_plugin_gnome_shell_extension_reload (GnomePluginGnomeShellExtension* self,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GnomePluginGnomeShellExtensionReloadData* _data_;
	GnomePluginGnomeShellExtension* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GnomePluginGnomeShellExtensionReloadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gnome_plugin_gnome_shell_extension_reload_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	gnome_plugin_gnome_shell_extension_reload_co (_data_);
}

gboolean
gnome_plugin_gnome_shell_extension_reload_finish (GnomePluginGnomeShellExtension* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	gboolean result;
	GnomePluginGnomeShellExtensionReloadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
         * Try reloading the extension.
         *
         * Old version of the extension might be loaded.
         */
static void
gnome_plugin_gnome_shell_extension_reload_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	GnomePluginGnomeShellExtensionReloadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gnome_plugin_gnome_shell_extension_reload_co (_data_);
}

static gboolean
gnome_plugin_gnome_shell_extension_reload_co (GnomePluginGnomeShellExtensionReloadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->cancellable != NULL) {
		_data_->_tmp0_ = g_cancellable_is_cancelled (_data_->cancellable);
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_state;
	if (_data_->_tmp2_ == GNOME_EXTENSION_STATE_UNINSTALLED) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp3_ = _data_->self->priv->_path;
		_data_->_tmp1_ = g_strcmp0 (_data_->_tmp3_, "") == 0;
	}
	if (_data_->_tmp1_) {
		_data_->_state_ = 1;
		gnome_plugin_gnome_shell_extension_load (_data_->self, _data_->cancellable, gnome_plugin_gnome_shell_extension_reload_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = gnome_plugin_gnome_shell_extension_load_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->result = _data_->_tmp4_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->_path;
	_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
	_data_->previous_path = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->self->priv->_version;
	_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
	_data_->previous_version = _data_->_tmp8_;
	g_debug ("gnome-shell-extension.vala:268: Reloading extension…");
	{
		_data_->_tmp9_ = _data_->self->priv->_uuid;
		_data_->_tmp10_ = string_replace (GNOME_PLUGIN_RELOAD_SCRIPT, "${UUID}", _data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		gnome_plugin_gnome_shell_extension_eval_script (_data_->self, _data_->_tmp11_, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp11_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_state_ = 2;
		gnome_plugin_gnome_shell_extension_update (_data_->self, _data_->cancellable, gnome_plugin_gnome_shell_extension_reload_ready, _data_);
		return FALSE;
		_state_2:
		gnome_plugin_gnome_shell_extension_update_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->_error_;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		_data_->_tmp14_ = _data_->self->priv->_state;
		_data_->_tmp15_ = gnome_extension_state_to_string (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = _data_->previous_path;
		_data_->_tmp18_ = _data_->previous_version;
		g_warning ("gnome-shell-extension.vala:276: Failed to reload extension: %s, %s '%s" \
"' '%s'", _data_->_tmp13_, _data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_);
		_g_free0 (_data_->_tmp16_);
		_data_->_tmp19_ = _data_->_error_;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		_data_->_tmp21_ = g_error_new_literal (GNOME_PLUGIN_GNOME_SHELL_EXTENSION_ERROR, GNOME_PLUGIN_GNOME_SHELL_EXTENSION_ERROR_EVAL_ERROR, _data_->_tmp20_);
		_data_->_inner_error0_ = _data_->_tmp21_;
		_g_error_free0 (_data_->_error_);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->previous_version);
		_g_free0 (_data_->previous_path);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp23_ = _data_->self->priv->_path;
	_data_->_tmp24_ = _data_->previous_path;
	if (g_strcmp0 (_data_->_tmp23_, _data_->_tmp24_) != 0) {
		_data_->_tmp22_ = TRUE;
	} else {
		_data_->_tmp25_ = _data_->self->priv->_version;
		_data_->_tmp26_ = _data_->previous_version;
		_data_->_tmp22_ = g_strcmp0 (_data_->_tmp25_, _data_->_tmp26_) != 0;
	}
	_data_->result = _data_->_tmp22_;
	_g_free0 (_data_->previous_version);
	_g_free0 (_data_->previous_path);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gnome_plugin_gnome_shell_extension_enable_data_free (gpointer _data)
{
	GnomePluginGnomeShellExtensionEnableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GnomePluginGnomeShellExtensionEnableData, _data_);
}

void
gnome_plugin_gnome_shell_extension_enable (GnomePluginGnomeShellExtension* self,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GnomePluginGnomeShellExtensionEnableData* _data_;
	GnomePluginGnomeShellExtension* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GnomePluginGnomeShellExtensionEnableData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gnome_plugin_gnome_shell_extension_enable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	gnome_plugin_gnome_shell_extension_enable_co (_data_);
}

gboolean
gnome_plugin_gnome_shell_extension_enable_finish (GnomePluginGnomeShellExtension* self,
                                                  GAsyncResult* _res_)
{
	gboolean result;
	GnomePluginGnomeShellExtensionEnableData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
         * Try enabling the extension
         *
         * Will try loading the extension
         */
static void
gnome_plugin_gnome_shell_extension_enable_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	GnomePluginGnomeShellExtensionEnableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gnome_plugin_gnome_shell_extension_enable_co (_data_);
}

static gboolean
gnome_plugin_gnome_shell_extension_enable_co (GnomePluginGnomeShellExtensionEnableData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_path;
	if (g_strcmp0 (_data_->_tmp0_, "") == 0) {
		{
			_data_->_state_ = 1;
			gnome_plugin_gnome_shell_extension_load (_data_->self, NULL, gnome_plugin_gnome_shell_extension_enable_ready, _data_);
			return FALSE;
			_state_1:
			gnome_plugin_gnome_shell_extension_load_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp1_ = _data_->_error_;
			_data_->_tmp2_ = _data_->_tmp1_->message;
			g_warning ("gnome-shell-extension.vala:295: Error while loading extension: %s", _data_->_tmp2_);
			_g_error_free0 (_data_->_error_);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp3_ = _data_->self->priv->shell_extensions_proxy;
	_data_->_tmp4_ = gnome_shell_extensions_get_user_extensions_enabled (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	if (!_data_->_tmp5_) {
		g_warning ("gnome-shell-extension.vala:300: Extensions in GNOME Shell are currentl" \
"y disabled. Use Extensions app to enable extensions.");
	}
	g_debug ("gnome-shell-extension.vala:303: Enabling extension…");
	{
		_data_->_tmp6_ = _data_->self->priv->shell_extensions_proxy;
		_data_->_tmp7_ = _data_->self->priv->_uuid;
		_data_->_state_ = 2;
		gnome_shell_extensions_enable_extension (_data_->_tmp6_, _data_->_tmp7_, NULL, gnome_plugin_gnome_shell_extension_enable_ready, _data_);
		return FALSE;
		_state_2:
		gnome_shell_extensions_enable_extension_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_state_ = 3;
		gnome_plugin_gnome_shell_extension_update (_data_->self, _data_->cancellable, gnome_plugin_gnome_shell_extension_enable_ready, _data_);
		return FALSE;
		_state_3:
		gnome_plugin_gnome_shell_extension_update_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1__error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->_vala1__error_;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning ("gnome-shell-extension.vala:310: Error while enabling extension: %s", _data_->_tmp9_);
		_g_error_free0 (_data_->_vala1__error_);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->self->priv->_state;
	_data_->result = _data_->_tmp10_ == GNOME_EXTENSION_STATE_ENABLED;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gnome_plugin_gnome_shell_extension_disable_data_free (gpointer _data)
{
	GnomePluginGnomeShellExtensionDisableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GnomePluginGnomeShellExtensionDisableData, _data_);
}

void
gnome_plugin_gnome_shell_extension_disable (GnomePluginGnomeShellExtension* self,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GnomePluginGnomeShellExtensionDisableData* _data_;
	GnomePluginGnomeShellExtension* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GnomePluginGnomeShellExtensionDisableData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gnome_plugin_gnome_shell_extension_disable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	gnome_plugin_gnome_shell_extension_disable_co (_data_);
}

gboolean
gnome_plugin_gnome_shell_extension_disable_finish (GnomePluginGnomeShellExtension* self,
                                                   GAsyncResult* _res_)
{
	gboolean result;
	GnomePluginGnomeShellExtensionDisableData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
gnome_plugin_gnome_shell_extension_disable_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	GnomePluginGnomeShellExtensionDisableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gnome_plugin_gnome_shell_extension_disable_co (_data_);
}

static gboolean
gnome_plugin_gnome_shell_extension_disable_co (GnomePluginGnomeShellExtensionDisableData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->shell_extensions_proxy;
		_data_->_tmp1_ = _data_->self->priv->_uuid;
		_data_->_state_ = 1;
		gnome_shell_extensions_disable_extension (_data_->_tmp0_, _data_->_tmp1_, NULL, gnome_plugin_gnome_shell_extension_disable_ready, _data_);
		return FALSE;
		_state_1:
		gnome_shell_extensions_disable_extension_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_state_ = 2;
		gnome_plugin_gnome_shell_extension_update (_data_->self, _data_->cancellable, gnome_plugin_gnome_shell_extension_disable_ready, _data_);
		return FALSE;
		_state_2:
		gnome_plugin_gnome_shell_extension_update_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->_error_;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_warning ("gnome-shell-extension.vala:324: Error while disabling extension: %s", _data_->_tmp3_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->_state;
	_data_->result = _data_->_tmp4_ != GNOME_EXTENSION_STATE_ENABLED;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gnome_plugin_gnome_shell_extension_real_dispose (GObject* base)
{
	GnomePluginGnomeShellExtension * self;
	GApplication* _tmp1_;
	self = (GnomePluginGnomeShellExtension*) base;
	if (self->priv->extension_state_changed_id != ((gulong) 0)) {
		GnomeShellExtensions* _tmp0_;
		_tmp0_ = self->priv->shell_extensions_proxy;
		g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->extension_state_changed_id);
	}
	_tmp1_ = g_application_get_default ();
	g_application_withdraw_notification (_tmp1_, "extension");
	G_OBJECT_CLASS (gnome_plugin_gnome_shell_extension_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
}

const gchar*
gnome_plugin_gnome_shell_extension_get_uuid (GnomePluginGnomeShellExtension* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
gnome_plugin_gnome_shell_extension_set_uuid (GnomePluginGnomeShellExtension* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_plugin_gnome_shell_extension_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_plugin_gnome_shell_extension_properties[GNOME_PLUGIN_GNOME_SHELL_EXTENSION_UUID_PROPERTY]);
	}
}

const gchar*
gnome_plugin_gnome_shell_extension_get_path (GnomePluginGnomeShellExtension* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	result = _tmp0_;
	return result;
}

void
gnome_plugin_gnome_shell_extension_set_path (GnomePluginGnomeShellExtension* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_plugin_gnome_shell_extension_get_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_plugin_gnome_shell_extension_properties[GNOME_PLUGIN_GNOME_SHELL_EXTENSION_PATH_PROPERTY]);
	}
}

const gchar*
gnome_plugin_gnome_shell_extension_get_version (GnomePluginGnomeShellExtension* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_version;
	result = _tmp0_;
	return result;
}

void
gnome_plugin_gnome_shell_extension_set_version (GnomePluginGnomeShellExtension* self,
                                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_plugin_gnome_shell_extension_get_version (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_version);
		self->priv->_version = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_plugin_gnome_shell_extension_properties[GNOME_PLUGIN_GNOME_SHELL_EXTENSION_VERSION_PROPERTY]);
	}
}

GnomeExtensionState
gnome_plugin_gnome_shell_extension_get_state (GnomePluginGnomeShellExtension* self)
{
	GnomeExtensionState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
gnome_plugin_gnome_shell_extension_set_state (GnomePluginGnomeShellExtension* self,
                                              GnomeExtensionState value)
{
	GnomeExtensionState old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_plugin_gnome_shell_extension_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_plugin_gnome_shell_extension_properties[GNOME_PLUGIN_GNOME_SHELL_EXTENSION_STATE_PROPERTY]);
	}
}

static void
gnome_plugin_gnome_shell_extension_class_init (GnomePluginGnomeShellExtensionClass * klass,
                                               gpointer klass_data)
{
	gnome_plugin_gnome_shell_extension_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GnomePluginGnomeShellExtension_private_offset);
	((GnomePluginGnomeShellExtensionClass *) klass)->init_async = (void (*) (GnomePluginGnomeShellExtension*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) gnome_plugin_gnome_shell_extension_real_init_async;
	((GnomePluginGnomeShellExtensionClass *) klass)->init_finish = (gboolean (*) (GnomePluginGnomeShellExtension*, GAsyncResult*, GError**)) gnome_plugin_gnome_shell_extension_real_init_finish;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) gnome_plugin_gnome_shell_extension_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_gnome_plugin_gnome_shell_extension_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gnome_plugin_gnome_shell_extension_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_plugin_gnome_shell_extension_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PLUGIN_GNOME_SHELL_EXTENSION_UUID_PROPERTY, gnome_plugin_gnome_shell_extension_properties[GNOME_PLUGIN_GNOME_SHELL_EXTENSION_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PLUGIN_GNOME_SHELL_EXTENSION_PATH_PROPERTY, gnome_plugin_gnome_shell_extension_properties[GNOME_PLUGIN_GNOME_SHELL_EXTENSION_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PLUGIN_GNOME_SHELL_EXTENSION_VERSION_PROPERTY, gnome_plugin_gnome_shell_extension_properties[GNOME_PLUGIN_GNOME_SHELL_EXTENSION_VERSION_PROPERTY] = g_param_spec_string ("version", "version", "version", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PLUGIN_GNOME_SHELL_EXTENSION_STATE_PROPERTY, gnome_plugin_gnome_shell_extension_properties[GNOME_PLUGIN_GNOME_SHELL_EXTENSION_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", GNOME_TYPE_EXTENSION_STATE, GNOME_EXTENSION_STATE_UNINSTALLED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gnome_plugin_gnome_shell_extension_signals[GNOME_PLUGIN_GNOME_SHELL_EXTENSION_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gnome_plugin_gnome_shell_extension_g_async_initable_interface_init (GAsyncInitableIface * iface,
                                                                    gpointer iface_data)
{
	gnome_plugin_gnome_shell_extension_g_async_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init_async = (void (*) (GAsyncInitable*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) gnome_plugin_gnome_shell_extension_init_async;
	iface->init_finish = (gboolean (*) (GAsyncInitable*, GAsyncResult*, GError**)) gnome_plugin_gnome_shell_extension_init_finish;
}

static void
gnome_plugin_gnome_shell_extension_instance_init (GnomePluginGnomeShellExtension * self,
                                                  gpointer klass)
{
	self->priv = gnome_plugin_gnome_shell_extension_get_instance_private (self);
	self->priv->_state = GNOME_EXTENSION_STATE_UNINSTALLED;
	self->priv->extension_state_changed_id = (gulong) 0;
}

static void
gnome_plugin_gnome_shell_extension_finalize (GObject * obj)
{
	GnomePluginGnomeShellExtension * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION, GnomePluginGnomeShellExtension);
	_g_free0 (self->priv->_uuid);
	_g_free0 (self->priv->_path);
	_g_free0 (self->priv->_version);
	_g_object_unref0 (self->priv->shell_proxy);
	_g_object_unref0 (self->priv->shell_extensions_proxy);
	G_OBJECT_CLASS (gnome_plugin_gnome_shell_extension_parent_class)->finalize (obj);
}

GType
gnome_plugin_gnome_shell_extension_get_type (void)
{
	return gnome_plugin_gnome_shell_extension_type_id;
}

GType
gnome_plugin_gnome_shell_extension_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePluginGnomeShellExtensionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_plugin_gnome_shell_extension_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePluginGnomeShellExtension), 0, (GInstanceInitFunc) gnome_plugin_gnome_shell_extension_instance_init, NULL };
	static const GInterfaceInfo g_async_initable_info = { (GInterfaceInitFunc) gnome_plugin_gnome_shell_extension_g_async_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	gnome_plugin_gnome_shell_extension_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GnomePluginGnomeShellExtension", &g_define_type_info, 0);
	g_type_module_add_interface (module, gnome_plugin_gnome_shell_extension_type_id, g_async_initable_get_type (), &g_async_initable_info);
	GnomePluginGnomeShellExtension_private_offset = sizeof (GnomePluginGnomeShellExtensionPrivate);
	return gnome_plugin_gnome_shell_extension_type_id;
}

static void
_vala_gnome_plugin_gnome_shell_extension_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	GnomePluginGnomeShellExtension * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION, GnomePluginGnomeShellExtension);
	switch (property_id) {
		case GNOME_PLUGIN_GNOME_SHELL_EXTENSION_UUID_PROPERTY:
		g_value_set_string (value, gnome_plugin_gnome_shell_extension_get_uuid (self));
		break;
		case GNOME_PLUGIN_GNOME_SHELL_EXTENSION_PATH_PROPERTY:
		g_value_set_string (value, gnome_plugin_gnome_shell_extension_get_path (self));
		break;
		case GNOME_PLUGIN_GNOME_SHELL_EXTENSION_VERSION_PROPERTY:
		g_value_set_string (value, gnome_plugin_gnome_shell_extension_get_version (self));
		break;
		case GNOME_PLUGIN_GNOME_SHELL_EXTENSION_STATE_PROPERTY:
		g_value_set_enum (value, gnome_plugin_gnome_shell_extension_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gnome_plugin_gnome_shell_extension_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	GnomePluginGnomeShellExtension * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PLUGIN_TYPE_GNOME_SHELL_EXTENSION, GnomePluginGnomeShellExtension);
	switch (property_id) {
		case GNOME_PLUGIN_GNOME_SHELL_EXTENSION_UUID_PROPERTY:
		gnome_plugin_gnome_shell_extension_set_uuid (self, g_value_get_string (value));
		break;
		case GNOME_PLUGIN_GNOME_SHELL_EXTENSION_PATH_PROPERTY:
		gnome_plugin_gnome_shell_extension_set_path (self, g_value_get_string (value));
		break;
		case GNOME_PLUGIN_GNOME_SHELL_EXTENSION_VERSION_PROPERTY:
		gnome_plugin_gnome_shell_extension_set_version (self, g_value_get_string (value));
		break;
		case GNOME_PLUGIN_GNOME_SHELL_EXTENSION_STATE_PROPERTY:
		gnome_plugin_gnome_shell_extension_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

