/* screen-notification.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from screen-notification.vala, do not modify */

/*
 * Copyright (c) 2016 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *
 */

#include "gnome-pomodoro.h"
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>

#define POMODORO_SCREEN_NOTIFICATION_IDLE_TIME_TO_CLOSE ((guint) 600)
#define POMODORO_SCREEN_NOTIFICATION_MIN_DISPLAY_TIME ((guint) 500)
#define POMODORO_SCREEN_NOTIFICATION_FADE_IN_TIME ((guint) 180)
#define POMODORO_SCREEN_NOTIFICATION_FADE_OUT_TIME ((guint) 180)
#define POMODORO_SCREEN_NOTIFICATION_MOTION_DISTANCE_TO_CLOSE ((guint) 20)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POMODORO_SCREEN_NOTIFICATION_0_PROPERTY,
	POMODORO_SCREEN_NOTIFICATION_NUM_PROPERTIES
};
static GParamSpec* pomodoro_screen_notification_properties[POMODORO_SCREEN_NOTIFICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_region_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_region_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PomodoroScreenNotificationPrivate {
	GObject* idle_monitor;
	gboolean _close_on_activity;
	GtkLabel* minutes_label;
	GtkLabel* seconds_label;
	guint fade_in_timeout_id;
	guint fade_out_timeout_id;
	PomodoroTimer* timer;
	gulong timer_elapsed_id;
	guint close_on_activity_id;
	guint32 last_event_time;
	gdouble last_motion_x;
	gdouble last_motion_y;
	gboolean _pass_through;
};

static gint PomodoroScreenNotification_private_offset;
static gpointer pomodoro_screen_notification_parent_class = NULL;
static GtkBuildableIface * pomodoro_screen_notification_gtk_buildable_parent_iface = NULL;

static void pomodoro_screen_notification_unschedule_close_on_activity (PomodoroScreenNotification* self);
static void pomodoro_screen_notification_do_set_pass_through (PomodoroScreenNotification* self,
                                                       gboolean value);
static void pomodoro_screen_notification_real_realize (GtkWidget* base);
static gboolean pomodoro_screen_notification_get_pass_through (PomodoroScreenNotification* self);
static void pomodoro_screen_notification_real_parser_finished (GtkBuildable* base,
                                                        GtkBuilder* builder);
static void pomodoro_screen_notification_on_timer_state_changed (PomodoroScreenNotification* self);
static void pomodoro_screen_notification_on_timer_elapsed_notify (PomodoroScreenNotification* self);
static void _pomodoro_screen_notification_on_timer_elapsed_notify_g_object_notify (GObject* _sender,
                                                                            GParamSpec* pspec,
                                                                            gpointer self);
static void pomodoro_screen_notification_real_show (GtkWidget* base);
static void pomodoro_screen_notification_fade_in (PomodoroScreenNotification* self);
static void pomodoro_screen_notification_fade_out (PomodoroScreenNotification* self);
static gboolean pomodoro_screen_notification_on_fade_in_timeout (PomodoroScreenNotification* self);
static void pomodoro_screen_notification_set_pass_through (PomodoroScreenNotification* self,
                                                    gboolean value);
static gboolean pomodoro_screen_notification_on_fade_out_timeout (PomodoroScreenNotification* self);
static gboolean _pomodoro_screen_notification_on_fade_in_timeout_gsource_func (gpointer self);
static void pomodoro_screen_notification_schedule_close_on_activity (PomodoroScreenNotification* self);
static void pomodoro_screen_notification_set_close_on_activity (PomodoroScreenNotification* self,
                                                         gboolean value);
static gboolean _pomodoro_screen_notification_on_fade_out_timeout_gsource_func (gpointer self);
static guint32 pomodoro_screen_notification_get_idle_time (PomodoroScreenNotification* self);
static gboolean pomodoro_screen_notification_real_event (GtkWidget* base,
                                                  GdkEvent* event);
static gboolean pomodoro_screen_notification_get_close_on_activity (PomodoroScreenNotification* self);
static gboolean pomodoro_screen_notification_on_close_on_activity_timeout (PomodoroScreenNotification* self);
static gboolean _pomodoro_screen_notification_on_close_on_activity_timeout_gsource_func (gpointer self);
static GObject * pomodoro_screen_notification_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void _pomodoro_screen_notification_on_timer_state_changed_pomodoro_timer_state_changed (PomodoroTimer* _sender,
                                                                                        PomodoroTimerState* state,
                                                                                        PomodoroTimerState* previous_state,
                                                                                        gpointer self);
static void pomodoro_screen_notification_finalize (GObject * obj);
static GType pomodoro_screen_notification_get_type_once (void);
static void _vala_pomodoro_screen_notification_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_pomodoro_screen_notification_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
pomodoro_screen_notification_get_instance_private (PomodoroScreenNotification* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroScreenNotification_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pomodoro_screen_notification_do_set_pass_through (PomodoroScreenNotification* self,
                                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pass_through = value;
	self->priv->last_event_time = (guint32) (g_get_real_time () / 1000);
	self->priv->last_motion_x = -1.0;
	self->priv->last_motion_y = -1.0;
	if (value) {
		cairo_region_t* _tmp0_;
		cairo_region_t* _tmp1_;
		_tmp0_ = cairo_region_create ();
		_tmp1_ = _tmp0_;
		gtk_widget_input_shape_combine_region ((GtkWidget*) self, _tmp1_);
		_cairo_region_destroy0 (_tmp1_);
	} else {
		gtk_widget_input_shape_combine_region ((GtkWidget*) self, NULL);
	}
	if (gtk_widget_get_realized ((GtkWidget*) self)) {
		GdkWindow* window = NULL;
		GdkWindow* _tmp2_;
		GdkWindow* _tmp3_;
		GdkCursor* _tmp4_ = NULL;
		GdkCursor* cursor = NULL;
		GdkCursor* _tmp8_;
		GdkWindow* _tmp9_;
		GdkCursor* _tmp10_;
		_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		window = _tmp3_;
		if (value) {
			_g_object_unref0 (_tmp4_);
			_tmp4_ = NULL;
		} else {
			GdkWindow* _tmp5_;
			GdkDisplay* _tmp6_;
			GdkCursor* _tmp7_;
			_tmp5_ = window;
			_tmp6_ = gdk_window_get_display (_tmp5_);
			_tmp7_ = gdk_cursor_new_from_name (_tmp6_, "none");
			_g_object_unref0 (_tmp4_);
			_tmp4_ = _tmp7_;
		}
		_tmp8_ = _g_object_ref0 (_tmp4_);
		cursor = _tmp8_;
		_tmp9_ = window;
		_tmp10_ = cursor;
		gdk_window_set_cursor (_tmp9_, _tmp10_);
		_g_object_unref0 (cursor);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (window);
	}
}

static void
pomodoro_screen_notification_real_realize (GtkWidget* base)
{
	PomodoroScreenNotification * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (PomodoroScreenNotification*) base;
	GTK_WIDGET_CLASS (pomodoro_screen_notification_parent_class)->realize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp0_ = pomodoro_screen_notification_get_pass_through (self);
	_tmp1_ = _tmp0_;
	pomodoro_screen_notification_do_set_pass_through (self, _tmp1_);
}

static void
pomodoro_screen_notification_real_parser_finished (GtkBuildable* base,
                                                   GtkBuilder* builder)
{
	PomodoroScreenNotification * self;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	self = (PomodoroScreenNotification*) base;
	g_return_if_fail (builder != NULL);
	pomodoro_screen_notification_gtk_buildable_parent_iface->parser_finished ((GtkBuildable*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), builder);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_context = _tmp1_;
	gtk_style_context_add_class (style_context, "hidden");
	_g_object_unref0 (style_context);
}

static void
_pomodoro_screen_notification_on_timer_elapsed_notify_g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self)
{
	pomodoro_screen_notification_on_timer_elapsed_notify ((PomodoroScreenNotification*) self);
}

static void
pomodoro_screen_notification_on_timer_state_changed (PomodoroScreenNotification* self)
{
	PomodoroTimer* _tmp1_;
	PomodoroTimerState* _tmp2_;
	PomodoroTimerState* _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->timer_elapsed_id != ((gulong) 0)) {
		PomodoroTimer* _tmp0_;
		_tmp0_ = self->priv->timer;
		g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->timer_elapsed_id);
		self->priv->timer_elapsed_id = (gulong) 0;
	}
	_tmp1_ = self->priv->timer;
	_tmp2_ = pomodoro_timer_get_state (_tmp1_);
	_tmp3_ = _tmp2_;
	if (POMODORO_IS_BREAK_STATE (_tmp3_)) {
		PomodoroTimer* _tmp4_;
		gulong _tmp5_;
		_tmp4_ = self->priv->timer;
		_tmp5_ = g_signal_connect_object ((GObject*) _tmp4_, "notify::elapsed", (GCallback) _pomodoro_screen_notification_on_timer_elapsed_notify_g_object_notify, self, G_CONNECT_AFTER);
		self->priv->timer_elapsed_id = _tmp5_;
		pomodoro_screen_notification_on_timer_elapsed_notify (self);
	}
}

static void
pomodoro_screen_notification_on_timer_elapsed_notify (PomodoroScreenNotification* self)
{
	guint remaining = 0U;
	PomodoroTimer* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	guint minutes = 0U;
	guint seconds = 0U;
	GtkLabel* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkLabel* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_remaining (_tmp0_);
	_tmp2_ = _tmp1_;
	remaining = (guint) MAX (ceil (_tmp2_), 0.0);
	minutes = remaining / 60;
	seconds = remaining % 60;
	_tmp3_ = self->priv->minutes_label;
	_tmp4_ = g_strdup_printf ("%02u", minutes);
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->seconds_label;
	_tmp7_ = g_strdup_printf ("%02u", seconds);
	_tmp8_ = _tmp7_;
	gtk_label_set_label (_tmp6_, _tmp8_);
	_g_free0 (_tmp8_);
}

static void
pomodoro_screen_notification_real_show (GtkWidget* base)
{
	PomodoroScreenNotification * self;
	self = (PomodoroScreenNotification*) base;
	pomodoro_screen_notification_fade_in (self);
}

void
pomodoro_screen_notification_close (PomodoroScreenNotification* self)
{
	g_return_if_fail (self != NULL);
	pomodoro_screen_notification_fade_out (self);
}

static gboolean
pomodoro_screen_notification_on_fade_in_timeout (PomodoroScreenNotification* self)
{
	GObject* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->fade_in_timeout_id = (guint) 0;
	_tmp0_ = self->priv->idle_monitor;
	if (_tmp0_ == NULL) {
		pomodoro_screen_notification_set_pass_through (self, FALSE);
	}
	result = FALSE;
	return result;
}

static gboolean
pomodoro_screen_notification_on_fade_out_timeout (PomodoroScreenNotification* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->fade_out_timeout_id = (guint) 0;
	gtk_window_close (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	result = FALSE;
	return result;
}

static gboolean
_pomodoro_screen_notification_on_fade_in_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = pomodoro_screen_notification_on_fade_in_timeout ((PomodoroScreenNotification*) self);
	return result;
}

static void
pomodoro_screen_notification_fade_in (PomodoroScreenNotification* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkStyleContext* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GTK_WIDGET_CLASS (pomodoro_screen_notification_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	}
	gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_remove_class (_tmp2_, "hidden");
	pomodoro_screen_notification_set_pass_through (self, TRUE);
	if (self->priv->fade_in_timeout_id == ((guint) 0)) {
		self->priv->fade_in_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, POMODORO_SCREEN_NOTIFICATION_FADE_IN_TIME, _pomodoro_screen_notification_on_fade_in_timeout_gsource_func, g_object_ref (self), g_object_unref);
	}
	pomodoro_screen_notification_schedule_close_on_activity (self);
}

static gboolean
_pomodoro_screen_notification_on_fade_out_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = pomodoro_screen_notification_on_fade_out_timeout ((PomodoroScreenNotification*) self);
	return result;
}

static void
pomodoro_screen_notification_fade_out (PomodoroScreenNotification* self)
{
	GtkStyleContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "hidden");
	pomodoro_screen_notification_set_pass_through (self, TRUE);
	pomodoro_screen_notification_set_close_on_activity (self, FALSE);
	pomodoro_screen_notification_unschedule_close_on_activity (self);
	if (self->priv->fade_out_timeout_id == ((guint) 0)) {
		self->priv->fade_out_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, POMODORO_SCREEN_NOTIFICATION_FADE_OUT_TIME, _pomodoro_screen_notification_on_fade_out_timeout_gsource_func, g_object_ref (self), g_object_unref);
	}
}

static guint32
pomodoro_screen_notification_get_idle_time (PomodoroScreenNotification* self)
{
	guint32 _tmp0_ = 0U;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	if (self->priv->last_event_time != ((guint32) 0)) {
		_tmp0_ = gtk_get_current_event_time () - self->priv->last_event_time;
	} else {
		_tmp0_ = (guint32) 0;
	}
	result = _tmp0_;
	return result;
}

static gboolean
pomodoro_screen_notification_real_event (GtkWidget* base,
                                         GdkEvent* event)
{
	PomodoroScreenNotification * self;
	gboolean _tmp0_;
	guint32 event_time = 0U;
	guint32 idle_time = 0U;
	gboolean result;
	self = (PomodoroScreenNotification*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_close_on_activity;
	if (!_tmp0_) {
		result = GTK_WIDGET_CLASS (pomodoro_screen_notification_parent_class)->event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), event);
		return result;
	}
	event_time = gdk_event_get_time (event);
	idle_time = pomodoro_screen_notification_get_idle_time (self);
	switch (event->type) {
		case GDK_MOTION_NOTIFY:
		{
			GdkEventMotion* _tmp1_;
			GdkEventMotion* _tmp2_;
			gdouble _tmp3_ = 0.0;
			gdouble dx = 0.0;
			gdouble _tmp6_ = 0.0;
			gdouble dy = 0.0;
			gdouble distance = 0.0;
			GdkEventMotion* _tmp9_;
			GdkEventMotion* _tmp10_;
			GdkEventMotion* _tmp11_;
			GdkEventMotion* _tmp12_;
			_tmp1_ = (GdkEventMotion *) (event);
			_tmp2_ = _tmp1_;
			if (((gint) _tmp2_->is_hint) == 1) {
				result = TRUE;
				return result;
			}
			if (self->priv->last_motion_x >= 0.0) {
				GdkEventMotion* _tmp4_;
				GdkEventMotion* _tmp5_;
				_tmp4_ = (GdkEventMotion *) (event);
				_tmp5_ = _tmp4_;
				_tmp3_ = _tmp5_->x_root - self->priv->last_motion_x;
			} else {
				_tmp3_ = 0.0;
			}
			dx = _tmp3_;
			if (self->priv->last_motion_y >= 0.0) {
				GdkEventMotion* _tmp7_;
				GdkEventMotion* _tmp8_;
				_tmp7_ = (GdkEventMotion *) (event);
				_tmp8_ = _tmp7_;
				_tmp6_ = _tmp8_->y_root - self->priv->last_motion_y;
			} else {
				_tmp6_ = 0.0;
			}
			dy = _tmp6_;
			distance = (dx * dx) + (dy * dy);
			_tmp9_ = (GdkEventMotion *) (event);
			_tmp10_ = _tmp9_;
			self->priv->last_motion_x = _tmp10_->x_root;
			_tmp11_ = (GdkEventMotion *) (event);
			_tmp12_ = _tmp11_;
			self->priv->last_motion_y = _tmp12_->y_root;
			self->priv->last_event_time = event_time;
			if (distance > ((gdouble) (POMODORO_SCREEN_NOTIFICATION_MOTION_DISTANCE_TO_CLOSE * POMODORO_SCREEN_NOTIFICATION_MOTION_DISTANCE_TO_CLOSE))) {
				pomodoro_screen_notification_close (self);
			}
			break;
		}
		case GDK_BUTTON_PRESS:
		case GDK_KEY_PRESS:
		case GDK_TOUCH_BEGIN:
		{
			self->priv->last_event_time = event_time;
			if (idle_time > ((guint32) POMODORO_SCREEN_NOTIFICATION_IDLE_TIME_TO_CLOSE)) {
				pomodoro_screen_notification_close (self);
			}
			break;
		}
		case GDK_FOCUS_CHANGE:
		{
			self->priv->last_event_time = event_time;
			pomodoro_screen_notification_close (self);
			break;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}

static gboolean
pomodoro_screen_notification_on_close_on_activity_timeout (PomodoroScreenNotification* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->close_on_activity_id = (guint) 0;
	pomodoro_screen_notification_set_close_on_activity (self, TRUE);
	result = G_SOURCE_REMOVE;
	return result;
}

static void
pomodoro_screen_notification_unschedule_close_on_activity (PomodoroScreenNotification* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->close_on_activity_id != ((guint) 0)) {
		g_source_remove (self->priv->close_on_activity_id);
		self->priv->close_on_activity_id = (guint) 0;
	}
}

static gboolean
_pomodoro_screen_notification_on_close_on_activity_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = pomodoro_screen_notification_on_close_on_activity_timeout ((PomodoroScreenNotification*) self);
	return result;
}

static void
pomodoro_screen_notification_schedule_close_on_activity (PomodoroScreenNotification* self)
{
	g_return_if_fail (self != NULL);
	pomodoro_screen_notification_unschedule_close_on_activity (self);
	self->priv->close_on_activity_id = g_timeout_add_full (G_PRIORITY_DEFAULT, POMODORO_SCREEN_NOTIFICATION_MIN_DISPLAY_TIME, _pomodoro_screen_notification_on_close_on_activity_timeout_gsource_func, g_object_ref (self), g_object_unref);
}

PomodoroScreenNotification*
pomodoro_screen_notification_construct (GType object_type)
{
	PomodoroScreenNotification * self = NULL;
	self = (PomodoroScreenNotification*) g_object_new (object_type, NULL);
	return self;
}

PomodoroScreenNotification*
pomodoro_screen_notification_new (void)
{
	return pomodoro_screen_notification_construct (POMODORO_TYPE_SCREEN_NOTIFICATION);
}

static gboolean
pomodoro_screen_notification_get_pass_through (PomodoroScreenNotification* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pass_through;
	return result;
}

static void
pomodoro_screen_notification_set_pass_through (PomodoroScreenNotification* self,
                                               gboolean value)
{
	g_return_if_fail (self != NULL);
	pomodoro_screen_notification_do_set_pass_through (self, value);
}

static gboolean
pomodoro_screen_notification_get_close_on_activity (PomodoroScreenNotification* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_close_on_activity;
	return result;
}

static void
pomodoro_screen_notification_set_close_on_activity (PomodoroScreenNotification* self,
                                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_close_on_activity = value;
}

static void
_pomodoro_screen_notification_on_timer_state_changed_pomodoro_timer_state_changed (PomodoroTimer* _sender,
                                                                                   PomodoroTimerState* state,
                                                                                   PomodoroTimerState* previous_state,
                                                                                   gpointer self)
{
	pomodoro_screen_notification_on_timer_state_changed ((PomodoroScreenNotification*) self);
}

static GObject *
pomodoro_screen_notification_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroScreenNotification * self;
	PomodoroTimer* _tmp0_;
	PomodoroTimer* _tmp1_;
	parent_class = G_OBJECT_CLASS (pomodoro_screen_notification_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_SCREEN_NOTIFICATION, PomodoroScreenNotification);
	_tmp0_ = pomodoro_timer_get_default ();
	self->priv->timer = _tmp0_;
	_tmp1_ = self->priv->timer;
	g_signal_connect_object (_tmp1_, "state-changed", (GCallback) _pomodoro_screen_notification_on_timer_state_changed_pomodoro_timer_state_changed, self, 0);
	pomodoro_screen_notification_on_timer_state_changed (self);
	gtk_window_fullscreen ((GtkWindow*) self);
	gtk_window_stick ((GtkWindow*) self);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	return obj;
}

static void
pomodoro_screen_notification_class_init (PomodoroScreenNotificationClass * klass,
                                         gpointer klass_data)
{
	pomodoro_screen_notification_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroScreenNotification_private_offset);
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget*)) pomodoro_screen_notification_real_realize;
	((GtkWidgetClass *) klass)->show = (void (*) (GtkWidget*)) pomodoro_screen_notification_real_show;
	((GtkWidgetClass *) klass)->event = (gboolean (*) (GtkWidget*, GdkEvent*)) pomodoro_screen_notification_real_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_pomodoro_screen_notification_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pomodoro_screen_notification_set_property;
	G_OBJECT_CLASS (klass)->constructor = pomodoro_screen_notification_constructor;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_screen_notification_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/pomodoro/screen-notification.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "minutes_label", FALSE, PomodoroScreenNotification_private_offset + G_STRUCT_OFFSET (PomodoroScreenNotificationPrivate, minutes_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "seconds_label", FALSE, PomodoroScreenNotification_private_offset + G_STRUCT_OFFSET (PomodoroScreenNotificationPrivate, seconds_label));
}

static void
pomodoro_screen_notification_gtk_buildable_interface_init (GtkBuildableIface * iface,
                                                           gpointer iface_data)
{
	pomodoro_screen_notification_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
	iface->parser_finished = (void (*) (GtkBuildable*, GtkBuilder*)) pomodoro_screen_notification_real_parser_finished;
}

static void
pomodoro_screen_notification_instance_init (PomodoroScreenNotification * self,
                                            gpointer klass)
{
	self->priv = pomodoro_screen_notification_get_instance_private (self);
	self->priv->_close_on_activity = FALSE;
	self->priv->fade_in_timeout_id = (guint) 0;
	self->priv->fade_out_timeout_id = (guint) 0;
	self->priv->timer_elapsed_id = (gulong) 0;
	self->priv->close_on_activity_id = (guint) 0;
	self->priv->last_event_time = (guint32) 0;
	self->priv->last_motion_x = -1.0;
	self->priv->last_motion_y = -1.0;
	self->priv->_pass_through = TRUE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
pomodoro_screen_notification_finalize (GObject * obj)
{
	PomodoroScreenNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_SCREEN_NOTIFICATION, PomodoroScreenNotification);
	pomodoro_screen_notification_unschedule_close_on_activity (self);
	_g_object_unref0 (self->priv->idle_monitor);
	G_OBJECT_CLASS (pomodoro_screen_notification_parent_class)->finalize (obj);
}

/**
     * A fullscreen notification.
     *
     * If idle_monitor is available, window blocks input events after user becomes idle for 600ms.
     * Otherwise, delay blocking until window is shown.
     *
     */
static GType
pomodoro_screen_notification_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroScreenNotificationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_screen_notification_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroScreenNotification), 0, (GInstanceInitFunc) pomodoro_screen_notification_instance_init, NULL };
	static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) pomodoro_screen_notification_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType pomodoro_screen_notification_type_id;
	pomodoro_screen_notification_type_id = g_type_register_static (gtk_window_get_type (), "PomodoroScreenNotification", &g_define_type_info, 0);
	g_type_add_interface_static (pomodoro_screen_notification_type_id, gtk_buildable_get_type (), &gtk_buildable_info);
	PomodoroScreenNotification_private_offset = g_type_add_instance_private (pomodoro_screen_notification_type_id, sizeof (PomodoroScreenNotificationPrivate));
	return pomodoro_screen_notification_type_id;
}

GType
pomodoro_screen_notification_get_type (void)
{
	static volatile gsize pomodoro_screen_notification_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_screen_notification_type_id__once)) {
		GType pomodoro_screen_notification_type_id;
		pomodoro_screen_notification_type_id = pomodoro_screen_notification_get_type_once ();
		g_once_init_leave (&pomodoro_screen_notification_type_id__once, pomodoro_screen_notification_type_id);
	}
	return pomodoro_screen_notification_type_id__once;
}

static void
_vala_pomodoro_screen_notification_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	PomodoroScreenNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_SCREEN_NOTIFICATION, PomodoroScreenNotification);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pomodoro_screen_notification_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	PomodoroScreenNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_SCREEN_NOTIFICATION, PomodoroScreenNotification);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

