/* stats-page.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from stats-page.vala, do not modify */

/*
 * Copyright (c) 2017 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gom/gom.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include "gnome-pomodoro.h"

#define POMODORO_STATS_PAGE_GUIDES_OFFSET 5.0
#define POMODORO_STATS_PAGE_GUIDES_WIDTH 40.0
#define POMODORO_STATS_PAGE_CHART_PADDING 20.0
#define POMODORO_STATS_PAGE_LABEL_HEIGHT 20.0
#define POMODORO_STATS_PAGE_LABEL_OFFSET 10.0
#define POMODORO_STATS_PAGE_BAR_MAX_WIDTH 130.0
#define POMODORO_STATS_PAGE_BAR_RELATIVE_WIDTH 0.85
#define POMODORO_STATS_PAGE_BAR_BORDER_RADIUS 2.5
#define POMODORO_AGGREGATED_ENTRY_DATE_FORMAT "%Y-%m-%d"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define POMODORO_TYPE_STATS_PAGE (pomodoro_stats_page_get_type ())
#define POMODORO_STATS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POMODORO_TYPE_STATS_PAGE, PomodoroStatsPage))
#define POMODORO_STATS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POMODORO_TYPE_STATS_PAGE, PomodoroStatsPageClass))
#define POMODORO_IS_STATS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POMODORO_TYPE_STATS_PAGE))
#define POMODORO_IS_STATS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POMODORO_TYPE_STATS_PAGE))
#define POMODORO_STATS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POMODORO_TYPE_STATS_PAGE, PomodoroStatsPageClass))

typedef struct _PomodoroStatsPage PomodoroStatsPage;
typedef struct _PomodoroStatsPageClass PomodoroStatsPageClass;
typedef struct _PomodoroStatsPagePrivate PomodoroStatsPagePrivate;

#define POMODORO_STATS_PAGE_TYPE_DATA (pomodoro_stats_page_data_get_type ())
typedef struct _PomodoroStatsPageData PomodoroStatsPageData;
enum  {
	POMODORO_STATS_PAGE_0_PROPERTY,
	POMODORO_STATS_PAGE_DATE_PROPERTY,
	POMODORO_STATS_PAGE_DATE_END_PROPERTY,
	POMODORO_STATS_PAGE_TITLE_PROPERTY,
	POMODORO_STATS_PAGE_NUM_PROPERTIES
};
static GParamSpec* pomodoro_stats_page_properties[POMODORO_STATS_PAGE_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef void (*PomodoroStatsPageDrawChartFunc) (cairo_t* context, gdouble* values, gint values_length1, gdouble x, gdouble y, gdouble width, gdouble height, gpointer user_data);
#define _pomodoro_stats_page_data_free0(var) ((var == NULL) ? NULL : (var = (pomodoro_stats_page_data_free (var), NULL)))
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;

#define POMODORO_TYPE_AGGREGATED_ENTRY (pomodoro_aggregated_entry_get_type ())
#define POMODORO_AGGREGATED_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POMODORO_TYPE_AGGREGATED_ENTRY, PomodoroAggregatedEntry))
#define POMODORO_AGGREGATED_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POMODORO_TYPE_AGGREGATED_ENTRY, PomodoroAggregatedEntryClass))
#define POMODORO_IS_AGGREGATED_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POMODORO_TYPE_AGGREGATED_ENTRY))
#define POMODORO_IS_AGGREGATED_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POMODORO_TYPE_AGGREGATED_ENTRY))
#define POMODORO_AGGREGATED_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POMODORO_TYPE_AGGREGATED_ENTRY, PomodoroAggregatedEntryClass))

typedef struct _PomodoroAggregatedEntry PomodoroAggregatedEntry;
typedef struct _PomodoroAggregatedEntryClass PomodoroAggregatedEntryClass;
typedef struct _Block18Data Block18Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PomodoroStatsPageFetchData PomodoroStatsPageFetchData;
typedef struct _PomodoroStatsPageGetReferenceValueData PomodoroStatsPageGetReferenceValueData;

struct _PomodoroStatsPage {
	GtkBox parent_instance;
	PomodoroStatsPagePrivate * priv;
	GtkSpinner* spinner;
	GtkDrawingArea* timeline_chart;
	GtkDrawingArea* totals_chart;
	GDateTime* _date;
	GomRepository* repository;
	guint64 reference_value;
	guint64 daily_reference_value;
};

struct _PomodoroStatsPageClass {
	GtkBoxClass parent_class;
	gchar* (*format_datetime) (PomodoroStatsPage* self, GDateTime* date);
	GDateTime* (*get_previous_date) (PomodoroStatsPage* self);
	GDateTime* (*get_next_date) (PomodoroStatsPage* self);
	void (*get_reference_value) (PomodoroStatsPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint64 (*get_reference_value_finish) (PomodoroStatsPage* self, GAsyncResult* _res_);
};

struct _PomodoroStatsPageData {
	gint64 pomodoro_elapsed;
	gint64 break_elapsed;
};

struct _PomodoroStatsPagePrivate {
	GDateTime* _date_end;
	gchar* _title;
	GHashTable* days;
};

struct _Block16Data {
	int _ref_count_;
	PomodoroStatsPage* self;
	PomodoroStatsPageData totals;
};

struct _Block17Data {
	int _ref_count_;
	PomodoroStatsPage* self;
	guint64 reference_value;
	gint64 daily_reference_value;
	gpointer _async_data_;
};

struct _Block18Data {
	int _ref_count_;
	Block17Data * _data17_;
	GomResourceGroup* group;
};

struct _PomodoroStatsPageFetchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PomodoroStatsPage* self;
	Block17Data* _data17_;
	GHashTable* _tmp0_;
	gchar* date_start;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	gchar* date_end;
	GDateTime* _tmp4_;
	gchar* _tmp5_;
	GomFilter* filter;
	GValue _tmp6_;
	GomFilter* _tmp7_;
	GomFilter* _tmp8_;
	GValue _tmp9_;
	GomFilter* _tmp10_;
	GomFilter* _tmp11_;
	GomFilter* _tmp12_;
	GomFilter* _tmp13_;
	GomRepository* _tmp14_;
	GomFilter* _tmp15_;
};

struct _PomodoroStatsPageGetReferenceValueData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PomodoroStatsPage* self;
	guint64 result;
};

static gint PomodoroStatsPage_private_offset;
static gpointer pomodoro_stats_page_parent_class = NULL;
static GtkBuildableIface * pomodoro_stats_page_gtk_buildable_parent_iface = NULL;

VALA_EXTERN GType pomodoro_stats_page_get_type (void) G_GNUC_CONST ;
static GType pomodoro_stats_page_data_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PomodoroStatsPageData* pomodoro_stats_page_data_dup (const PomodoroStatsPageData* self);
static void pomodoro_stats_page_data_free (PomodoroStatsPageData* self);
VALA_EXTERN gchar* pomodoro_stats_page_format_datetime (PomodoroStatsPage* self,
                                            GDateTime* date);
VALA_EXTERN GDateTime* pomodoro_stats_page_get_previous_date (PomodoroStatsPage* self);
VALA_EXTERN GDateTime* pomodoro_stats_page_get_next_date (PomodoroStatsPage* self);
VALA_EXTERN void pomodoro_stats_page_get_reference_value (PomodoroStatsPage* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN guint64 pomodoro_stats_page_get_reference_value_finish (PomodoroStatsPage* self,
                                                        GAsyncResult* _res_);
static gchar* pomodoro_stats_page_format_value (gint64 seconds);
static gchar* pomodoro_stats_page_format_day_of_month (GDateTime* date);
static gchar* pomodoro_stats_page_format_day_of_week (GDateTime* date);
static void pomodoro_stats_page_draw_label (cairo_t* context,
                                     const gchar* label,
                                     gdouble x,
                                     gdouble y,
                                     gdouble width,
                                     gdouble height);
static void pomodoro_stats_page_draw_guide_lines (cairo_t* context,
                                           gdouble reference_value,
                                           gdouble x,
                                           gdouble y,
                                           gdouble width,
                                           gdouble height,
                                           GdkRGBA* color);
static void pomodoro_stats_page_draw_bar (cairo_t* context,
                                   gdouble value,
                                   gdouble x,
                                   gdouble y,
                                   gdouble width,
                                   gdouble height);
static void pomodoro_stats_page_draw_bar_chart (cairo_t* context,
                                         gdouble* values,
                                         gint values_length1,
                                         gdouble x,
                                         gdouble y,
                                         gdouble width,
                                         gdouble height);
static void pomodoro_stats_page_draw_line_chart (cairo_t* context,
                                          gdouble* values,
                                          gint values_length1,
                                          gdouble x,
                                          gdouble y,
                                          gdouble width,
                                          gdouble height);
static gboolean pomodoro_stats_page_on_timeline_chart_draw (PomodoroStatsPage* self,
                                                     GtkWidget* widget,
                                                     cairo_t* context);
VALA_EXTERN GDateTime* pomodoro_stats_page_get_date_end (PomodoroStatsPage* self);
VALA_EXTERN GDateTime* pomodoro_stats_page_get_date (PomodoroStatsPage* self);
static gboolean _pomodoro_stats_page_on_timeline_chart_draw_gtk_widget_draw (GtkWidget* _sender,
                                                                      cairo_t* cr,
                                                                      gpointer self);
static gboolean pomodoro_stats_page_on_totals_chart_draw (PomodoroStatsPage* self,
                                                   GtkWidget* widget,
                                                   cairo_t* context);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void __lambda9_ (Block16Data* _data16_,
                 const gchar* date_string,
                 PomodoroStatsPageData* data);
static void ___lambda9__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static gboolean _pomodoro_stats_page_on_totals_chart_draw_gtk_widget_draw (GtkWidget* _sender,
                                                                    cairo_t* cr,
                                                                    gpointer self);
VALA_EXTERN void pomodoro_stats_page_update (PomodoroStatsPage* self);
VALA_EXTERN void pomodoro_stats_page_set_date_end (PomodoroStatsPage* self,
                                       GDateTime* value);
VALA_EXTERN void pomodoro_stats_page_fetch (PomodoroStatsPage* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN void pomodoro_stats_page_fetch_finish (PomodoroStatsPage* self,
                                       GAsyncResult* _res_);
static void __lambda12_ (PomodoroStatsPage* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda12__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void pomodoro_stats_page_fetch_data_free (gpointer _data);
static gboolean pomodoro_stats_page_fetch_co (PomodoroStatsPageFetchData* _data_);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
VALA_EXTERN GType pomodoro_aggregated_entry_get_type (void) G_GNUC_CONST ;
static void pomodoro_stats_page_fetch_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
VALA_EXTERN void pomodoro_aggregated_entry_get_baseline_daily_elapsed (GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
VALA_EXTERN gint64 pomodoro_aggregated_entry_get_baseline_daily_elapsed_finish (GAsyncResult* _res_);
static void __lambda10_ (Block17Data* _data17_,
                  GObject* obj,
                  GAsyncResult* res);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void ____lambda11_ (Block18Data* _data18_,
                    GObject* obj,
                    GAsyncResult* res);
VALA_EXTERN const gchar* pomodoro_aggregated_entry_get_date_string (PomodoroAggregatedEntry* self);
VALA_EXTERN const gchar* pomodoro_aggregated_entry_get_state_name (PomodoroAggregatedEntry* self);
VALA_EXTERN gint64 pomodoro_aggregated_entry_get_elapsed (PomodoroAggregatedEntry* self);
static void _____lambda11__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gchar* pomodoro_stats_page_real_format_datetime (PomodoroStatsPage* self,
                                                 GDateTime* date);
static GDateTime* pomodoro_stats_page_real_get_previous_date (PomodoroStatsPage* self);
static GDateTime* pomodoro_stats_page_real_get_next_date (PomodoroStatsPage* self);
static void pomodoro_stats_page_real_get_reference_value_data_free (gpointer _data);
static void pomodoro_stats_page_real_get_reference_value (PomodoroStatsPage* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean pomodoro_stats_page_real_get_reference_value_co (PomodoroStatsPageGetReferenceValueData* _data_);
VALA_EXTERN PomodoroStatsPage* pomodoro_stats_page_construct (GType object_type);
VALA_EXTERN void pomodoro_stats_page_set_date (PomodoroStatsPage* self,
                                   GDateTime* value);
VALA_EXTERN void pomodoro_stats_page_set_title (PomodoroStatsPage* self,
                                    const gchar* value);
VALA_EXTERN const gchar* pomodoro_stats_page_get_title (PomodoroStatsPage* self);
static GObject * pomodoro_stats_page_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _pomodoro_stats_page_data_free0_ (gpointer var);
static void pomodoro_stats_page_finalize (GObject * obj);
static GType pomodoro_stats_page_get_type_once (void);
static void _vala_pomodoro_stats_page_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_pomodoro_stats_page_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
pomodoro_stats_page_get_instance_private (PomodoroStatsPage* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroStatsPage_private_offset);
}

static gchar*
pomodoro_stats_page_format_value (gint64 seconds)
{
	gdouble part_hours = 0.0;
	gchar* _tmp2_;
	gchar* result;
	if (seconds < ((gint64) 3600)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup_printf (_ ("%d m"), ((gint) seconds) / 60);
		result = _tmp0_;
		return result;
	}
	part_hours = round (seconds / 360.0);
	if ((((gint) part_hours) % 10) == 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf (_ ("%.0f h"), part_hours / 10.0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_strdup_printf (_ ("%.1f h"), part_hours / 10.0);
	result = _tmp2_;
	return result;
}

static gchar*
pomodoro_stats_page_format_day_of_month (GDateTime* date)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (date != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%i", g_date_time_get_day_of_month (date));
	result = _tmp0_;
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static gchar*
pomodoro_stats_page_format_day_of_week (GDateTime* date)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (date != NULL, NULL);
	_tmp0_ = g_date_time_format (date, "%A");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_unichar_to_string (g_unichar_toupper (string_get_char (_tmp1_, (glong) 0)));
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
         * Helper method to draw text centered inside a specified box
         */
static void
pomodoro_stats_page_draw_label (cairo_t* context,
                                const gchar* label,
                                gdouble x,
                                gdouble y,
                                gdouble width,
                                gdouble height)
{
	cairo_text_extents_t extents = {0};
	cairo_text_extents_t _tmp0_ = {0};
	cairo_text_extents_t _tmp1_;
	cairo_text_extents_t _tmp2_;
	cairo_text_extents_t _tmp3_;
	cairo_text_extents_t _tmp4_;
	g_return_if_fail (context != NULL);
	g_return_if_fail (label != NULL);
	cairo_text_extents (context, label, &_tmp0_);
	extents = _tmp0_;
	_tmp1_ = extents;
	_tmp2_ = extents;
	_tmp3_ = extents;
	_tmp4_ = extents;
	cairo_move_to (context, (x + (width * 0.5)) - ((_tmp1_.width * 0.5) + _tmp2_.x_bearing), (y + (height * 0.5)) - ((_tmp3_.height * 0.5) + _tmp4_.y_bearing));
	cairo_show_text (context, label);
}

/**
         * Helper method to draw grid lines with labels, all relative to reference_value.
         */
static void
pomodoro_stats_page_draw_guide_lines (cairo_t* context,
                                      gdouble reference_value,
                                      gdouble x,
                                      gdouble y,
                                      gdouble width,
                                      gdouble height,
                                      GdkRGBA* color)
{
	cairo_text_extents_t extents = {0};
	gint lines = 0;
	gdouble line_value = 0.0;
	gchar* line_label = NULL;
	gchar* _tmp0_;
	gdouble line_x = 0.0;
	gdouble line_y = 0.0;
	gdouble unit = 0.0;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	g_return_if_fail (context != NULL);
	g_return_if_fail (color != NULL);
	if (reference_value <= 0.0) {
		return;
	}
	lines = MAX (1, (gint) floor (height / 135.0));
	line_value = 0.0;
	_tmp0_ = pomodoro_stats_page_format_value ((gint64) line_value);
	line_label = _tmp0_;
	line_x = x;
	line_y = floor (y + height);
	unit = exp2 (floor (log2 ((reference_value / ((gdouble) (lines + 1))) / 3600.0))) * 3600.0;
	cairo_set_line_width (context, 1.0);
	_tmp1_ = *color;
	_tmp2_ = *color;
	_tmp3_ = *color;
	_tmp4_ = *color;
	cairo_set_source_rgba (context, _tmp1_.red, _tmp2_.green, _tmp3_.blue, _tmp4_.alpha * 0.30);
	cairo_move_to (context, line_x, line_y + 0.5);
	cairo_rel_line_to (context, width, 0.0);
	cairo_stroke (context);
	cairo_select_font_face (context, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL);
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gchar* _tmp7_;
				GdkRGBA _tmp8_;
				GdkRGBA _tmp9_;
				GdkRGBA _tmp10_;
				GdkRGBA _tmp11_;
				const gchar* _tmp12_;
				cairo_text_extents_t _tmp13_ = {0};
				cairo_text_extents_t _tmp14_;
				cairo_text_extents_t _tmp15_;
				cairo_text_extents_t _tmp16_;
				cairo_text_extents_t _tmp17_;
				GdkRGBA _tmp18_;
				GdkRGBA _tmp19_;
				GdkRGBA _tmp20_;
				GdkRGBA _tmp21_;
				const gchar* _tmp22_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = index;
					index = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(index < lines)) {
					break;
				}
				line_value += unit;
				_tmp7_ = pomodoro_stats_page_format_value ((gint64) line_value);
				_g_free0 (line_label);
				line_label = _tmp7_;
				line_y = floor ((y + height) - ((height * line_value) / reference_value));
				cairo_move_to (context, line_x, line_y + 0.5);
				cairo_rel_line_to (context, width, 0.0);
				_tmp8_ = *color;
				_tmp9_ = *color;
				_tmp10_ = *color;
				_tmp11_ = *color;
				cairo_set_source_rgba (context, _tmp8_.red, _tmp9_.green, _tmp10_.blue, _tmp11_.alpha * 0.10);
				cairo_stroke (context);
				_tmp12_ = line_label;
				cairo_text_extents (context, _tmp12_, &_tmp13_);
				extents = _tmp13_;
				_tmp14_ = extents;
				_tmp15_ = extents;
				_tmp16_ = extents;
				_tmp17_ = extents;
				cairo_move_to (context, ((line_x - _tmp14_.width) - _tmp15_.x_bearing) - POMODORO_STATS_PAGE_GUIDES_OFFSET, ((line_y - (_tmp16_.height * 0.5)) - _tmp17_.y_bearing) - 1.0);
				_tmp18_ = *color;
				_tmp19_ = *color;
				_tmp20_ = *color;
				_tmp21_ = *color;
				cairo_set_source_rgba (context, _tmp18_.red, _tmp19_.green, _tmp20_.blue, _tmp21_.alpha * 0.3);
				_tmp22_ = line_label;
				cairo_show_text (context, _tmp22_);
			}
		}
	}
	_g_free0 (line_label);
}

/**
         * Helper method to draw a single bar. It only draws paths without filling.
         */
static void
pomodoro_stats_page_draw_bar (cairo_t* context,
                              gdouble value,
                              gdouble x,
                              gdouble y,
                              gdouble width,
                              gdouble height)
{
	gdouble value_y = 0.0;
	gdouble value_height = 0.0;
	g_return_if_fail (context != NULL);
	value_y = round ((y + height) - (value * height));
	value_height = (y + height) - value_y;
	cairo_new_sub_path (context);
	if (value_height >= POMODORO_STATS_PAGE_BAR_BORDER_RADIUS) {
		cairo_move_to (context, x, y + height);
		cairo_arc (context, x + POMODORO_STATS_PAGE_BAR_BORDER_RADIUS, value_y + POMODORO_STATS_PAGE_BAR_BORDER_RADIUS, POMODORO_STATS_PAGE_BAR_BORDER_RADIUS, G_PI, 1.5 * G_PI);
		cairo_arc (context, (x + width) - POMODORO_STATS_PAGE_BAR_BORDER_RADIUS, value_y + POMODORO_STATS_PAGE_BAR_BORDER_RADIUS, POMODORO_STATS_PAGE_BAR_BORDER_RADIUS, (-0.5) * G_PI, 0.0);
		cairo_line_to (context, x + width, y + height);
	} else {
		if (value_height != 0.0) {
			cairo_matrix_t matrix = {0};
			cairo_matrix_t _tmp0_ = {0};
			cairo_matrix_t _tmp1_;
			cairo_get_matrix (context, &_tmp0_);
			matrix = _tmp0_;
			cairo_translate (context, 0.0, value_y + value_height);
			cairo_scale (context, 1.0, (value * height) / POMODORO_STATS_PAGE_BAR_BORDER_RADIUS);
			cairo_arc (context, x + POMODORO_STATS_PAGE_BAR_BORDER_RADIUS, 0.0, POMODORO_STATS_PAGE_BAR_BORDER_RADIUS, G_PI, 1.5 * G_PI);
			cairo_arc (context, (x + width) - POMODORO_STATS_PAGE_BAR_BORDER_RADIUS, 0.0, POMODORO_STATS_PAGE_BAR_BORDER_RADIUS, (-0.5) * G_PI, 0.0);
			_tmp1_ = matrix;
			cairo_set_matrix (context, &_tmp1_);
		}
	}
	cairo_close_path (context);
}

/**
         * Method for drawing values as bar chart.
         */
static void
pomodoro_stats_page_draw_bar_chart (cairo_t* context,
                                    gdouble* values,
                                    gint values_length1,
                                    gdouble x,
                                    gdouble y,
                                    gdouble width,
                                    gdouble height)
{
	g_return_if_fail (context != NULL);
	if (values_length1 > 1) {
		gdouble segment_width = 0.0;
		gdouble bar_x = 0.0;
		gdouble bar_y = 0.0;
		gdouble bar_width = 0.0;
		gdouble bar_height = 0.0;
		segment_width = width / ((gdouble) values_length1);
		bar_x = 0.0;
		bar_y = y;
		bar_width = 0.0;
		bar_height = height;
		bar_width = MIN (floor (segment_width * POMODORO_STATS_PAGE_BAR_RELATIVE_WIDTH), POMODORO_STATS_PAGE_BAR_MAX_WIDTH);
		bar_x = x + floor ((segment_width - bar_width) / 2.0);
		{
			gint index = 0;
			index = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					gdouble _tmp2_;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = index;
						index = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					if (!(index < values_length1)) {
						break;
					}
					_tmp2_ = values[index];
					pomodoro_stats_page_draw_bar (context, _tmp2_, bar_x + (segment_width * ((gdouble) index)), bar_y, bar_width, bar_height);
				}
			}
		}
	}
}

/**
         * Method for drawing values as smooth line chart.
         */
static void
pomodoro_stats_page_draw_line_chart (cairo_t* context,
                                     gdouble* values,
                                     gint values_length1,
                                     gdouble x,
                                     gdouble y,
                                     gdouble width,
                                     gdouble height)
{
	g_return_if_fail (context != NULL);
	if (values_length1 > 1) {
		gdouble segment_width = 0.0;
		gdouble x0 = 0.0;
		gdouble y0 = 0.0;
		gdouble x1 = 0.0;
		gdouble y1 = 0.0;
		gdouble x2 = 0.0;
		gdouble y2 = 0.0;
		gdouble x3 = 0.0;
		gdouble y3 = 0.0;
		gdouble x6 = 0.0;
		gdouble y6 = 0.0;
		gdouble slope0 = 0.0;
		gdouble slope3 = 0.0;
		segment_width = width / ((gdouble) (values_length1 - 1));
		x0 = x - segment_width;
		y0 = y + height;
		x1 = 0.0;
		y1 = 0.0;
		x2 = 0.0;
		y2 = 0.0;
		x3 = 0.0;
		y3 = 0.0;
		x6 = 0.0;
		y6 = 0.0;
		slope0 = 0.0;
		slope3 = 0.0;
		cairo_new_path (context);
		cairo_move_to (context, x0, y0);
		{
			gint index = 0;
			index = -1;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					gdouble _tmp2_ = 0.0;
					gdouble _tmp4_ = 0.0;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = index;
						index = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					if (!(index < values_length1)) {
						break;
					}
					x3 = x0 + segment_width;
					if ((index + 1) < values_length1) {
						gdouble _tmp3_;
						_tmp3_ = values[index + 1];
						_tmp2_ = _tmp3_;
					} else {
						_tmp2_ = 0.0;
					}
					y3 = y + (height * (1.0 - _tmp2_));
					x6 = x3 + segment_width;
					if ((index + 2) < values_length1) {
						gdouble _tmp5_;
						_tmp5_ = values[index + 2];
						_tmp4_ = _tmp5_;
					} else {
						_tmp4_ = 0.0;
					}
					y6 = y + (height * (1.0 - _tmp4_));
					slope3 = (y6 - y0) / (x6 - x0);
					x1 = x0 + ((x3 - x0) * 0.5);
					y1 = y0 + (slope0 * (x1 - x0));
					x2 = x3 - ((x3 - x0) * 0.5);
					y2 = y3 + (slope3 * (x2 - x3));
					cairo_curve_to (context, x1, y1, x2, y2, x3, y3);
					x0 = x3;
					y0 = y3;
					slope0 = slope3;
				}
			}
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_pomodoro_stats_page_data_dup0 (gpointer self)
{
	return self ? pomodoro_stats_page_data_dup (self) : NULL;
}

static gboolean
pomodoro_stats_page_on_timeline_chart_draw (PomodoroStatsPage* self,
                                            GtkWidget* widget,
                                            cairo_t* context)
{
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gdouble width = 0.0;
	gdouble height = 0.0;
	gdouble chart_x = 0.0;
	gdouble chart_y = 0.0;
	gdouble chart_width = 0.0;
	gdouble chart_height = 0.0;
	gint days_count = 0;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	gdouble* pomodoro_values = NULL;
	gdouble* _tmp5_;
	gint pomodoro_values_length1;
	gint _pomodoro_values_size_;
	gdouble* total_values = NULL;
	gdouble* _tmp6_;
	gint total_values_length1;
	gint _total_values_size_;
	gdouble reference_value = 0.0;
	PomodoroStatsPageDrawChartFunc draw_chart_func = NULL;
	gpointer draw_chart_func_target;
	GDestroyNotify draw_chart_func_target_destroy_notify;
	gdouble label_x = 0.0;
	gdouble label_y = 0.0;
	gdouble label_width = 0.0;
	gdouble label_height = 0.0;
	cairo_text_extents_t label_extents = {0};
	GdkRGBA theme_fg_color = {0};
	GtkStyleContext* _tmp7_;
	GdkRGBA _tmp8_ = {0};
	GdkRGBA theme_bg_color = {0};
	GdkRGBA theme_selected_bg_color = {0};
	GtkStyleContext* _tmp9_;
	GdkRGBA _tmp10_ = {0};
	GtkStyleContext* _tmp11_;
	GdkRGBA _tmp12_ = {0};
	GdkRGBA _tmp13_;
	GdkRGBA _tmp14_;
	GdkRGBA _tmp15_;
	GdkRGBA _tmp16_;
	GdkRGBA _tmp52_;
	GdkRGBA _tmp53_;
	GdkRGBA _tmp54_;
	GdkRGBA _tmp55_;
	GdkRGBA _tmp56_;
	GdkRGBA _tmp57_;
	GdkRGBA _tmp58_;
	GdkRGBA _tmp59_;
	PomodoroStatsPageDrawChartFunc _tmp60_;
	gpointer _tmp60__target;
	gdouble* _tmp61_;
	gint _tmp61__length1;
	GdkRGBA _tmp62_;
	GdkRGBA _tmp63_;
	GdkRGBA _tmp64_;
	GdkRGBA _tmp65_;
	PomodoroStatsPageDrawChartFunc _tmp66_;
	gpointer _tmp66__target;
	gdouble* _tmp67_;
	gint _tmp67__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_context = _tmp1_;
	width = (gdouble) gtk_widget_get_allocated_width (widget);
	height = (gdouble) gtk_widget_get_allocated_height (widget);
	chart_x = POMODORO_STATS_PAGE_GUIDES_WIDTH + POMODORO_STATS_PAGE_CHART_PADDING;
	chart_y = 0.0;
	chart_width = width - (2.0 * (POMODORO_STATS_PAGE_GUIDES_WIDTH + POMODORO_STATS_PAGE_CHART_PADDING));
	chart_height = (height - POMODORO_STATS_PAGE_LABEL_OFFSET) - POMODORO_STATS_PAGE_LABEL_HEIGHT;
	_tmp2_ = self->priv->_date_end;
	_tmp3_ = pomodoro_stats_page_get_date (self);
	_tmp4_ = _tmp3_;
	days_count = (gint) (g_date_time_difference (_tmp2_, _tmp4_) / G_TIME_SPAN_DAY);
	_tmp5_ = g_new0 (gdouble, days_count);
	pomodoro_values = _tmp5_;
	pomodoro_values_length1 = days_count;
	_pomodoro_values_size_ = pomodoro_values_length1;
	_tmp6_ = g_new0 (gdouble, days_count);
	total_values = _tmp6_;
	total_values_length1 = days_count;
	_total_values_size_ = total_values_length1;
	reference_value = MAX ((gdouble) self->daily_reference_value, 3600.0);
	draw_chart_func = (PomodoroStatsPageDrawChartFunc) pomodoro_stats_page_draw_bar_chart;
	draw_chart_func_target = NULL;
	draw_chart_func_target_destroy_notify = NULL;
	label_x = chart_x;
	label_y = chart_y + chart_height;
	label_width = chart_width / ((gdouble) days_count);
	label_height = POMODORO_STATS_PAGE_LABEL_HEIGHT;
	if (days_count > 7) {
		(draw_chart_func_target_destroy_notify == NULL) ? NULL : (draw_chart_func_target_destroy_notify (draw_chart_func_target), NULL);
		draw_chart_func = NULL;
		draw_chart_func_target = NULL;
		draw_chart_func_target_destroy_notify = NULL;
		draw_chart_func = (PomodoroStatsPageDrawChartFunc) pomodoro_stats_page_draw_line_chart;
		draw_chart_func_target = NULL;
		draw_chart_func_target_destroy_notify = NULL;
	}
	_tmp7_ = style_context;
	gtk_style_context_get_color (_tmp7_, gtk_widget_get_state_flags (widget), &_tmp8_);
	theme_fg_color = _tmp8_;
	_tmp9_ = style_context;
	gtk_style_context_lookup_color (_tmp9_, "theme_selected_bg_color", &_tmp10_);
	theme_selected_bg_color = _tmp10_;
	_tmp11_ = style_context;
	gtk_style_context_lookup_color (_tmp11_, "theme_bg_color", &_tmp12_);
	theme_bg_color = _tmp12_;
	cairo_select_font_face (context, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL);
	cairo_set_font_size (context, 13.0);
	_tmp13_ = theme_fg_color;
	_tmp14_ = theme_fg_color;
	_tmp15_ = theme_fg_color;
	_tmp16_ = theme_fg_color;
	cairo_set_source_rgba (context, _tmp13_.red, _tmp14_.green, _tmp15_.blue, _tmp16_.alpha);
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				GDateTime* date = NULL;
				GDateTime* _tmp19_;
				GDateTime* _tmp20_;
				GDateTime* _tmp21_;
				PomodoroStatsPageData* day = NULL;
				GHashTable* _tmp22_;
				GDateTime* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gconstpointer _tmp26_;
				PomodoroStatsPageData* _tmp27_;
				PomodoroStatsPageData* _tmp28_;
				PomodoroStatsPageData* _tmp29_;
				gboolean _tmp37_ = FALSE;
				gchar* _tmp39_ = NULL;
				gchar* label_text = NULL;
				gchar* _tmp44_;
				const gchar* _tmp45_;
				cairo_text_extents_t _tmp46_ = {0};
				cairo_text_extents_t _tmp47_;
				cairo_text_extents_t _tmp48_;
				cairo_text_extents_t _tmp49_;
				cairo_text_extents_t _tmp50_;
				const gchar* _tmp51_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = index;
					index = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(index < days_count)) {
					break;
				}
				_tmp19_ = pomodoro_stats_page_get_date (self);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_date_time_add_days (_tmp20_, index);
				date = _tmp21_;
				_tmp22_ = self->priv->days;
				_tmp23_ = date;
				_tmp24_ = g_date_time_format (_tmp23_, "%Y-%m-%d");
				_tmp25_ = _tmp24_;
				_tmp26_ = g_hash_table_lookup (_tmp22_, _tmp25_);
				_tmp27_ = _pomodoro_stats_page_data_dup0 ((PomodoroStatsPageData*) _tmp26_);
				_tmp28_ = _tmp27_;
				_g_free0 (_tmp25_);
				day = _tmp28_;
				_tmp29_ = day;
				if (_tmp29_ != NULL) {
					gdouble* _tmp30_;
					gint _tmp30__length1;
					PomodoroStatsPageData* _tmp31_;
					gdouble* _tmp32_;
					gint _tmp32__length1;
					PomodoroStatsPageData* _tmp33_;
					PomodoroStatsPageData* _tmp34_;
					_tmp30_ = pomodoro_values;
					_tmp30__length1 = pomodoro_values_length1;
					_tmp31_ = day;
					_tmp30_[index] = (*_tmp31_).pomodoro_elapsed / reference_value;
					_tmp32_ = total_values;
					_tmp32__length1 = total_values_length1;
					_tmp33_ = day;
					_tmp34_ = day;
					_tmp32_[index] = ((*_tmp33_).pomodoro_elapsed + (*_tmp34_).break_elapsed) / reference_value;
				} else {
					gdouble* _tmp35_;
					gint _tmp35__length1;
					gdouble* _tmp36_;
					gint _tmp36__length1;
					_tmp35_ = pomodoro_values;
					_tmp35__length1 = pomodoro_values_length1;
					_tmp35_[index] = 0.0;
					_tmp36_ = total_values;
					_tmp36__length1 = total_values_length1;
					_tmp36_[index] = 0.0;
				}
				if (days_count > 7) {
					GDateTime* _tmp38_;
					_tmp38_ = date;
					_tmp37_ = g_date_time_get_day_of_week (_tmp38_) != 1;
				} else {
					_tmp37_ = FALSE;
				}
				if (_tmp37_) {
					_pomodoro_stats_page_data_free0 (day);
					_g_date_time_unref0 (date);
					continue;
				}
				if (days_count <= 7) {
					GDateTime* _tmp40_;
					gchar* _tmp41_;
					_tmp40_ = date;
					_tmp41_ = pomodoro_stats_page_format_day_of_week (_tmp40_);
					_g_free0 (_tmp39_);
					_tmp39_ = _tmp41_;
				} else {
					GDateTime* _tmp42_;
					gchar* _tmp43_;
					_tmp42_ = date;
					_tmp43_ = pomodoro_stats_page_format_day_of_month (_tmp42_);
					_g_free0 (_tmp39_);
					_tmp39_ = _tmp43_;
				}
				_tmp44_ = g_strdup (_tmp39_);
				label_text = _tmp44_;
				label_x = chart_x + (label_width * ((gdouble) index));
				_tmp45_ = label_text;
				cairo_text_extents (context, _tmp45_, &_tmp46_);
				label_extents = _tmp46_;
				_tmp47_ = label_extents;
				_tmp48_ = label_extents;
				_tmp49_ = label_extents;
				_tmp50_ = label_extents;
				cairo_move_to (context, (label_x + ((label_width - _tmp47_.width) * 0.5)) - _tmp48_.x_bearing, (label_y + ((label_height - _tmp49_.height) * 0.5)) - _tmp50_.y_bearing);
				_tmp51_ = label_text;
				cairo_show_text (context, _tmp51_);
				_g_free0 (label_text);
				_g_free0 (_tmp39_);
				_pomodoro_stats_page_data_free0 (day);
				_g_date_time_unref0 (date);
			}
		}
	}
	_tmp52_ = theme_fg_color;
	pomodoro_stats_page_draw_guide_lines (context, reference_value, chart_x - POMODORO_STATS_PAGE_CHART_PADDING, chart_y, chart_width + (2.0 * POMODORO_STATS_PAGE_CHART_PADDING), chart_height, &_tmp52_);
	cairo_rectangle (context, 0.0, chart_y, width, chart_height);
	cairo_clip (context);
	_tmp53_ = theme_selected_bg_color;
	_tmp54_ = theme_bg_color;
	_tmp55_ = theme_selected_bg_color;
	_tmp56_ = theme_bg_color;
	_tmp57_ = theme_selected_bg_color;
	_tmp58_ = theme_bg_color;
	_tmp59_ = theme_selected_bg_color;
	cairo_set_source_rgba (context, (_tmp53_.red * 0.8) + (_tmp54_.red * 0.2), (_tmp55_.green * 0.8) + (_tmp56_.green * 0.2), (_tmp57_.blue * 0.8) + (_tmp58_.blue * 0.2), _tmp59_.alpha * 0.6);
	_tmp60_ = draw_chart_func;
	_tmp60__target = draw_chart_func_target;
	_tmp61_ = total_values;
	_tmp61__length1 = total_values_length1;
	_tmp60_ (context, _tmp61_, (gint) _tmp61__length1, chart_x, chart_y, chart_width, chart_height, _tmp60__target);
	cairo_fill (context);
	_tmp62_ = theme_selected_bg_color;
	_tmp63_ = theme_selected_bg_color;
	_tmp64_ = theme_selected_bg_color;
	_tmp65_ = theme_selected_bg_color;
	cairo_set_source_rgba (context, _tmp62_.red, _tmp63_.green, _tmp64_.blue, _tmp65_.alpha);
	_tmp66_ = draw_chart_func;
	_tmp66__target = draw_chart_func_target;
	_tmp67_ = pomodoro_values;
	_tmp67__length1 = pomodoro_values_length1;
	_tmp66_ (context, _tmp67_, (gint) _tmp67__length1, chart_x, chart_y, chart_width, chart_height, _tmp66__target);
	cairo_fill (context);
	result = FALSE;
	(draw_chart_func_target_destroy_notify == NULL) ? NULL : (draw_chart_func_target_destroy_notify (draw_chart_func_target), NULL);
	draw_chart_func = NULL;
	draw_chart_func_target = NULL;
	draw_chart_func_target_destroy_notify = NULL;
	total_values = (g_free (total_values), NULL);
	pomodoro_values = (g_free (pomodoro_values), NULL);
	_g_object_unref0 (style_context);
	return result;
}

static gboolean
_pomodoro_stats_page_on_timeline_chart_draw_gtk_widget_draw (GtkWidget* _sender,
                                                             cairo_t* cr,
                                                             gpointer self)
{
	gboolean result;
	result = pomodoro_stats_page_on_timeline_chart_draw ((PomodoroStatsPage*) self, _sender, cr);
	return result;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		PomodoroStatsPage* self;
		self = _data16_->self;
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
__lambda9_ (Block16Data* _data16_,
            const gchar* date_string,
            PomodoroStatsPageData* data)
{
	PomodoroStatsPage* self;
	self = _data16_->self;
	g_return_if_fail (date_string != NULL);
	_data16_->totals.pomodoro_elapsed = _data16_->totals.pomodoro_elapsed + (*data).pomodoro_elapsed;
	_data16_->totals.break_elapsed = _data16_->totals.break_elapsed + (*data).break_elapsed;
}

static void
___lambda9__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda9_ (self, (const gchar*) key, (PomodoroStatsPageData*) value);
}

static gboolean
pomodoro_stats_page_on_totals_chart_draw (PomodoroStatsPage* self,
                                          GtkWidget* widget,
                                          cairo_t* context)
{
	Block16Data* _data16_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gdouble width = 0.0;
	gdouble height = 0.0;
	gdouble chart_x = 0.0;
	gdouble chart_y = 0.0;
	gdouble chart_width = 0.0;
	gdouble chart_height = 0.0;
	gdouble reference_value = 0.0;
	gdouble bar_x = 0.0;
	gdouble bar_y = 0.0;
	gdouble bar_width = 0.0;
	gdouble bar_height = 0.0;
	gdouble bar_spacing = 0.0;
	gdouble label_x = 0.0;
	gdouble label_y = 0.0;
	gdouble label_width = 0.0;
	gdouble label_height = 0.0;
	GdkRGBA theme_selected_bg_color = {0};
	GdkRGBA theme_border_color = {0};
	GdkRGBA theme_fg_color = {0};
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_ = {0};
	GdkRGBA _tmp4_ = {0};
	GHashTable* _tmp5_;
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	GdkRGBA _tmp9_;
	GdkRGBA _tmp10_;
	PomodoroStatsPageData _tmp11_;
	GdkRGBA _tmp12_;
	GdkRGBA _tmp13_;
	GdkRGBA _tmp14_;
	GdkRGBA _tmp15_;
	PomodoroStatsPageData _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GdkRGBA _tmp19_;
	GdkRGBA _tmp20_;
	GdkRGBA _tmp21_;
	GdkRGBA _tmp22_;
	PomodoroStatsPageData _tmp23_;
	GdkRGBA _tmp24_;
	GdkRGBA _tmp25_;
	GdkRGBA _tmp26_;
	GdkRGBA _tmp27_;
	PomodoroStatsPageData _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = gtk_widget_get_style_context (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_context = _tmp1_;
	width = (gdouble) gtk_widget_get_allocated_width (widget);
	height = (gdouble) gtk_widget_get_allocated_height (widget);
	chart_x = POMODORO_STATS_PAGE_GUIDES_WIDTH + POMODORO_STATS_PAGE_CHART_PADDING;
	chart_y = 0.0;
	chart_width = width - (2.0 * (POMODORO_STATS_PAGE_GUIDES_WIDTH + POMODORO_STATS_PAGE_CHART_PADDING));
	chart_height = (height - POMODORO_STATS_PAGE_LABEL_OFFSET) - (2.0 * POMODORO_STATS_PAGE_LABEL_HEIGHT);
	reference_value = MAX ((gdouble) self->reference_value, 3600.0);
	bar_x = 0.0;
	bar_y = chart_y;
	bar_width = POMODORO_STATS_PAGE_BAR_MAX_WIDTH;
	bar_height = chart_height;
	bar_spacing = 20.0;
	label_x = bar_x;
	label_y = bar_y + bar_height;
	label_width = bar_width;
	label_height = POMODORO_STATS_PAGE_LABEL_HEIGHT;
	gtk_style_context_get_color (style_context, gtk_widget_get_state_flags (widget), &_tmp2_);
	theme_fg_color = _tmp2_;
	gtk_style_context_lookup_color (style_context, "theme_selected_bg_color", &_tmp3_);
	theme_selected_bg_color = _tmp3_;
	gtk_style_context_lookup_color (style_context, "borders", &_tmp4_);
	theme_border_color = _tmp4_;
	memset (&_data16_->totals, 0, sizeof (PomodoroStatsPageData));
	_tmp5_ = self->priv->days;
	g_hash_table_foreach (_tmp5_, ___lambda9__gh_func, _data16_);
	_tmp6_ = theme_fg_color;
	pomodoro_stats_page_draw_guide_lines (context, reference_value, chart_x - POMODORO_STATS_PAGE_CHART_PADDING, chart_y, chart_width + (2.0 * POMODORO_STATS_PAGE_CHART_PADDING), chart_height, &_tmp6_);
	bar_x = floor (((chart_x + (chart_width / 2.0)) - (bar_spacing / 2.0)) - bar_width);
	_tmp7_ = theme_selected_bg_color;
	_tmp8_ = theme_selected_bg_color;
	_tmp9_ = theme_selected_bg_color;
	_tmp10_ = theme_selected_bg_color;
	cairo_set_source_rgba (context, _tmp7_.red, _tmp8_.green, _tmp9_.blue, _tmp10_.alpha);
	_tmp11_ = _data16_->totals;
	pomodoro_stats_page_draw_bar (context, _tmp11_.pomodoro_elapsed / reference_value, bar_x, bar_y, bar_width, bar_height);
	cairo_fill (context);
	cairo_select_font_face (context, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	cairo_set_font_size (context, 14.0);
	_tmp12_ = theme_fg_color;
	_tmp13_ = theme_fg_color;
	_tmp14_ = theme_fg_color;
	_tmp15_ = theme_fg_color;
	cairo_set_source_rgba (context, _tmp12_.red, _tmp13_.green, _tmp14_.blue, _tmp15_.alpha);
	label_x = bar_x;
	label_y = (bar_y + bar_height) + POMODORO_STATS_PAGE_LABEL_OFFSET;
	pomodoro_stats_page_draw_label (context, _ ("Pomodoro"), label_x, label_y, label_width, label_height);
	label_y += label_height;
	cairo_select_font_face (context, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL);
	_tmp16_ = _data16_->totals;
	_tmp17_ = pomodoro_stats_page_format_value (_tmp16_.pomodoro_elapsed);
	_tmp18_ = _tmp17_;
	pomodoro_stats_page_draw_label (context, _tmp18_, label_x, label_y, label_width, label_height);
	_g_free0 (_tmp18_);
	bar_x = floor ((chart_x + (chart_width / 2.0)) + (bar_spacing / 2.0));
	_tmp19_ = theme_selected_bg_color;
	_tmp20_ = theme_selected_bg_color;
	_tmp21_ = theme_selected_bg_color;
	_tmp22_ = theme_selected_bg_color;
	cairo_set_source_rgba (context, _tmp19_.red, _tmp20_.green, _tmp21_.blue, _tmp22_.alpha);
	_tmp23_ = _data16_->totals;
	pomodoro_stats_page_draw_bar (context, _tmp23_.break_elapsed / reference_value, bar_x, bar_y, bar_width, bar_height);
	cairo_fill (context);
	cairo_select_font_face (context, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	cairo_set_font_size (context, 14.0);
	_tmp24_ = theme_fg_color;
	_tmp25_ = theme_fg_color;
	_tmp26_ = theme_fg_color;
	_tmp27_ = theme_fg_color;
	cairo_set_source_rgba (context, _tmp24_.red, _tmp25_.green, _tmp26_.blue, _tmp27_.alpha);
	label_x = bar_x;
	label_y = (bar_y + bar_height) + POMODORO_STATS_PAGE_LABEL_OFFSET;
	pomodoro_stats_page_draw_label (context, _ ("Break"), label_x, label_y, label_width, label_height);
	label_y += label_height;
	cairo_select_font_face (context, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL);
	_tmp28_ = _data16_->totals;
	_tmp29_ = pomodoro_stats_page_format_value (_tmp28_.break_elapsed);
	_tmp30_ = _tmp29_;
	pomodoro_stats_page_draw_label (context, _tmp30_, label_x, label_y, label_width, label_height);
	_g_free0 (_tmp30_);
	result = FALSE;
	_g_object_unref0 (style_context);
	block16_data_unref (_data16_);
	_data16_ = NULL;
	return result;
}

static gboolean
_pomodoro_stats_page_on_totals_chart_draw_gtk_widget_draw (GtkWidget* _sender,
                                                           cairo_t* cr,
                                                           gpointer self)
{
	gboolean result;
	result = pomodoro_stats_page_on_totals_chart_draw ((PomodoroStatsPage*) self, _sender, cr);
	return result;
}

static void
__lambda12_ (PomodoroStatsPage* self,
             GObject* obj,
             GAsyncResult* res)
{
	GtkDrawingArea* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GtkDrawingArea* _tmp6_;
	GtkSpinner* _tmp7_;
	GtkDrawingArea* _tmp8_;
	GtkDrawingArea* _tmp10_;
	g_return_if_fail (res != NULL);
	pomodoro_stats_page_fetch_finish (self, res);
	_tmp0_ = self->timeline_chart;
	_tmp1_ = self->priv->_date_end;
	_tmp2_ = pomodoro_stats_page_get_date (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_date_time_add_weeks (_tmp3_, 1);
	_tmp5_ = _tmp4_;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, g_date_time_compare (_tmp1_, _tmp5_) >= 0);
	_g_date_time_unref0 (_tmp5_);
	_tmp6_ = self->totals_chart;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = self->spinner;
	g_object_set (_tmp7_, "active", FALSE, NULL);
	_tmp8_ = self->timeline_chart;
	if (gtk_widget_get_mapped ((GtkWidget*) _tmp8_)) {
		GtkDrawingArea* _tmp9_;
		_tmp9_ = self->timeline_chart;
		gtk_widget_queue_draw ((GtkWidget*) _tmp9_);
	}
	_tmp10_ = self->totals_chart;
	if (gtk_widget_get_mapped ((GtkWidget*) _tmp10_)) {
		GtkDrawingArea* _tmp11_;
		_tmp11_ = self->totals_chart;
		gtk_widget_queue_draw ((GtkWidget*) _tmp11_);
	}
}

static void
___lambda12__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda12_ ((PomodoroStatsPage*) self, source_object, res);
	g_object_unref (self);
}

void
pomodoro_stats_page_update (PomodoroStatsPage* self)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GtkDrawingArea* _tmp2_;
	GtkDrawingArea* _tmp3_;
	GtkSpinner* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pomodoro_stats_page_get_next_date (self);
	_tmp1_ = _tmp0_;
	pomodoro_stats_page_set_date_end (self, _tmp1_);
	_g_date_time_unref0 (_tmp1_);
	_tmp2_ = self->timeline_chart;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, FALSE);
	_tmp3_ = self->totals_chart;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->spinner;
	g_object_set (_tmp4_, "active", TRUE, NULL);
	pomodoro_stats_page_fetch (self, ___lambda12__gasync_ready_callback, g_object_ref (self));
}

static void
pomodoro_stats_page_fetch_data_free (gpointer _data)
{
	PomodoroStatsPageFetchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PomodoroStatsPageFetchData, _data_);
}

void
pomodoro_stats_page_fetch (PomodoroStatsPage* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	PomodoroStatsPageFetchData* _data_;
	PomodoroStatsPage* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PomodoroStatsPageFetchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pomodoro_stats_page_fetch_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pomodoro_stats_page_fetch_co (_data_);
}

void
pomodoro_stats_page_fetch_finish (PomodoroStatsPage* self,
                                  GAsyncResult* _res_)
{
	PomodoroStatsPageFetchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		PomodoroStatsPage* self;
		self = _data17_->self;
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static void
pomodoro_stats_page_fetch_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	PomodoroStatsPageFetchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pomodoro_stats_page_fetch_co (_data_);
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		PomodoroStatsPage* self;
		self = _data18_->_data17_->self;
		_g_object_unref0 (_data18_->group);
		block17_data_unref (_data18_->_data17_);
		_data18_->_data17_ = NULL;
		g_slice_free (Block18Data, _data18_);
	}
}

static void
____lambda11_ (Block18Data* _data18_,
               GObject* obj,
               GAsyncResult* res)
{
	Block17Data* _data17_;
	PomodoroStatsPage* self;
	GError* _inner_error0_ = NULL;
	_data17_ = _data18_->_data17_;
	self = _data17_->self;
	g_return_if_fail (res != NULL);
	{
		gom_resource_group_fetch_finish (_data18_->group, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			gint index = 0;
			index = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					guint _tmp2_;
					guint _tmp3_;
					PomodoroAggregatedEntry* aggregated_entry = NULL;
					GomResource* _tmp4_;
					PomodoroAggregatedEntry* _tmp5_;
					PomodoroStatsPageData* day = NULL;
					GHashTable* _tmp6_;
					PomodoroAggregatedEntry* _tmp7_;
					const gchar* _tmp8_;
					const gchar* _tmp9_;
					gconstpointer _tmp10_;
					PomodoroStatsPageData* _tmp11_;
					PomodoroStatsPageData* _tmp12_;
					PomodoroAggregatedEntry* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					GQuark _tmp20_ = 0U;
					static GQuark _tmp19_label0 = 0;
					static GQuark _tmp19_label1 = 0;
					static GQuark _tmp19_label2 = 0;
					static GQuark _tmp19_label3 = 0;
					GHashTable* _tmp31_;
					PomodoroAggregatedEntry* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					PomodoroStatsPageData* _tmp36_;
					PomodoroStatsPageData* _tmp37_;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = index;
						index = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					_tmp2_ = gom_resource_group_get_count (_data18_->group);
					_tmp3_ = _tmp2_;
					if (!(((guint) index) < _tmp3_)) {
						break;
					}
					_tmp4_ = gom_resource_group_get_index (_data18_->group, (guint) index);
					_tmp5_ = _g_object_ref0 (POMODORO_IS_AGGREGATED_ENTRY (_tmp4_) ? ((PomodoroAggregatedEntry*) _tmp4_) : NULL);
					aggregated_entry = _tmp5_;
					_tmp6_ = self->priv->days;
					_tmp7_ = aggregated_entry;
					_tmp8_ = pomodoro_aggregated_entry_get_date_string (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_hash_table_lookup (_tmp6_, _tmp9_);
					_tmp11_ = _pomodoro_stats_page_data_dup0 ((PomodoroStatsPageData*) _tmp10_);
					day = _tmp11_;
					_tmp12_ = day;
					if (_tmp12_ == NULL) {
						PomodoroStatsPageData _tmp13_ = {0};
						PomodoroStatsPageData* _tmp14_;
						memset (&_tmp13_, 0, sizeof (PomodoroStatsPageData));
						_tmp14_ = _pomodoro_stats_page_data_dup0 (&_tmp13_);
						_pomodoro_stats_page_data_free0 (day);
						day = _tmp14_;
					}
					_tmp15_ = aggregated_entry;
					_tmp16_ = pomodoro_aggregated_entry_get_state_name (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = _tmp17_;
					_tmp20_ = (NULL == _tmp18_) ? 0 : g_quark_from_string (_tmp18_);
					if (_tmp20_ == ((0 != _tmp19_label0) ? _tmp19_label0 : (_tmp19_label0 = g_quark_from_static_string ("pomodoro")))) {
						switch (0) {
							default:
							{
								PomodoroStatsPageData* _tmp21_;
								PomodoroStatsPageData* _tmp22_;
								PomodoroAggregatedEntry* _tmp23_;
								gint64 _tmp24_;
								gint64 _tmp25_;
								_tmp21_ = day;
								_tmp22_ = day;
								_tmp23_ = aggregated_entry;
								_tmp24_ = pomodoro_aggregated_entry_get_elapsed (_tmp23_);
								_tmp25_ = _tmp24_;
								(*_tmp22_).pomodoro_elapsed = (*_tmp22_).pomodoro_elapsed + _tmp25_;
								break;
							}
						}
					} else if (((_tmp20_ == ((0 != _tmp19_label1) ? _tmp19_label1 : (_tmp19_label1 = g_quark_from_static_string ("break")))) || (_tmp20_ == ((0 != _tmp19_label2) ? _tmp19_label2 : (_tmp19_label2 = g_quark_from_static_string ("short-break"))))) || (_tmp20_ == ((0 != _tmp19_label3) ? _tmp19_label3 : (_tmp19_label3 = g_quark_from_static_string ("long-break"))))) {
						switch (0) {
							default:
							{
								PomodoroStatsPageData* _tmp26_;
								PomodoroStatsPageData* _tmp27_;
								PomodoroAggregatedEntry* _tmp28_;
								gint64 _tmp29_;
								gint64 _tmp30_;
								_tmp26_ = day;
								_tmp27_ = day;
								_tmp28_ = aggregated_entry;
								_tmp29_ = pomodoro_aggregated_entry_get_elapsed (_tmp28_);
								_tmp30_ = _tmp29_;
								(*_tmp27_).break_elapsed = (*_tmp27_).break_elapsed + _tmp30_;
								break;
							}
						}
					} else {
						switch (0) {
							default:
							{
								break;
							}
						}
					}
					_tmp31_ = self->priv->days;
					_tmp32_ = aggregated_entry;
					_tmp33_ = pomodoro_aggregated_entry_get_date_string (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = g_strdup (_tmp34_);
					_tmp36_ = day;
					_tmp37_ = _pomodoro_stats_page_data_dup0 (_tmp36_);
					g_hash_table_insert (_tmp31_, _tmp35_, _tmp37_);
					_pomodoro_stats_page_data_free0 (day);
					_g_object_unref0 (aggregated_entry);
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = _error_;
		_tmp39_ = _tmp38_->message;
		g_critical ("stats-page.vala:671: %s", _tmp39_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda11__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda11_ (self, source_object, res);
	block18_data_unref (self);
}

static void
__lambda10_ (Block17Data* _data17_,
             GObject* obj,
             GAsyncResult* res)
{
	PomodoroStatsPage* self;
	GError* _inner_error0_ = NULL;
	self = _data17_->self;
	g_return_if_fail (res != NULL);
	{
		Block18Data* _data18_;
		GomRepository* _tmp0_;
		GomResourceGroup* _tmp1_;
		guint _tmp2_;
		guint _tmp3_;
		_data18_ = g_slice_new0 (Block18Data);
		_data18_->_ref_count_ = 1;
		_data18_->_data17_ = block17_data_ref (_data17_);
		_tmp0_ = self->repository;
		_tmp1_ = gom_repository_find_finish (_tmp0_, res, &_inner_error0_);
		_data18_->group = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block18_data_unref (_data18_);
			_data18_ = NULL;
			goto __catch0_g_error;
		}
		_tmp2_ = gom_resource_group_get_count (_data18_->group);
		_tmp3_ = _tmp2_;
		if (_tmp3_ > ((guint) 0)) {
			guint _tmp4_;
			guint _tmp5_;
			_tmp4_ = gom_resource_group_get_count (_data18_->group);
			_tmp5_ = _tmp4_;
			gom_resource_group_fetch_async (_data18_->group, (guint) 0, _tmp5_, _____lambda11__gasync_ready_callback, block18_data_ref (_data18_));
		}
		block18_data_unref (_data18_);
		_data18_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_critical ("stats-page.vala:677: %s", _tmp7_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	self->reference_value = _data17_->reference_value;
	self->daily_reference_value = (guint64) _data17_->daily_reference_value;
	pomodoro_stats_page_fetch_co (_data17_->_async_data_);
}

static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda10_ (self, source_object, res);
	block17_data_unref (self);
}

static gboolean
pomodoro_stats_page_fetch_co (PomodoroStatsPageFetchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data17_ = g_slice_new0 (Block17Data);
	_data_->_data17_->_ref_count_ = 1;
	_data_->_data17_->self = g_object_ref (_data_->self);
	_data_->_data17_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->days;
	g_hash_table_remove_all (_data_->_tmp0_);
	_data_->_tmp1_ = pomodoro_stats_page_get_date (_data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_date_time_format (_data_->_tmp2_, POMODORO_AGGREGATED_ENTRY_DATE_FORMAT);
	_data_->date_start = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->self->priv->_date_end;
	_data_->_tmp5_ = g_date_time_format (_data_->_tmp4_, POMODORO_AGGREGATED_ENTRY_DATE_FORMAT);
	_data_->date_end = _data_->_tmp5_;
	memset (&_data_->_tmp6_, 0, sizeof (GValue));
	g_value_init (&_data_->_tmp6_, G_TYPE_STRING);
	g_value_set_string (&_data_->_tmp6_, _data_->date_start);
	_data_->_tmp7_ = gom_filter_new_gte (POMODORO_TYPE_AGGREGATED_ENTRY, "date-string", &_data_->_tmp6_);
	g_object_ref_sink (_data_->_tmp7_);
	_data_->_tmp8_ = _data_->_tmp7_;
	memset (&_data_->_tmp9_, 0, sizeof (GValue));
	g_value_init (&_data_->_tmp9_, G_TYPE_STRING);
	g_value_set_string (&_data_->_tmp9_, _data_->date_end);
	_data_->_tmp10_ = gom_filter_new_lt (POMODORO_TYPE_AGGREGATED_ENTRY, "date-string", &_data_->_tmp9_);
	g_object_ref_sink (_data_->_tmp10_);
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp12_ = gom_filter_new_and (_data_->_tmp8_, _data_->_tmp11_);
	g_object_ref_sink (_data_->_tmp12_);
	_data_->_tmp13_ = _data_->_tmp12_;
	_g_object_unref0 (_data_->_tmp11_);
	G_IS_VALUE (&_data_->_tmp9_) ? (g_value_unset (&_data_->_tmp9_), NULL) : NULL;
	_g_object_unref0 (_data_->_tmp8_);
	G_IS_VALUE (&_data_->_tmp6_) ? (g_value_unset (&_data_->_tmp6_), NULL) : NULL;
	_data_->filter = _data_->_tmp13_;
	_data_->_state_ = 1;
	pomodoro_stats_page_get_reference_value (_data_->self, pomodoro_stats_page_fetch_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_data17_->reference_value = pomodoro_stats_page_get_reference_value_finish (_data_->self, _data_->_res_);
	_data_->_state_ = 2;
	pomodoro_aggregated_entry_get_baseline_daily_elapsed (pomodoro_stats_page_fetch_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_data17_->daily_reference_value = pomodoro_aggregated_entry_get_baseline_daily_elapsed_finish (_data_->_res_);
	_data_->_tmp14_ = _data_->self->repository;
	_data_->_tmp15_ = _data_->filter;
	gom_repository_find_async (_data_->_tmp14_, POMODORO_TYPE_AGGREGATED_ENTRY, _data_->_tmp15_, ___lambda10__gasync_ready_callback, block17_data_ref (_data_->_data17_));
	_data_->_state_ = 3;
	return FALSE;
	_state_3:
	;
	_g_object_unref0 (_data_->filter);
	_g_free0 (_data_->date_end);
	_g_free0 (_data_->date_start);
	block17_data_unref (_data_->_data17_);
	_data_->_data17_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
pomodoro_stats_page_real_format_datetime (PomodoroStatsPage* self,
                                          GDateTime* date)
{
	g_return_val_if_fail (date != NULL, NULL);
	g_assert_not_reached ();
}

gchar*
pomodoro_stats_page_format_datetime (PomodoroStatsPage* self,
                                     GDateTime* date)
{
	PomodoroStatsPageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = POMODORO_STATS_PAGE_GET_CLASS (self);
	if (_klass_->format_datetime) {
		return _klass_->format_datetime (self, date);
	}
	return NULL;
}

static GDateTime*
pomodoro_stats_page_real_get_previous_date (PomodoroStatsPage* self)
{
	g_assert_not_reached ();
}

GDateTime*
pomodoro_stats_page_get_previous_date (PomodoroStatsPage* self)
{
	PomodoroStatsPageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = POMODORO_STATS_PAGE_GET_CLASS (self);
	if (_klass_->get_previous_date) {
		return _klass_->get_previous_date (self);
	}
	return NULL;
}

static GDateTime*
pomodoro_stats_page_real_get_next_date (PomodoroStatsPage* self)
{
	g_assert_not_reached ();
}

GDateTime*
pomodoro_stats_page_get_next_date (PomodoroStatsPage* self)
{
	PomodoroStatsPageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = POMODORO_STATS_PAGE_GET_CLASS (self);
	if (_klass_->get_next_date) {
		return _klass_->get_next_date (self);
	}
	return NULL;
}

static void
pomodoro_stats_page_real_get_reference_value_data_free (gpointer _data)
{
	PomodoroStatsPageGetReferenceValueData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PomodoroStatsPageGetReferenceValueData, _data_);
}

static void
pomodoro_stats_page_real_get_reference_value (PomodoroStatsPage* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	PomodoroStatsPageGetReferenceValueData* _data_;
	PomodoroStatsPage* _tmp0_;
	_data_ = g_slice_new0 (PomodoroStatsPageGetReferenceValueData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pomodoro_stats_page_real_get_reference_value_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pomodoro_stats_page_real_get_reference_value_co (_data_);
}

static guint64
pomodoro_stats_page_real_get_reference_value_finish (PomodoroStatsPage* self,
                                                     GAsyncResult* _res_)
{
	guint64 result;
	PomodoroStatsPageGetReferenceValueData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static gboolean
pomodoro_stats_page_real_get_reference_value_co (PomodoroStatsPageGetReferenceValueData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->result = (guint64) 0;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
pomodoro_stats_page_get_reference_value (PomodoroStatsPage* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	PomodoroStatsPageClass* _klass_;
	_klass_ = POMODORO_STATS_PAGE_GET_CLASS (self);
	if (_klass_->get_reference_value) {
		_klass_->get_reference_value (self, _callback_, _user_data_);
	}
}

guint64
pomodoro_stats_page_get_reference_value_finish (PomodoroStatsPage* self,
                                                GAsyncResult* _res_)
{
	PomodoroStatsPageClass* _klass_;
	_klass_ = POMODORO_STATS_PAGE_GET_CLASS (self);
	if (_klass_->get_reference_value_finish) {
		return _klass_->get_reference_value_finish (self, _res_);
	}
	return 0ULL;
}

PomodoroStatsPage*
pomodoro_stats_page_construct (GType object_type)
{
	PomodoroStatsPage * self = NULL;
	self = (PomodoroStatsPage*) g_object_new (object_type, NULL);
	return self;
}

GDateTime*
pomodoro_stats_page_get_date (PomodoroStatsPage* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_date;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
pomodoro_stats_page_set_date (PomodoroStatsPage* self,
                              GDateTime* value)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->_date);
	self->_date = _tmp0_;
	_tmp1_ = self->_date;
	_tmp2_ = pomodoro_stats_page_format_datetime (self, _tmp1_);
	_tmp3_ = _tmp2_;
	pomodoro_stats_page_set_title (self, _tmp3_);
	_g_free0 (_tmp3_);
	g_object_notify_by_pspec ((GObject *) self, pomodoro_stats_page_properties[POMODORO_STATS_PAGE_DATE_PROPERTY]);
}

GDateTime*
pomodoro_stats_page_get_date_end (PomodoroStatsPage* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date_end;
	result = _tmp0_;
	return result;
}

void
pomodoro_stats_page_set_date_end (PomodoroStatsPage* self,
                                  GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_stats_page_get_date_end (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_date_end);
		self->priv->_date_end = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_stats_page_properties[POMODORO_STATS_PAGE_DATE_END_PROPERTY]);
	}
}

const gchar*
pomodoro_stats_page_get_title (PomodoroStatsPage* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

void
pomodoro_stats_page_set_title (PomodoroStatsPage* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_stats_page_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_stats_page_properties[POMODORO_STATS_PAGE_TITLE_PROPERTY]);
	}
}

static PomodoroStatsPageData*
pomodoro_stats_page_data_dup (const PomodoroStatsPageData* self)
{
	PomodoroStatsPageData* dup;
	dup = g_new0 (PomodoroStatsPageData, 1);
	memcpy (dup, self, sizeof (PomodoroStatsPageData));
	return dup;
}

static void
pomodoro_stats_page_data_free (PomodoroStatsPageData* self)
{
	g_free (self);
}

static GType
pomodoro_stats_page_data_get_type_once (void)
{
	GType pomodoro_stats_page_data_type_id;
	pomodoro_stats_page_data_type_id = g_boxed_type_register_static ("PomodoroStatsPageData", (GBoxedCopyFunc) pomodoro_stats_page_data_dup, (GBoxedFreeFunc) pomodoro_stats_page_data_free);
	return pomodoro_stats_page_data_type_id;
}

static GType
pomodoro_stats_page_data_get_type (void)
{
	static volatile gsize pomodoro_stats_page_data_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_stats_page_data_type_id__once)) {
		GType pomodoro_stats_page_data_type_id;
		pomodoro_stats_page_data_type_id = pomodoro_stats_page_data_get_type_once ();
		g_once_init_leave (&pomodoro_stats_page_data_type_id__once, pomodoro_stats_page_data_type_id);
	}
	return pomodoro_stats_page_data_type_id__once;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_pomodoro_stats_page_data_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (pomodoro_stats_page_data_free (var), NULL));
}

static GObject *
pomodoro_stats_page_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroStatsPage * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	parent_class = G_OBJECT_CLASS (pomodoro_stats_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_STATS_PAGE, PomodoroStatsPage);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _pomodoro_stats_page_data_free0_);
	_g_hash_table_unref0 (self->priv->days);
	self->priv->days = _tmp2_;
	return obj;
}

static void
pomodoro_stats_page_class_init (PomodoroStatsPageClass * klass,
                                gpointer klass_data)
{
	pomodoro_stats_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroStatsPage_private_offset);
	((PomodoroStatsPageClass *) klass)->format_datetime = (gchar* (*) (PomodoroStatsPage*, GDateTime*)) pomodoro_stats_page_real_format_datetime;
	((PomodoroStatsPageClass *) klass)->get_previous_date = (GDateTime* (*) (PomodoroStatsPage*)) pomodoro_stats_page_real_get_previous_date;
	((PomodoroStatsPageClass *) klass)->get_next_date = (GDateTime* (*) (PomodoroStatsPage*)) pomodoro_stats_page_real_get_next_date;
	((PomodoroStatsPageClass *) klass)->get_reference_value = (void (*) (PomodoroStatsPage*, GAsyncReadyCallback, gpointer)) pomodoro_stats_page_real_get_reference_value;
	((PomodoroStatsPageClass *) klass)->get_reference_value_finish = (guint64 (*) (PomodoroStatsPage*, GAsyncResult*)) pomodoro_stats_page_real_get_reference_value_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_pomodoro_stats_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pomodoro_stats_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = pomodoro_stats_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_stats_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_STATS_PAGE_DATE_PROPERTY, pomodoro_stats_page_properties[POMODORO_STATS_PAGE_DATE_PROPERTY] = g_param_spec_boxed ("date", "date", "date", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_STATS_PAGE_DATE_END_PROPERTY, pomodoro_stats_page_properties[POMODORO_STATS_PAGE_DATE_END_PROPERTY] = g_param_spec_boxed ("date-end", "date-end", "date-end", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_STATS_PAGE_TITLE_PROPERTY, pomodoro_stats_page_properties[POMODORO_STATS_PAGE_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/pomodoro/stats-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinner", FALSE, G_STRUCT_OFFSET (PomodoroStatsPage, spinner));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "timeline_chart", FALSE, G_STRUCT_OFFSET (PomodoroStatsPage, timeline_chart));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "totals_chart", FALSE, G_STRUCT_OFFSET (PomodoroStatsPage, totals_chart));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_timeline_chart_draw", G_CALLBACK(_pomodoro_stats_page_on_timeline_chart_draw_gtk_widget_draw));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_totals_chart_draw", G_CALLBACK(_pomodoro_stats_page_on_totals_chart_draw_gtk_widget_draw));
}

static void
pomodoro_stats_page_gtk_buildable_interface_init (GtkBuildableIface * iface,
                                                  gpointer iface_data)
{
	pomodoro_stats_page_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
}

static void
pomodoro_stats_page_instance_init (PomodoroStatsPage * self,
                                   gpointer klass)
{
	self->priv = pomodoro_stats_page_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
pomodoro_stats_page_finalize (GObject * obj)
{
	PomodoroStatsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_STATS_PAGE, PomodoroStatsPage);
	_g_date_time_unref0 (self->priv->_date_end);
	_g_free0 (self->priv->_title);
	_g_date_time_unref0 (self->_date);
	_g_object_unref0 (self->repository);
	_g_hash_table_unref0 (self->priv->days);
	G_OBJECT_CLASS (pomodoro_stats_page_parent_class)->finalize (obj);
}

static GType
pomodoro_stats_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroStatsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_stats_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroStatsPage), 0, (GInstanceInitFunc) pomodoro_stats_page_instance_init, NULL };
	static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) pomodoro_stats_page_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType pomodoro_stats_page_type_id;
	pomodoro_stats_page_type_id = g_type_register_static (gtk_box_get_type (), "PomodoroStatsPage", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (pomodoro_stats_page_type_id, gtk_buildable_get_type (), &gtk_buildable_info);
	PomodoroStatsPage_private_offset = g_type_add_instance_private (pomodoro_stats_page_type_id, sizeof (PomodoroStatsPagePrivate));
	return pomodoro_stats_page_type_id;
}

GType
pomodoro_stats_page_get_type (void)
{
	static volatile gsize pomodoro_stats_page_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_stats_page_type_id__once)) {
		GType pomodoro_stats_page_type_id;
		pomodoro_stats_page_type_id = pomodoro_stats_page_get_type_once ();
		g_once_init_leave (&pomodoro_stats_page_type_id__once, pomodoro_stats_page_type_id);
	}
	return pomodoro_stats_page_type_id__once;
}

static void
_vala_pomodoro_stats_page_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	PomodoroStatsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_STATS_PAGE, PomodoroStatsPage);
	switch (property_id) {
		case POMODORO_STATS_PAGE_DATE_PROPERTY:
		g_value_set_boxed (value, pomodoro_stats_page_get_date (self));
		break;
		case POMODORO_STATS_PAGE_DATE_END_PROPERTY:
		g_value_set_boxed (value, pomodoro_stats_page_get_date_end (self));
		break;
		case POMODORO_STATS_PAGE_TITLE_PROPERTY:
		g_value_set_string (value, pomodoro_stats_page_get_title (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pomodoro_stats_page_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	PomodoroStatsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_STATS_PAGE, PomodoroStatsPage);
	switch (property_id) {
		case POMODORO_STATS_PAGE_DATE_PROPERTY:
		pomodoro_stats_page_set_date (self, g_value_get_boxed (value));
		break;
		case POMODORO_STATS_PAGE_DATE_END_PROPERTY:
		pomodoro_stats_page_set_date_end (self, g_value_get_boxed (value));
		break;
		case POMODORO_STATS_PAGE_TITLE_PROPERTY:
		pomodoro_stats_page_set_title (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

